/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view;

import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.workbench.TypeNameValueVisitor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.Type;
import org.jboss.tools.hibernate.ui.diagram.editors.model.UtilTypeExtract;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Utils;
import org.jboss.tools.hibernate.ui.view.HibernateUtils;
import org.jboss.tools.hibernate.ui.view.UIViewMessages;

public class OrmLabelMap {
    private static String SPACE = " ";
    private static String POINTER = " -> ";

    private OrmLabelMap() {
    }

    public static String getLabel(Object obj, ConsoleConfiguration cfg) {
        String label = null;
        if (obj instanceof Table) {
            label = OrmLabelMap.getParticularLabel((Table)obj);
        } else if (obj instanceof Column) {
            label = OrmLabelMap.getParticularLabel((Column)obj);
        } else if (obj instanceof Property) {
            label = OrmLabelMap.getParticularLabel((Property)obj, cfg);
        } else if (obj instanceof OneToMany) {
            label = OrmLabelMap.getParticularLabel((OneToMany)obj);
        } else if (obj instanceof SimpleValue) {
            label = OrmLabelMap.getParticularLabel((SimpleValue)obj);
        } else if (obj instanceof PersistentClass) {
            label = OrmLabelMap.getParticularLabel((PersistentClass)obj);
        } else if (obj instanceof String) {
            label = (String)obj;
        } else {
            throw OrmLabelMap.unknownElement(obj);
        }
        if (label == null) {
            label = UIViewMessages.OrmLabelProvider_orm_element;
        }
        return label;
    }

    public static String getParticularLabel(Table table) {
        return Utils.getTableName(table);
    }

    public static String getParticularLabel(Column column) {
        String sqlType = column.getSqlType();
        StringBuffer name = new StringBuffer();
        name.append(column.getName());
        if (sqlType != null) {
            name.append(" [");
            name.append(sqlType.toUpperCase());
            name.append(column.isNullable() ? " Nullable" : "");
            name.append(HibernateUtils.getTable(column) != null && HibernateUtils.isPrimaryKey(column) ? " PK" : "");
            name.append(HibernateUtils.getTable(column) != null && HibernateUtils.isForeignKey(column) ? " FK" : "");
            name.append("]");
        }
        return name.toString();
    }

    public static String getParticularLabel(Property field, ConsoleConfiguration cfg) {
        StringBuffer name = new StringBuffer();
        name.append(field.getName());
        name.append(" :");
        String typeString = null;
        Type type = UtilTypeExtract.getTypeUsingExecContext(field.getValue(), cfg);
        if (type != null && type.getReturnedClass() != null) {
            typeString = type.getReturnedClass().getName();
        } else if (field.getValue() instanceof Component) {
            typeString = ((Component)field.getValue()).getComponentClassName();
        } else if (field.getValue() != null && field.getValue().isSimpleValue()) {
            typeString = ((SimpleValue)field.getValue()).getTypeName();
        }
        if (typeString != null) {
            typeString = OrmLabelMap.correctTypeString(typeString);
            name.append(SPACE);
            name.append(typeString);
            return name.toString();
        }
        Value value = field.getValue();
        String typeName = null;
        if (value != null && (typeName = (String)value.accept((ValueVisitor)new TypeNameValueVisitor(false))) != null) {
            return String.valueOf(field.getName()) + " : " + typeName;
        }
        return field.getName();
    }

    public static String getParticularLabel(OneToMany field) {
        return UIViewMessages.OrmLabelProvider_element;
    }

    public static String getParticularLabel(SimpleValue field) {
        String label = UIViewMessages.OrmLabelProvider_element;
        if (field instanceof DependantValue) {
            label = "key";
        } else if (field instanceof Component) {
            label = "element";
        }
        return label;
    }

    public static String getParticularLabel(PersistentClass persistentClass) {
        String tableName;
        StringBuffer name = new StringBuffer();
        name.append(persistentClass.getEntityName() != null ? persistentClass.getEntityName() : persistentClass.getClassName());
        Table table = persistentClass.getTable();
        if (table != null && (tableName = Utils.getTableName(table)) != null) {
            name.append(POINTER);
            name.append(tableName);
        }
        return name.toString();
    }

    private static String correctTypeString(String str) {
        String ret = str;
        while (ret.startsWith("[")) {
            ret = ret.substring(1).concat("[]");
        }
        switch (ret.toCharArray()[0]) {
            case 'Z': {
                ret = "boolean".concat(ret.substring(1));
                break;
            }
            case 'B': {
                ret = "byte".concat(ret.substring(1));
                break;
            }
            case 'C': {
                ret = "char".concat(ret.substring(1));
                break;
            }
            case 'L': {
                ret = ret.substring(1);
                break;
            }
            case 'D': {
                ret = "double".concat(ret.substring(1));
                break;
            }
            case 'F': {
                ret = "float".concat(ret.substring(1));
                break;
            }
            case 'I': {
                ret = "int".concat(ret.substring(1));
                break;
            }
            case 'J': {
                ret = "long".concat(ret.substring(1));
                break;
            }
            case 'S': {
                ret = "short".concat(ret.substring(1));
            }
        }
        return ret;
    }

    private static RuntimeException unknownElement(Object element) {
        String msg = UIViewMessages.OrmLabelProvider_unknown_type_of_element_in_tree_of_type;
        msg = element != null && element.getClass() != null ? String.valueOf(msg) + element.getClass().getName() : String.valueOf(msg) + element;
        return new RuntimeException(msg);
    }
}

