/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.UiPlugin;
import org.jboss.tools.hibernate.ui.view.DiagramEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDiagramActionDelegate
implements IObjectActionDelegate {
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(IAction action) {
        ObjectPluginAction objectPluginAction = (ObjectPluginAction)action;
        HashMap mapCC_PCs = new HashMap();
        TreePath[] paths = ((TreeSelection)objectPluginAction.getSelection()).getPaths();
        int i = 0;
        while (i < paths.length) {
            Object firstSegment = paths[i].getFirstSegment();
            if (firstSegment instanceof ConsoleConfiguration) {
                Iterator it;
                Configuration config;
                Object last_el;
                ConsoleConfiguration consoleConfig = (ConsoleConfiguration)firstSegment;
                HashSet<PersistentClass> setPC = (HashSet<PersistentClass>)mapCC_PCs.get(consoleConfig);
                if (setPC == null) {
                    setPC = new HashSet<PersistentClass>();
                    mapCC_PCs.put(consoleConfig, setPC);
                }
                if ((last_el = paths[i].getLastSegment()) instanceof PersistentClass) {
                    PersistentClass persClass = (PersistentClass)last_el;
                    setPC.add(persClass);
                } else if (last_el instanceof Configuration) {
                    config = (Configuration)last_el;
                    it = config.getClassMappings();
                    while (it.hasNext()) {
                        setPC.add((PersistentClass)it.next());
                    }
                } else if (last_el instanceof ConsoleConfiguration) {
                    config = consoleConfig.getConfiguration();
                    if (config == null) {
                        try {
                            consoleConfig.build();
                        }
                        catch (HibernateException he) {
                            HibernateConsolePlugin.getDefault().showError(HibernateConsolePlugin.getShell(), String.valueOf(DiagramViewerMessages.OpenDiagramActionDelegate_could_not_load_configuration) + ' ' + consoleConfig.getName(), (Throwable)he);
                        }
                        if (consoleConfig.hasConfiguration()) {
                            consoleConfig.buildMappings();
                        }
                        config = consoleConfig.getConfiguration();
                    }
                    if (config != null) {
                        it = config.getClassMappings();
                        while (it.hasNext()) {
                            setPC.add((PersistentClass)it.next());
                        }
                    }
                }
            }
            ++i;
        }
        for (ConsoleConfiguration consoleConfiguration : mapCC_PCs.keySet()) {
            Set setPC = (Set)mapCC_PCs.get(consoleConfiguration);
            try {
                this.openEditor(setPC, consoleConfiguration);
            }
            catch (PartInitException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Can't open mapping view.", (Throwable)e);
            }
        }
    }

    public IEditorPart openEditor(PersistentClass persClass, ConsoleConfiguration consoleConfig) throws PartInitException {
        DiagramEditorInput input = new DiagramEditorInput(consoleConfig.getName(), persClass.getRootClass());
        return IDE.openEditor((IWorkbenchPage)UiPlugin.getPage(), (IEditorInput)input, (String)"org.jboss.tools.hibernate.ui.diagram.editors.DiagramViewer");
    }

    public IEditorPart openEditor(Set<PersistentClass> setPC, ConsoleConfiguration consoleConfig) throws PartInitException {
        RootClass[] rcArr = new RootClass[setPC.size()];
        PersistentClass persClass2 = null;
        int i = 0;
        for (PersistentClass persClass2 : setPC) {
            rcArr[i++] = persClass2.getRootClass();
        }
        DiagramEditorInput input = new DiagramEditorInput(consoleConfig.getName(), rcArr);
        return IDE.openEditor((IWorkbenchPage)UiPlugin.getPage(), (IEditorInput)input, (String)"org.jboss.tools.hibernate.ui.diagram.editors.DiagramViewer");
    }
}

