/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.rulers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramGuide
implements Serializable {
    public static final String PROPERTY_CHILDREN = "subparts changed";
    public static final String PROPERTY_POSITION = "position changed";
    static final long serialVersionUID = 1L;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Map<OrmShape, Integer> map;
    private int position;
    private boolean horizontal;

    public DiagramGuide() {
    }

    public DiagramGuide(boolean isHorizontal) {
        this.setHorizontal(isHorizontal);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void attachPart(OrmShape part, int alignment) {
        DiagramGuide parent;
        if (this.getMap().containsKey(part) && this.getAlignment(part) == alignment) {
            return;
        }
        this.getMap().put(part, new Integer(alignment));
        DiagramGuide diagramGuide = parent = this.isHorizontal() ? part.getHorizontalGuide() : part.getVerticalGuide();
        if (parent != null && parent != this) {
            parent.detachPart(part);
        }
        if (this.isHorizontal()) {
            part.setHorizontalGuide(this);
        } else {
            part.setVerticalGuide(this);
        }
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, part);
    }

    public void detachPart(OrmShape part) {
        if (this.getMap().containsKey(part)) {
            this.getMap().remove(part);
            if (this.isHorizontal()) {
                part.setHorizontalGuide(null);
            } else {
                part.setVerticalGuide(null);
            }
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, part);
        }
    }

    public int getAlignment(OrmShape part) {
        if (this.getMap().get(part) != null) {
            return this.getMap().get(part);
        }
        return -2;
    }

    public Map<OrmShape, Integer> getMap() {
        if (this.map == null) {
            this.map = new Hashtable<OrmShape, Integer>();
        }
        return this.map;
    }

    public Set<OrmShape> getParts() {
        return this.getMap().keySet();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setHorizontal(boolean isHorizontal) {
        this.horizontal = isHorizontal;
    }

    public void setPosition(int offset) {
        if (this.position != offset) {
            int oldValue = this.position;
            this.position = offset;
            this.listeners.firePropertyChange(PROPERTY_POSITION, new Integer(oldValue), new Integer(this.position));
        }
    }
}

