/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl.Group;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl.Item;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl.LayoutConstants;

public class Groups {
    protected LayoutConstants constants;
    static int FX = 30;
    static int FY = 120;
    List<Group> groups = new ArrayList<Group>();
    Item[] items;
    int[][] field;
    int[] yDeltas = null;
    static int MAX_SINGLES_PER_ROW = 5;

    public void setConstants(LayoutConstants constants) {
        this.constants = constants;
    }

    public void load(Item[] items) {
        this.items = items;
        this.init();
        this.initField();
        this.buildY();
        this.buildDeltas();
    }

    public void init() {
        this.groups.clear();
        int g = 0;
        boolean isSomethingSet = this.isSomethingSet();
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].group == null && !this.items[i].isOwned) {
                Group group = new Group();
                group.setConstants(this.constants);
                group.number = ++g;
                this.groups.add(group);
                if (!this.items[i].isSet()) {
                    this.items[i].ix = 0;
                }
                group.setItems(this.items);
                if (isSomethingSet) {
                    group.expandGroup(i);
                } else {
                    group.createGroup(i);
                }
                group.moveX();
            }
            ++i;
        }
    }

    private boolean isSomethingSet() {
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].isSet) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initField() {
        this.field = new int[FX][];
        int i = 0;
        while (i < FX) {
            this.field[i] = new int[FY];
            int j = 0;
            while (j < FY) {
                this.field[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.items.length) {
            if (this.items[i].isSet() && this.items[i].isVisible()) {
                this.field[this.items[i].ix][this.items[i].iy] = 1;
            }
            ++i;
        }
    }

    public void buildY() {
        int miny = 0;
        miny = this.buildYForSingleComments();
        boolean isSomethingSet = this.isSomethingSet();
        int i = 0;
        while (i < this.groups.size()) {
            Group group = this.groups.get(i);
            if (group.items().length >= 2) {
                Item item = group.getItem(0);
                if (!item.yAssigned) {
                    group.miny = miny;
                    item.yAssigned = true;
                    if (!item.isSet()) {
                        item.iy = miny;
                    }
                    if (!isSomethingSet) {
                        group.buildY_2(item, this.field);
                    }
                    group.buildY(item, this.field);
                    miny = group.getMaxY() + 1;
                    if (miny > FY - 2) {
                        miny = FY - 2;
                    }
                }
            }
            ++i;
        }
        this.buildYForSingles(miny);
    }

    private int buildYForSingleComments() {
        int miny = 0;
        int ix = 0;
        int i = 0;
        while (i < this.groups.size()) {
            Item item;
            Group group = this.groups.get(i);
            if (group.items().length == 1 && (item = group.getItem(0)).isComment()) {
                if (!item.isSet()) {
                    group.miny = miny;
                    item.ix = ix;
                    item.iy = miny++;
                    if ((ix += 2) > 2) {
                        ix = 0;
                    }
                } else {
                    group.miny = 0;
                }
            }
            ++i;
        }
        if (ix > 0) {
            ++miny;
        }
        return miny;
    }

    private void buildYForSingles(int miny) {
        int ix = 0;
        int i = 0;
        while (i < this.groups.size()) {
            Group group = this.groups.get(i);
            if (group.items().length == 1 && group.miny < 0) {
                group.miny = miny;
                Item item = group.getItem(0);
                while (true) {
                    if (ix < this.field.length && this.field[ix][miny] == 1) {
                        ++ix;
                        continue;
                    }
                    if (ix <= MAX_SINGLES_PER_ROW) break;
                    ix = 0;
                    if (miny >= FY - 1) break;
                    ++miny;
                }
                if (!item.isSet()) {
                    item.iy = miny;
                    item.ix = ix++;
                }
                this.field[item.ix][item.iy] = 1;
            }
            ++i;
        }
    }

    void buildXDeltasForSingles() {
        int[] xDeltas = new int[100];
        int i = 0;
        while (i < this.groups.size()) {
            Group group = this.groups.get(i);
            if (group.items().length == 1) {
                int wi;
                int[] shape;
                group.xDeltas = xDeltas;
                Item item = group.getItem(0);
                int c = item.ix;
                if (++c < xDeltas.length && (shape = item.getItemInfo().getShape()) != null && shape.length >= 4 && (wi = (shape[2] - this.constants.deltaX / 2) / this.constants.incX) > xDeltas[c]) {
                    xDeltas[c] = wi;
                }
            }
            ++i;
        }
        i = 1;
        while (i < xDeltas.length) {
            int n = i;
            xDeltas[n] = xDeltas[n] + xDeltas[i - 1];
            ++i;
        }
    }

    public void buildDeltas() {
        int i = 0;
        while (i < this.groups.size()) {
            Group group = this.groups.get(i);
            group.buildXDeltas();
            ++i;
        }
        this.buildYDeltas();
        this.buildXDeltasForSingles();
    }

    public void buildYDeltas() {
        this.yDeltas = new int[this.getMaxY() + 1];
        int i = 0;
        while (i < this.yDeltas.length) {
            this.yDeltas[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.items.length) {
            int c = this.items[i].iy + 1;
            if (c < this.yDeltas.length) {
                int wi;
                int[] shape;
                int sz = this.items[i].outputs.length - 1;
                if (sz > this.yDeltas[c]) {
                    this.yDeltas[c] = sz;
                }
                if ((shape = this.items[i].getItemInfo().getShape()) != null && shape.length >= 4 && (wi = (shape[3] - this.constants.deltaY / 2) / this.constants.incY) > this.yDeltas[c]) {
                    this.yDeltas[c] = wi;
                }
            }
            ++i;
        }
        i = 1;
        while (i < this.yDeltas.length) {
            int n = i;
            this.yDeltas[n] = this.yDeltas[n] + this.yDeltas[i - 1];
            ++i;
        }
    }

    public int getMaxY() {
        int max = 0;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].iy > max) {
                max = this.items[i].iy;
            }
            ++i;
        }
        return max;
    }
}

