/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.openshift.client.IApplication;
import com.openshift.client.IApplicationPortForwarding;
import com.openshift.client.OpenShiftSSHOperationException;
import java.util.Arrays;

public class ApplicationPortForwarding
implements IApplicationPortForwarding {
    private final IApplication application;
    private final String name;
    private final String remoteAddress;
    private final int remotePort;
    private String localAddress;
    private int localPort = -1;

    public ApplicationPortForwarding(IApplication application, String name, String remoteAddress, int remotePort) {
        this.application = application;
        this.name = name;
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
    }

    @Override
    public void start(Session session) throws OpenShiftSSHOperationException {
        if (this.localAddress == null || this.localAddress.isEmpty()) {
            throw new IllegalArgumentException("Cannot enable port-forwarding from an undefined local address");
        }
        if (this.localPort == -1) {
            throw new IllegalArgumentException("Cannot enable port-forwarding from an undefined local port");
        }
        if (!this.isStarted(session)) {
            try {
                session.setPortForwardingL(this.localAddress, this.localPort, this.remoteAddress, this.remotePort);
            }
            catch (Exception e) {
                throw new OpenShiftSSHOperationException(e, "Failed to start port forwarding on {0}:{1}", this.localAddress, this.localPort);
            }
        }
    }

    @Override
    public void stop(Session session) throws OpenShiftSSHOperationException {
        if (this.isStarted(session)) {
            try {
                session.delPortForwardingL(this.localAddress, this.localPort);
            }
            catch (Exception e) {
                throw new OpenShiftSSHOperationException(e, "Failed to stop port forwarding on {0}:{1}", this.localAddress, this.localPort);
            }
        }
    }

    @Override
    public boolean isStarted(Session session) throws OpenShiftSSHOperationException {
        if (session == null || !session.isConnected()) {
            return false;
        }
        try {
            Object[] portForwardingL = session.getPortForwardingL();
            String key = this.localPort + ":" + this.remoteAddress + ":" + this.remotePort;
            Arrays.sort(portForwardingL);
            int r = Arrays.binarySearch(portForwardingL, key);
            return r >= 0;
        }
        catch (JSchException e) {
            throw new OpenShiftSSHOperationException(e, "Failed to retrieve SSH ports forwarding", new Object[0]);
        }
    }

    protected final IApplication getApplication() {
        return this.application;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public final void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public final int getLocalPort() {
        return this.localPort;
    }

    @Override
    public final void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @Override
    public final String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public final int getRemotePort() {
        return this.remotePort;
    }

    public String toString() {
        return "ApplicationForwardablePort [" + this.name + ": " + this.localAddress + ":" + this.localPort + " -> " + this.remoteAddress + ":" + this.remotePort + "]";
    }
}

