/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.ICartridge;
import com.openshift.client.JBossCartridge;
import com.openshift.client.OpenShiftException;

public class Cartridge
implements ICartridge {
    protected static final String JBOSS = "jboss";
    protected static final String RUBY = "ruby";
    protected static final String PYTHON = "python";
    protected static final String PHP = "php";
    protected static final String PERL = "perl";
    protected static final String NODEJS = "nodejs";
    protected static final String JENKINS = "jenkins";
    protected static final String HAPROXY = "haproxy";
    protected static final String RAW = "diy";
    private final String name;

    public Cartridge(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLogLocation() {
        return "/";
    }

    public static ICartridge valueOf(String name) {
        if (name.contains(JBOSS)) {
            return new JBossCartridge(name);
        }
        return new Cartridge(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cartridge other = (Cartridge)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Cartridge [name=" + this.name + "]";
    }

    protected String getCartridgeName(String cartridgeType) throws OpenShiftException {
        throw new UnsupportedOperationException();
    }
}

