/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.ICartridge;
import com.openshift.client.IDomain;
import com.openshift.client.IEmbeddableCartridge;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.Cartridge;
import com.openshift.internal.client.DomainResource;
import com.openshift.internal.client.EmbeddableCartridge;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.UserResource;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.DomainResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.UserResourceDTO;
import com.openshift.internal.client.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class APIResource
extends AbstractOpenShiftResource
implements IOpenShiftConnection {
    private final String login;
    private final String password;
    private List<IDomain> domains;
    private UserResource user;
    private final List<ICartridge> standaloneCartridgeNames = new ArrayList<ICartridge>();
    private final List<IEmbeddableCartridge> embeddedCartridgeNames = new ArrayList<IEmbeddableCartridge>();

    protected APIResource(String login, String password, IRestService service, Map<String, Link> links) {
        super(service, links, null);
        this.login = login;
        this.password = password;
    }

    protected final String getLogin() {
        return this.login;
    }

    protected final String getPassword() {
        return this.password;
    }

    @Override
    public IUser getUser() throws OpenShiftException {
        if (this.user == null) {
            this.user = new UserResource(this, new GetUserRequest().execute(), this.password);
        }
        return this.user;
    }

    @Override
    public List<IDomain> getDomains() throws OpenShiftException {
        if (this.domains == null) {
            this.domains = this.loadDomains();
        }
        return CollectionUtils.toUnmodifiableCopy(this.domains);
    }

    private List<IDomain> loadDomains() throws OpenShiftException {
        ArrayList<IDomain> domains = new ArrayList<IDomain>();
        for (DomainResourceDTO domainDTO : new ListDomainsRequest().execute()) {
            domains.add(new DomainResource(domainDTO, this));
        }
        return domains;
    }

    public IDomain getDomain(String id) throws OpenShiftException {
        for (IDomain domain : this.getDomains()) {
            if (!domain.getId().equals(id)) continue;
            return domain;
        }
        return null;
    }

    public IDomain createDomain(String id) throws OpenShiftException {
        if (this.hasDomain(id)) {
            throw new OpenShiftException("Domain {0} already exists", id);
        }
        DomainResourceDTO domainDTO = new AddDomainRequest().execute(id);
        DomainResource domain = new DomainResource(domainDTO, this);
        this.domains.add(domain);
        return domain;
    }

    @Override
    public List<ICartridge> getStandaloneCartridges() throws OpenShiftException {
        if (this.standaloneCartridgeNames.isEmpty()) {
            this.retrieveCartridges();
        }
        return this.standaloneCartridgeNames;
    }

    @Override
    public List<IEmbeddableCartridge> getEmbeddableCartridges() throws OpenShiftException {
        if (this.embeddedCartridgeNames.isEmpty()) {
            this.retrieveCartridges();
        }
        return CollectionUtils.toUnmodifiableCopy(this.embeddedCartridgeNames);
    }

    private void retrieveCartridges() throws OpenShiftException {
        List<CartridgeResourceDTO> cartridgeDTOs = new GetCartridgesRequest().execute();
        for (CartridgeResourceDTO cartridgeDTO : cartridgeDTOs) {
            switch (cartridgeDTO.getType()) {
                case STANDALONE: {
                    this.standaloneCartridgeNames.add(new Cartridge(cartridgeDTO.getName()));
                    break;
                }
                case EMBEDDED: {
                    this.embeddedCartridgeNames.add(new EmbeddableCartridge(cartridgeDTO.getName()));
                    break;
                }
            }
        }
    }

    @Override
    public void refresh() throws OpenShiftException {
    }

    protected void removeDomain(IDomain domain) {
        this.domains.remove(domain);
    }

    protected boolean hasDomain(String name) throws OpenShiftException {
        return this.getDomain(name) != null;
    }

    private class GetCartridgesRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public GetCartridgesRequest() throws OpenShiftException {
            super("LIST_CARTRIDGES");
        }

        public List<CartridgeResourceDTO> execute() throws OpenShiftException {
            return (List)super.execute(new ServiceParameter[0]);
        }
    }

    private class GetUserRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public GetUserRequest() throws OpenShiftException {
            super("GET_USER");
        }

        public UserResourceDTO execute() throws OpenShiftException {
            return (UserResourceDTO)super.execute(new ServiceParameter[0]);
        }
    }

    private class ListDomainsRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public ListDomainsRequest() throws OpenShiftException {
            super("LIST_DOMAINS");
        }

        public List<DomainResourceDTO> execute() throws OpenShiftException {
            return (List)super.execute(new ServiceParameter[0]);
        }
    }

    private class AddDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public AddDomainRequest() throws OpenShiftException {
            super("ADD_DOMAIN");
        }

        public DomainResourceDTO execute(String namespace) throws OpenShiftException {
            return (DomainResourceDTO)this.execute(new ServiceParameter("id", namespace));
        }
    }
}

