/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.AssignmentDirective;
import org.jboss.ide.eclipse.freemarker.model.AssignmentEndDirective;
import org.jboss.ide.eclipse.freemarker.model.CaseDefaultDirective;
import org.jboss.ide.eclipse.freemarker.model.CaseDirective;
import org.jboss.ide.eclipse.freemarker.model.ElseIfDirective;
import org.jboss.ide.eclipse.freemarker.model.FtlDirective;
import org.jboss.ide.eclipse.freemarker.model.FunctionDirective;
import org.jboss.ide.eclipse.freemarker.model.FunctionEndDirective;
import org.jboss.ide.eclipse.freemarker.model.GenericDirective;
import org.jboss.ide.eclipse.freemarker.model.GenericNestableDirective;
import org.jboss.ide.eclipse.freemarker.model.GenericNestableEndDirective;
import org.jboss.ide.eclipse.freemarker.model.IfDirective;
import org.jboss.ide.eclipse.freemarker.model.IfElseDirective;
import org.jboss.ide.eclipse.freemarker.model.IfEndDirective;
import org.jboss.ide.eclipse.freemarker.model.Interpolation;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ListDirective;
import org.jboss.ide.eclipse.freemarker.model.ListEndDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroEndDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroEndInstance;
import org.jboss.ide.eclipse.freemarker.model.MacroInstance;

public class ItemFactory {
    public static Item getItem(ITypedRegion region, ISourceViewer viewer, IResource resource) {
        if (region == null) {
            return null;
        }
        AbstractDirective directive = null;
        if (region.getType().equals("__ftl_if_directive_start")) {
            directive = new IfDirective();
        } else if (region.getType().equals("__ftl_if_directive_end")) {
            directive = new IfEndDirective();
        } else if (region.getType().equals("__ftl_if_else_directive")) {
            directive = new IfElseDirective();
        } else if (region.getType().equals("__ftl_else_if_directive")) {
            directive = new ElseIfDirective();
        } else if (region.getType().equals("__ftl_list_directive_start")) {
            directive = new ListDirective();
        } else if (region.getType().equals("__ftl_list_directive_end")) {
            directive = new ListEndDirective();
        } else if (region.getType().equals("__ftl_function_directive_start")) {
            directive = new FunctionDirective();
        } else if (region.getType().equals("__ftl_function_directive_end")) {
            directive = new FunctionEndDirective();
        } else if (region.getType().equals("__ftl_macro_directive_start")) {
            directive = new MacroDirective();
        } else if (region.getType().equals("__ftl_macro_directive_end")) {
            directive = new MacroEndDirective();
        } else if (region.getType().equals("__ftl_macro_instance_start")) {
            directive = new MacroInstance();
        } else if (region.getType().equals("__ftl_macro_instance_end")) {
            directive = new MacroEndInstance();
        } else if (region.getType().equals("__ftl_include")) {
            directive = new GenericDirective("include.png");
        } else if (region.getType().equals("__ftl_import")) {
            directive = new GenericDirective("import.png");
        } else if (region.getType().equals("__ftl_assign") || region.getType().equals("__ftl_local") || region.getType().equals("__ftl_global")) {
            directive = new AssignmentDirective(region.getType());
        } else if (region.getType().equals("__ftl_assign_end") || region.getType().equals("__ftl_local_end") || region.getType().equals("__ftl_global_end")) {
            directive = new AssignmentEndDirective(region.getType());
        } else if (region.getType().equals("__ftl_break")) {
            directive = new GenericDirective("break.png");
        } else if (region.getType().equals("__ftl_stop")) {
            directive = new GenericDirective("stop.png");
        } else if (region.getType().equals("__ftl_return")) {
            directive = new GenericDirective("return.png");
        } else if (region.getType().equals("__ftl_switch_directive_start")) {
            directive = new GenericNestableDirective("switch", "switch.png");
        } else if (region.getType().equals("__ftl_switch_directive_end")) {
            directive = new GenericNestableEndDirective("switch");
        } else if (region.getType().equals("__ftl_case_directive_start")) {
            directive = new CaseDirective();
        } else if (region.getType().equals("__ftl_case_default_start")) {
            directive = new CaseDefaultDirective();
        } else if (region.getType().equals("__ftl_interpolation")) {
            directive = new Interpolation();
        } else if (region.getType().equals("__ftl_ftl_directive")) {
            directive = new FtlDirective();
        } else if (region.getType().equals("__ftl_directive")) {
            String name = ItemFactory.getDirectiveName(region, viewer);
            directive = new GenericNestableDirective(name, "element.png");
        } else if (region.getType().equals("__ftl_directive_end")) {
            String name = ItemFactory.getDirectiveName(region, viewer);
            directive = new GenericNestableEndDirective(name);
        }
        if (directive != null) {
            directive.load(region, viewer, resource);
        }
        return directive;
    }

    private static String getDirectiveName(ITypedRegion region, ISourceViewer viewer) {
        StringBuffer sb = new StringBuffer();
        try {
            int offset = region.getOffset();
            int stopIndex = offset + region.getLength();
            char c = viewer.getDocument().getChar(offset);
            while (c != ' ' && c != '>' && offset <= stopIndex) {
                if (c != '<' && c != '#' && c != '/') {
                    sb.append(c);
                }
                c = viewer.getDocument().getChar(++offset);
            }
            return sb.toString();
        }
        catch (BadLocationException badLocationException) {
            return sb.toString();
        }
    }
}

