/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor.rules;

import java.util.Stack;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;

public class InterpolationRule
extends SingleLineRule {
    public InterpolationRule(char startChar, IToken token) {
        super(String.valueOf(startChar) + "{", "}", token);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        scanner.getLegalLineDelimiters();
        Stack<String> keyStack = new Stack<String>();
        int charsRead = 0;
        while ((c = scanner.read()) != -1) {
            ++charsRead;
            if (c == 123) {
                if (keyStack.size() == 0) {
                    break;
                }
            } else if (c == 34) {
                if (keyStack.size() > 0 && keyStack.peek().equals("\"")) {
                    keyStack.pop();
                } else {
                    keyStack.push("\"");
                }
            } else if (c == 40) {
                if (keyStack.size() <= 0 || !keyStack.peek().equals("\"")) {
                    keyStack.push("(");
                }
            } else if (c == 41) {
                if ((keyStack.size() <= 0 || !keyStack.peek().equals("\"")) && keyStack.size() > 0 && keyStack.peek().equals("(")) {
                    keyStack.pop();
                }
            } else if (c == this.fEscapeCharacter) {
                scanner.read();
                ++charsRead;
            } else if (c == 125) {
                if (keyStack.size() == 0) {
                    return true;
                }
            } else if (c == 10) break;
            boolean bl = c == this.fEscapeCharacter;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        int i = 0;
        while (i < charsRead) {
            scanner.unread();
            ++i;
        }
        return false;
    }
}

