/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.PipeOut;

public class PipeOutImpl
implements PipeOut {
    private final StringBuilder buffer = new StringBuilder();
    private final Shell shell;
    private boolean piped = false;

    public PipeOutImpl(Shell shell) {
        this.shell = shell;
    }

    public void write(int b) {
        if (this.piped) {
            this.buffer.append(b);
        } else {
            this.shell.write(b);
        }
    }

    public void write(byte b) {
        if (this.piped) {
            this.buffer.append((char)b);
        } else {
            this.shell.print(String.valueOf((char)b));
        }
    }

    public void write(byte[] b) {
        if (this.piped) {
            this.buffer.append(new String(b));
        } else {
            this.shell.write(b);
        }
    }

    public void write(byte[] b, int offset, int length) {
        if (this.piped) {
            this.buffer.append(new String(b, offset, length));
        } else {
            this.shell.write(b, offset, length);
        }
    }

    public void print(String s) {
        if (this.piped) {
            this.buffer.append(s);
        } else {
            this.shell.print(s);
        }
    }

    public void println(String s) {
        if (this.piped) {
            this.buffer.append(s).append("\n");
        } else {
            this.shell.println(s);
        }
    }

    public void println() {
        if (this.piped) {
            this.buffer.append("\n");
        } else {
            this.shell.println();
        }
    }

    public void print(ShellColor color, String s) {
        this.print(this.renderColor(color, s));
    }

    public void println(ShellColor color, String s) {
        this.println(this.renderColor(color, s));
    }

    public String renderColor(ShellColor color, String s) {
        return this.piped ? s : this.shell.renderColor(color, s);
    }

    public boolean isPiped() {
        return this.piped;
    }

    public void setPiped(boolean v) {
        this.piped = v;
    }

    public String getBuffer() {
        return this.buffer.toString();
    }

    public void flush() {
        this.shell.flush();
    }
}

