/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.project.resources;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.shell.events.ResourceChanged;
import org.jboss.forge.shell.project.ResourceScoped;
import org.jboss.forge.shell.util.BeanManagerUtils;

@Singleton
public class ResourceScopedContext
implements Context {
    private static final String COMPONENT_MAP_NAME = ResourceScopedContext.class.getName() + ".componentInstanceMap";
    private static final String CREATIONAL_MAP_NAME = ResourceScopedContext.class.getName() + ".creationalInstanceMap";
    private final BeanManager manager;
    private final Map<String, Object> contextMap = new ConcurrentHashMap<String, Object>();

    @Inject
    public ResourceScopedContext(BeanManager manager) {
        this.manager = manager;
    }

    private void assertActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("Context with scope annotation @ProjectScoped is not active with respect to the current directory.");
        }
    }

    private ResourceScopedContext getCurrentContext() {
        ResourceScopedContext scopedContext = (ResourceScopedContext)BeanManagerUtils.getContextualInstance((BeanManager)this.manager, ResourceScopedContext.class);
        return scopedContext;
    }

    public void destroy(@Observes ResourceChanged event) {
        if (this.getCurrentContext() != null) {
            Map<Contextual<?>, Object> componentInstanceMap = this.getComponentInstanceMap();
            Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalContextMap();
            if (componentInstanceMap != null && creationalContextMap != null) {
                for (Map.Entry<Contextual<?>, Object> componentEntry : componentInstanceMap.entrySet()) {
                    Contextual<?> contextual = componentEntry.getKey();
                    Object instance = componentEntry.getValue();
                    CreationalContext<?> creational = creationalContextMap.get(contextual);
                    contextual.destroy(instance, creational);
                }
            }
            this.getCurrentContext().contextMap.clear();
        }
    }

    public <T> T get(Contextual<T> component) {
        this.assertActive();
        return (T)this.getComponentInstanceMap().get(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        this.assertActive();
        Object instance = this.get(component);
        if (instance == null) {
            Map<Contextual<?>, Object> componentInstanceMap;
            Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalContextMap();
            Map<Contextual<?>, Object> map = componentInstanceMap = this.getComponentInstanceMap();
            synchronized (map) {
                instance = componentInstanceMap.get(component);
                if (instance == null && (instance = component.create(creationalContext)) != null) {
                    componentInstanceMap.put(component, instance);
                    creationalContextMap.put(component, creationalContext);
                }
            }
        }
        return instance;
    }

    public boolean isActive() {
        return this.getCurrentContext() != null;
    }

    public Class<? extends Annotation> getScope() {
        return ResourceScoped.class;
    }

    private Map<Contextual<?>, Object> getComponentInstanceMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)this.getCurrentContext().contextMap.get(COMPONENT_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            this.getCurrentContext().contextMap.put(COMPONENT_MAP_NAME, map);
        }
        return map;
    }

    private Map<Contextual<?>, CreationalContext<?>> getCreationalContextMap() {
        ConcurrentHashMap map = (ConcurrentHashMap)this.getCurrentContext().contextMap.get(CREATIONAL_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            this.getCurrentContext().contextMap.put(CREATIONAL_MAP_NAME, map);
        }
        return map;
    }
}

