/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.PathspecParser;

@Alias(value="mv")
@Topic(value="File & Resources")
@RequiresResource(value={DirectoryResource.class})
@Help(value="Renames a file or directory")
public class MovePlugin
implements Plugin {
    private final ResourceFactory resourceFactory;

    @Inject
    public MovePlugin(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    @DefaultCommand
    public void rename(@Option(description="source", required=true) Resource<?> source, @Option(description="target", required=true) String target, @Option(name="force", shortName="f", description="force operation", flagOnly=true) boolean force, PipeOut out) {
        if (source instanceof FileResource) {
            Resource sourceTarget = source.isFlagSet(ResourceFlag.Leaf) ? source.getParent() : source;
            List results = new PathspecParser(this.resourceFactory, sourceTarget, target).resolve();
            if (results.size() != 1) {
                out.println("ambiguous target file name: " + target);
            } else {
                Resource targetResource = (Resource)results.get(0);
                if (targetResource.exists()) {
                    if (targetResource instanceof DirectoryResource) {
                        targetResource = targetResource.getChild(source.getName());
                    } else if (force && targetResource instanceof FileResource) {
                        ((FileResource)targetResource).delete(false);
                    } else {
                        out.println("destination file exists: " + targetResource.getFullyQualifiedName());
                        return;
                    }
                }
                ((FileResource)source).renameTo(targetResource.getFullyQualifiedName());
            }
        } else {
            out.println("cannot rename resource type: " + source.getClass().getSimpleName());
        }
    }
}

