/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.PluginMetadata;
import org.jboss.forge.shell.command.PluginRegistry;
import org.jboss.forge.shell.constraint.ConstraintEnforcer;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.FormatCallback;
import org.jboss.forge.shell.util.GeneralUtils;

@Alias(value="list-commands")
@Topic(value="Shell Environment")
@Help(value="Lists executable forge commands")
public class ListCommandsPlugin
implements Plugin {
    final PluginRegistry registry;
    final Shell shell;

    @Inject
    public ListCommandsPlugin(PluginRegistry registry, Shell shell) {
        this.registry = registry;
        this.shell = shell;
    }

    @DefaultCommand
    public void listCommands(@Option(name="all", shortName="a", flagOnly=true) boolean showAll, final PipeOut pipeOut) {
        TreeMap listGroups = new TreeMap();
        Class<?> currResource = this.shell.getCurrentResource().getClass();
        for (List lpm : this.registry.getPlugins().values()) {
            for (PluginMetadata pluginMetadata : lpm) {
                ArrayList<String> listData;
                ConstraintEnforcer enforcer = new ConstraintEnforcer();
                if (!showAll && !enforcer.isAvailable(this.shell.getCurrentProject(), pluginMetadata)) continue;
                if (!listGroups.containsKey(pluginMetadata.getTopic())) {
                    listData = new ArrayList<String>();
                    listGroups.put(pluginMetadata.getTopic(), listData);
                } else {
                    listData = (ArrayList<String>)listGroups.get(pluginMetadata.getTopic());
                }
                for (CommandMetadata commandMetadata : pluginMetadata.getAllCommands()) {
                    String name = ListCommandsPlugin.render(showAll, currResource, commandMetadata);
                    if (name.endsWith("*")) {
                        listData.remove(name.substring(0, name.length() - 1));
                    }
                    listData.remove(name);
                    if ("".equals(name)) continue;
                    listData.add(name);
                }
                if (listGroups.containsKey(pluginMetadata.getTopic())) continue;
                listGroups.put(pluginMetadata.getTopic(), listData);
            }
        }
        GeneralUtils.OutputAttributes attr = null;
        if (pipeOut.isPiped()) {
            attr = new GeneralUtils.OutputAttributes(120, 1);
        } else {
            for (Map.Entry entry : listGroups.entrySet()) {
                attr = GeneralUtils.calculateOutputAttributs((List)entry.getValue(), this.shell, attr);
            }
        }
        FormatCallback formatCallback = new FormatCallback(){

            @Override
            public String format(int column, String value) {
                return value.endsWith("*") ? pipeOut.renderColor(ShellColor.BOLD, value) : value;
            }
        };
        for (Map.Entry entry : listGroups.entrySet()) {
            if (!pipeOut.isPiped()) {
                pipeOut.println();
                pipeOut.println(ShellColor.RED, "[" + ((String)entry.getKey()).toUpperCase() + "]");
            }
            GeneralUtils.printOutColumns((List)entry.getValue(), ShellColor.NONE, (ShellPrintWriter)pipeOut, attr, formatCallback, true);
        }
        if (!pipeOut.isPiped()) {
            pipeOut.println();
            if (showAll) {
                pipeOut.println("(* = command accessible from current context)");
            } else {
                pipeOut.println("(only commands in relevant scope displayed. use --all to see all commands.)");
            }
        }
    }

    private static String render(boolean showAll, Class<? extends Resource> currResource, CommandMetadata cmdMeta) {
        boolean contextual = cmdMeta.usableWithResource(currResource);
        if (showAll) {
            if (cmdMeta.isDefault()) {
                return cmdMeta.getName() + (contextual ? "*" : "");
            }
            return cmdMeta.getParent().getName() + " " + cmdMeta.getName() + (contextual ? "*" : "");
        }
        if (contextual) {
            if (cmdMeta.isDefault()) {
                return cmdMeta.getName() + "*";
            }
            return cmdMeta.getParent().getName() + " " + cmdMeta.getName() + "*";
        }
        return "";
    }
}

