/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.completer;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.jboss.forge.shell.command.parser.Tokenizer;
import org.jboss.forge.shell.completer.CommandCompleterState;

public class BaseCommandCompleterState
implements CommandCompleterState {
    private final String buffer;
    private final String lastBuffer;
    private final int originalIndex;
    private final boolean tokenComplete;
    private final Queue<String> tokens;
    private final List<String> candidates = new ArrayList<String>();
    private int index;

    public BaseCommandCompleterState(String initialBuffer, String lastBuffer, int initialIndex) {
        this.buffer = initialBuffer;
        this.lastBuffer = lastBuffer;
        this.index = initialIndex;
        this.originalIndex = initialIndex;
        this.tokens = new Tokenizer().tokenize(initialBuffer);
        this.tokenComplete = this.buffer.matches("^.*\\s+$");
    }

    public int getOriginalIndex() {
        return this.originalIndex;
    }

    public Queue<String> getOriginalTokens() {
        return new Tokenizer().tokenize(this.buffer);
    }

    public String getBuffer() {
        return this.buffer;
    }

    public String getLastBuffer() {
        return this.lastBuffer;
    }

    public boolean isFinalTokenComplete() {
        return this.tokenComplete;
    }

    public boolean hasSuggestions() {
        return !this.candidates.isEmpty();
    }

    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public Queue<String> getTokens() {
        return this.tokens;
    }

    public List<String> getCandidates() {
        return this.candidates;
    }

    public boolean isDuplicateBuffer() {
        return this.buffer != null && this.buffer.equals(this.lastBuffer);
    }
}

