/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.parser;

import java.util.ArrayList;
import java.util.Queue;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.parser.CommandParser;
import org.jboss.forge.shell.command.parser.CommandParserContext;

public class NamedValueVarargsOptionParser
implements CommandParser {
    @Override
    public CommandParserContext parse(CommandMetadata command, Queue<String> tokens, CommandParserContext ctx) {
        String currentToken = tokens.peek();
        if (currentToken.startsWith("--") && command.hasOption(currentToken = currentToken.substring(2))) {
            try {
                OptionMetadata option = command.getNamedOption(currentToken);
                if (option.isVarargs()) {
                    tokens.remove();
                    ArrayList<String> args = new ArrayList<String>();
                    String rawValue = null;
                    while (!tokens.isEmpty()) {
                        rawValue = tokens.remove();
                        args.add(Strings.stripQuotes((String)rawValue));
                    }
                    ctx.put(option, args.toArray(), Strings.stripQuotes((String)rawValue));
                }
            }
            catch (IllegalArgumentException e) {
                ctx.addWarning("No such option [--" + currentToken + "] for command [" + command + "].");
            }
        }
        return ctx;
    }
}

