/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.parser;

import java.util.Queue;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.parser.CommandParser;
import org.jboss.forge.shell.command.parser.CommandParserContext;

public class NamedBooleanOptionParser
implements CommandParser {
    @Override
    public CommandParserContext parse(CommandMetadata command, Queue<String> tokens, CommandParserContext ctx) {
        String currentToken = tokens.peek();
        if (currentToken.matches("--?\\S+")) {
            if (currentToken.length() > 1 && currentToken.charAt(1) != '-') {
                boolean matched = false;
                for (int i = 1; i < currentToken.length(); ++i) {
                    String shortOption = currentToken.substring(i, i + 1);
                    try {
                        if (!command.hasShortOption(shortOption)) continue;
                        NamedBooleanOptionParser.processOption(ctx, tokens, command, shortOption, true);
                        matched = true;
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        ctx.addWarning("No such option [-" + shortOption + "] for command [" + command + "].");
                    }
                }
                if (matched) {
                    tokens.remove();
                }
            } else {
                currentToken = currentToken.substring(2);
                try {
                    if (command.hasOption(currentToken)) {
                        NamedBooleanOptionParser.processOption(ctx, tokens, command, currentToken, false);
                    }
                }
                catch (IllegalArgumentException e) {
                    ctx.addWarning("No such option [--" + currentToken + "] for command [" + command + "].");
                }
            }
        }
        return ctx;
    }

    private static void processOption(CommandParserContext ctx, Queue<String> tokens, CommandMetadata command, String currentToken, boolean shortOption) {
        OptionMetadata option = command.getNamedOption(currentToken);
        if (option.isBoolean()) {
            String value = "true";
            if (!tokens.isEmpty()) {
                if (!shortOption) {
                    tokens.remove();
                }
                String nextToken = tokens.peek();
                if (!option.isFlagOnly() && nextToken != null && nextToken.matches("true|false")) {
                    value = nextToken;
                    tokens.remove();
                }
            }
            ctx.put(option, value, null);
        }
    }
}

