/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.fshparser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jboss.forge.shell.command.fshparser.AutoReducingQueue;
import org.jboss.forge.shell.command.fshparser.FSHRuntime;
import org.jboss.forge.shell.command.fshparser.NestedNode;
import org.jboss.forge.shell.command.fshparser.Node;
import org.jboss.forge.shell.command.fshparser.PipeNode;
import org.jboss.forge.shell.command.fshparser.ScriptNode;
import org.jboss.forge.shell.command.fshparser.TokenNode;
import org.mvel2.MVEL;

public abstract class Parse {
    private static final Set<String> reservedWords = new HashSet<String>();
    private static final Set<String> operators = new HashSet<String>();

    public static boolean isReservedWord(String word) {
        return reservedWords.contains(word);
    }

    public static boolean isTokenPart(char c) {
        switch (c) {
            case '#': 
            case '$': 
            case '%': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '~': {
                return true;
            }
        }
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isOperator(String str) {
        return operators.contains(str);
    }

    public static String disassemble(Node n) {
        if (n == null) {
            return "";
        }
        StringBuilder build = new StringBuilder();
        do {
            if (n instanceof PipeNode) {
                build.append('|').append(Parse.disassemble(((NestedNode)n).getNest()));
                continue;
            }
            if (n instanceof NestedNode) {
                build.append('(').append(Parse.disassemble(((NestedNode)n).getNest())).append(')');
                continue;
            }
            if (!(n instanceof TokenNode)) continue;
            build.append(((TokenNode)n).getValue());
        } while ((n = n.getNext()) != null);
        return build.toString();
    }

    public static String queueToString(Queue<String> tokens) {
        StringBuilder sb = new StringBuilder();
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String executeScript(ScriptNode node, FSHRuntime runtime) {
        String toExec = Parse.queueToString(new AutoReducingQueue(node.getNest(), runtime));
        Object r = MVEL.eval((String)toExec, (Object)runtime, (Map)runtime.getShell().getEnvironment().getProperties());
        if (r == null) {
            return null;
        }
        return String.valueOf(r);
    }

    static {
        reservedWords.add("if");
        reservedWords.add("else");
        reservedWords.add("for");
        reservedWords.add("new");
        reservedWords.add("return");
        reservedWords.add("do");
        reservedWords.add("while");
        reservedWords.add("def");
        operators.add("+");
        operators.add("-");
        operators.add("/");
        operators.add("*");
        operators.add("%");
        operators.add("&&");
        operators.add("||");
        operators.add("=");
    }
}

