/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.util;

public class Timer {
    private Long startTime = null;
    private Long lapTime = null;
    private Long stopTime = null;

    private Timer() {
    }

    public static Timer getTimer() {
        return new Timer();
    }

    public Timer start() throws IllegalStateException {
        if (this.startTime != null) {
            if (this.stopTime != null) {
                this.stopTime = null;
            }
            throw new IllegalStateException("Must stop or reset Timer before starting again");
        }
        this.lapTime = this.startTime = Long.valueOf(System.currentTimeMillis());
        return this;
    }

    public Timer stop() {
        if (this.stopTime != null) {
            throw new IllegalStateException("Timer is already stopped.");
        }
        this.stopTime = System.currentTimeMillis();
        return this;
    }

    public Timer lap() {
        if (this.startTime == null || this.stopTime != null) {
            throw new IllegalStateException("Timer must be started before lapping.");
        }
        this.lapTime = this.getFinalTime();
        return this;
    }

    public Timer reset() {
        this.stopTime = null;
        this.startTime = null;
        this.lapTime = null;
        return this;
    }

    public long getElapsedMilliseconds() {
        if (this.startTime != null) {
            return this.getFinalTime() - this.startTime;
        }
        return 0L;
    }

    public long getLapMilliseconds() {
        if (this.lapTime != null) {
            return this.getFinalTime() - this.lapTime;
        }
        return 0L;
    }

    private long getFinalTime() {
        if (this.stopTime != null) {
            return this.stopTime;
        }
        return System.currentTimeMillis();
    }
}

