/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.storage.dfs.DfsPackFile;
import org.eclipse.jgit.storage.dfs.DfsReader;
import org.eclipse.jgit.storage.dfs.PackInputStream;

final class LargePackedWholeObject
extends ObjectLoader {
    private final int type;
    private final long size;
    private final long objectOffset;
    private final int headerLength;
    private final DfsPackFile pack;
    private final DfsObjDatabase db;

    LargePackedWholeObject(int type, long size, long objectOffset, int headerLength, DfsPackFile pack, DfsObjDatabase db) {
        this.type = type;
        this.size = size;
        this.objectOffset = objectOffset;
        this.headerLength = headerLength;
        this.pack = pack;
        this.db = db;
    }

    public int getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isLarge() {
        return true;
    }

    public byte[] getCachedBytes() throws LargeObjectException {
        throw new LargeObjectException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectStream openStream() throws MissingObjectException, IOException {
        InputStream in;
        DfsReader ctx = new DfsReader(this.db);
        try {
            in = new PackInputStream(this.pack, this.objectOffset + (long)this.headerLength, ctx);
        }
        catch (IOException packGone) {
            try {
                ObjectId obj = this.pack.findObjectForOffset(ctx, this.objectOffset);
                ObjectStream objectStream = ctx.open(obj, this.type).openStream();
                Object var7_7 = null;
                ctx.release();
                return objectStream;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                ctx.release();
                throw throwable;
            }
        }
        int bufsz = 8192;
        in = new BufferedInputStream(new InflaterInputStream(in, ctx.inflater(), bufsz), bufsz);
        return new ObjectStream.Filter(this.type, this.size, in);
    }
}

