/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotCommitList<L extends PlotLane>
extends RevCommitList<PlotCommit<L>> {
    static final int MAX_LENGTH = 25;
    private int positionsAllocated;
    private final TreeSet<Integer> freePositions = new TreeSet();
    private final HashSet<PlotLane> activeLanes = new HashSet(32);

    @Override
    public void clear() {
        super.clear();
        this.positionsAllocated = 0;
        this.freePositions.clear();
        this.activeLanes.clear();
    }

    @Override
    public void source(RevWalk w) {
        if (!(w instanceof PlotWalk)) {
            throw new ClassCastException(MessageFormat.format(JGitText.get().classCastNotA, PlotWalk.class.getName()));
        }
        super.source(w);
    }

    public void findPassingThrough(PlotCommit<L> currCommit, Collection<L> result) {
        for (PlotLane p : currCommit.passingLanes) {
            result.add(p);
        }
    }

    @Override
    protected void enter(int index, PlotCommit<L> currCommit) {
        this.setupChildren(currCommit);
        int nChildren = currCommit.getChildCount();
        if (nChildren == 0) {
            return;
        }
        if (nChildren == 1 && currCommit.children[0].getParentCount() < 2) {
            PlotCommit rObj;
            PlotCommit c = currCommit.children[0];
            if (c.lane == null) {
                c.lane = this.nextFreeLane();
                this.activeLanes.add(c.lane);
            }
            for (int r = index - 1; r >= 0 && (rObj = (PlotCommit)this.get(r)) != c; --r) {
                rObj.addPassingLane(c.lane);
            }
            currCommit.lane = c.lane;
            this.handleBlockedLanes(index, currCommit, nChildren);
        } else {
            PlotLane reservedLane = null;
            for (int i = 0; i < nChildren; ++i) {
                PlotCommit c = currCommit.children[i];
                if (c.lane == null) {
                    c.lane = this.nextFreeLane();
                    this.activeLanes.add(c.lane);
                    if (reservedLane != null) {
                        this.closeLane(c.lane);
                        continue;
                    }
                    reservedLane = c.lane;
                    continue;
                }
                if (reservedLane == null && this.activeLanes.contains(c.lane)) {
                    reservedLane = c.lane;
                    continue;
                }
                this.closeLane(c.lane);
            }
            if (reservedLane != null) {
                this.closeLane(reservedLane);
            }
            currCommit.lane = this.nextFreeLane();
            this.activeLanes.add(currCommit.lane);
            this.handleBlockedLanes(index, currCommit, nChildren);
        }
    }

    private void handleBlockedLanes(int index, PlotCommit<L> commit, int nChildren) {
        PlotCommit rObj;
        int remaining = nChildren;
        BitSet blockedPositions = new BitSet();
        for (int r = index - 1; !(r < 0 || commit.isChild(rObj = (PlotCommit)this.get(r)) && --remaining == 0); --r) {
            if (rObj == null) continue;
            Object lane = rObj.getLane();
            if (lane != null) {
                blockedPositions.set(((PlotLane)lane).getPosition());
            }
            rObj.addPassingLane(commit.lane);
        }
        if (blockedPositions.get(commit.lane.getPosition())) {
            int newPos = -1;
            for (Integer pos : this.freePositions) {
                if (blockedPositions.get(pos)) continue;
                newPos = pos;
                break;
            }
            if (newPos == -1) {
                newPos = this.positionsAllocated++;
            }
            this.freePositions.add(commit.lane.getPosition());
            this.activeLanes.remove(commit.lane);
            commit.lane.position = newPos;
            this.activeLanes.add(commit.lane);
        }
    }

    private void closeLane(PlotLane lane) {
        this.recycleLane(lane);
        if (this.activeLanes.remove(lane)) {
            this.freePositions.add(lane.getPosition());
        }
    }

    private void setupChildren(PlotCommit<L> currCommit) {
        int nParents = currCommit.getParentCount();
        for (int i = 0; i < nParents; ++i) {
            ((PlotCommit)currCommit.getParent(i)).addChild(currCommit);
        }
    }

    private PlotLane nextFreeLane() {
        L p = this.createLane();
        if (this.freePositions.isEmpty()) {
            ((PlotLane)p).position = this.positionsAllocated++;
        } else {
            Integer min = this.freePositions.first();
            ((PlotLane)p).position = min;
            this.freePositions.remove(min);
        }
        return p;
    }

    protected L createLane() {
        return (L)new PlotLane();
    }

    protected void recycleLane(L lane) {
    }
}

