/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LsRemoteCommand
extends TransportCommand<LsRemoteCommand, Collection<Ref>> {
    private String remote = "origin";
    private boolean heads;
    private boolean tags;
    private String uploadPack;

    public LsRemoteCommand(Repository repo) {
        super(repo);
    }

    public LsRemoteCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public void setHeads(boolean heads) {
        this.heads = heads;
    }

    public void setTags(boolean tags) {
        this.tags = tags;
    }

    public void setUploadPack(String uploadPack) {
        this.uploadPack = uploadPack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Ref> call() throws Exception {
        this.checkCallable();
        Transport transport = Transport.open(this.repo, this.remote);
        transport.setOptionUploadPack(this.uploadPack);
        this.configure(transport);
        try {
            ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>(1);
            if (this.tags) {
                refSpecs.add(new RefSpec("refs/tags/*:refs/remotes/origin/tags/*"));
            }
            if (this.heads) {
                refSpecs.add(new RefSpec("refs/heads/*:refs/remotes/origin/*"));
            }
            HashMap<String, Ref> refmap = new HashMap<String, Ref>();
            FetchConnection fc = transport.openFetch();
            try {
                Collection<Ref> refs = fc.getRefs();
                if (refSpecs.isEmpty()) {
                    for (Ref r : refs) {
                        refmap.put(r.getName(), r);
                    }
                } else {
                    block11: for (Ref r : refs) {
                        for (RefSpec rs : refSpecs) {
                            if (!rs.matchSource(r)) continue;
                            refmap.put(r.getName(), r);
                            continue block11;
                        }
                    }
                }
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                fc.close();
                throw throwable;
            }
            fc.close();
            Collection<Ref> collection = refmap.values();
            {
                Object var13_17 = null;
                transport.close();
            }
            return collection;
        }
        catch (TransportException e) {
            try {
                try {
                    throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfLsRemoteCommand, e);
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    transport.close();
                    throw throwable;
                }
            }
            catch (URISyntaxException e2) {
                throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote));
            }
            catch (NotSupportedException e3) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfLsRemoteCommand, e3);
            }
        }
    }
}

