/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.plugins;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.maven.plugins.Configuration;
import org.jboss.forge.maven.plugins.ConfigurationBuilder;
import org.jboss.forge.maven.plugins.Execution;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.project.dependencies.Dependency;

public class MavenPluginImpl
implements MavenPlugin {
    private Dependency dependency;
    private Configuration configuration;
    private final List<Execution> executions = new ArrayList<Execution>();
    private boolean extensions;

    public MavenPluginImpl() {
    }

    public MavenPluginImpl(MavenPlugin plugin) {
        this.dependency = plugin.getDependency();
        this.configuration = plugin.getConfig();
    }

    @Override
    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    @Override
    public Configuration getConfig() {
        if (this.configuration == null) {
            this.configuration = ConfigurationBuilder.create();
        }
        return this.configuration;
    }

    @Override
    public List<Execution> listExecutions() {
        return this.executions;
    }

    @Override
    public boolean isExtensionsEnabled() {
        return this.extensions;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("<plugin>");
        if (this.dependency.getGroupId() != null) {
            b.append("<groupId>").append(this.dependency.getGroupId()).append("</groupId>");
        }
        if (this.dependency.getArtifactId() != null) {
            b.append("<artifactId>").append(this.dependency.getArtifactId()).append("</artifactId>");
        }
        if (this.dependency.getVersion() != null) {
            b.append("<version>").append(this.dependency.getVersion()).append("</version>");
        }
        if (this.extensions) {
            b.append("<extensions>true</extensions>");
        }
        if (this.configuration != null) {
            b.append(this.configuration.toString());
        }
        if (this.executions.size() > 0) {
            b.append("<executions>");
            for (Execution execution : this.executions) {
                b.append(execution.toString());
            }
            b.append("</executions>");
        }
        b.append("</plugin>");
        return b.toString();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void addExecution(Execution execution) {
        this.executions.add(execution);
    }

    public void setExtenstions(boolean extenstions) {
        this.extensions = extenstions;
    }
}

