/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffold.faces;

import java.io.InputStream;
import java.util.Arrays;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.scaffold.TemplateStrategy;
import org.jboss.forge.shell.util.ResourceUtil;
import org.jboss.forge.shell.util.Streams;

public class FacesTemplateStrategy
implements TemplateStrategy {
    private static final String SCAFFOLD_FORGE_TEMPLATE = "/resources/scaffold/pageTemplate.xhtml";
    private final Project project;

    public FacesTemplateStrategy(Project project) {
        this.project = project;
    }

    public boolean compatibleWith(Resource<?> template) {
        String contents = Streams.toString((InputStream)template.getResourceInputStream());
        for (String section : Arrays.asList("main")) {
            if (contents.matches(".*:\\s*insert\\s+name\\s*=\\s*\"" + section + "\".*")) continue;
            return false;
        }
        return true;
    }

    public String getReferencePath(Resource<?> template) {
        WebResourceFacet web = (WebResourceFacet)this.project.getFacet(WebResourceFacet.class);
        for (DirectoryResource dir : web.getWebRootDirectories()) {
            if (!ResourceUtil.isChildOf((Resource)dir, template)) continue;
            String relativePath = template.getFullyQualifiedName().substring(dir.getFullyQualifiedName().length());
            return relativePath;
        }
        throw new IllegalArgumentException("Not a valid template resource for this scaffold.");
    }

    public FileResource<?> getDefaultTemplate() {
        WebResourceFacet web = (WebResourceFacet)this.project.getFacet(WebResourceFacet.class);
        return web.getWebResource(SCAFFOLD_FORGE_TEMPLATE);
    }
}

