/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.ant;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveBuildListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;

public class AntBuildListener
implements IArchiveBuildListener {
    public void buildFailed(IArchive pkg, IStatus status) {
        ArchivesCore.log(status);
    }

    public void error(IArchiveNode node, IStatus[] multi) {
        int i = 0;
        while (i < multi.length) {
            ArchivesCore.log(multi[i]);
            ++i;
        }
    }

    public void cleanArchive(IArchive pkg) {
        ArchivesCore.log(1, ArchivesCore.bind(ArchivesCoreMessages.CleanedArchiveTrace, pkg.getName()), null);
    }

    public void cleanProject(IPath project) {
        ArchivesCore.log(1, ArchivesCore.bind(ArchivesCoreMessages.CleanedProjectTrace, project.toString()), null);
    }

    public void fileRemoved(IArchive topLevelArchive, IArchiveFileSet fileset, IPath filePath) {
        DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] wrappers = fileset.getMatches(filePath);
        int i = 0;
        while (i < wrappers.length) {
            String s = ArchivesCore.bind(ArchivesCoreMessages.FileRemovedTrace, new Object[]{filePath, topLevelArchive.getName(), wrappers[i].getRootArchiveRelative().toString()});
            ArchivesCore.log(0, s, null);
            ++i;
        }
    }

    public void fileUpdated(IArchive topLevelArchive, IArchiveFileSet fileset, IPath filePath) {
        DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] wrappers = fileset.getMatches(filePath);
        int i = 0;
        while (i < wrappers.length) {
            String s = ArchivesCore.bind(ArchivesCoreMessages.UpdatedFileTrace, new Object[]{filePath, topLevelArchive.getName(), wrappers[i].getRootArchiveRelative().toString()});
            ArchivesCore.log(0, s, null);
            ++i;
        }
    }

    public void finishedBuild(IPath project) {
        ArchivesCore.log(1, ArchivesCore.bind(ArchivesCoreMessages.FinishedBuildingProjectTrace, project.toString()), null);
    }

    public void finishedBuildingArchive(IArchive pkg) {
        ArchivesCore.log(1, ArchivesCore.bind(ArchivesCoreMessages.FinishedBuildingArchiveTrace, pkg.getRootArchiveRelativePath().toString()), null);
    }

    public void finishedCollectingFileSet(IArchiveFileSet fileset) {
        ArchivesCore.log(1, ArchivesCore.bind(ArchivesCoreMessages.FinishedCollectingFilesetTrace, fileset.toString()), null);
    }

    public void startedBuild(IPath project) {
        ArchivesCore.log(1, ArchivesCore.bind(ArchivesCoreMessages.StartedBuildingProjectTrace, project.toString()), null);
    }

    public void startedBuildingArchive(IArchive pkg) {
        ArchivesCore.log(1, ArchivesCore.bind(ArchivesCoreMessages.StartedBuildingArchiveTrace, pkg.toString()), null);
    }

    public void startedCollectingFileSet(IArchiveFileSet fileset) {
        ArchivesCore.log(1, ArchivesCore.bind(ArchivesCoreMessages.StartedCollectingFilesetTrace, fileset.toString()), null);
    }
}

