/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchivesLogger;
import org.jboss.ide.eclipse.archives.core.model.IArchivesVFS;
import org.jboss.ide.eclipse.archives.core.model.IExtensionManager;
import org.jboss.ide.eclipse.archives.core.model.IPreferenceManager;

public abstract class ArchivesCore {
    public static final String PLUGIN_ID = "org.jboss.ide.eclipse.archives.core";
    private static ArchivesCore instance;
    public static final int STANDALONE = 0;
    public static final int WORKSPACE = 1;
    private int runType;
    private IArchivesVFS vfs;
    private IExtensionManager extensionManager;
    private IPreferenceManager preferenceManager;
    private IArchivesLogger logger;
    private IArchiveNodeFactory nodeFactory;

    public static ArchivesCore getInstance() {
        return instance;
    }

    public static void setInstance(ArchivesCore instance) {
        ArchivesCore.instance = instance;
    }

    public ArchivesCore(int runType) {
        this.runType = runType;
        this.vfs = this.createVFS();
        this.extensionManager = this.createExtensionManager();
        this.preferenceManager = this.createPreferenceManager();
        this.logger = this.createLogger();
        this.nodeFactory = this.createNodeFactory();
    }

    protected abstract IArchivesVFS createVFS();

    protected abstract IExtensionManager createExtensionManager();

    protected abstract IPreferenceManager createPreferenceManager();

    protected abstract IArchivesLogger createLogger();

    protected abstract IArchiveNodeFactory createNodeFactory();

    public int getRunType() {
        return this.runType;
    }

    public IArchivesVFS getVFS() {
        return this.vfs;
    }

    public IExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public IPreferenceManager getPreferenceManager() {
        return this.preferenceManager;
    }

    public IArchivesLogger getLogger() {
        return this.logger;
    }

    public IArchiveNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public abstract void preRegisterProject(IPath var1);

    protected abstract String bind2(String var1, Object[] var2);

    public static String bind(String message, Object[] bindings) {
        return ArchivesCore.getInstance().bind2(message, bindings);
    }

    public static String bind(String message, String binding1) {
        return ArchivesCore.getInstance().bind2(message, new Object[]{binding1});
    }

    public static String bind(String message, String binding1, String binding2) {
        return ArchivesCore.getInstance().bind2(message, new Object[]{binding1, binding2});
    }

    public static void log(IStatus status) {
        ArchivesCore.getInstance().getLogger().log(status);
    }

    public static void log(int severity, String message, Throwable throwable) {
        ArchivesCore.getInstance().getLogger().log(severity, message, throwable);
    }
}

