/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.ws.rs.Path;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.shell.project.ProjectScoped;
import org.jboss.forge.spec.javaee.EJBFacet;
import org.jboss.forge.spec.javaee.JTAFacet;
import org.jboss.forge.spec.javaee.PersistenceFacet;
import org.jboss.forge.spec.javaee.RestActivatorType;
import org.jboss.forge.spec.javaee.RestApplicationFacet;
import org.jboss.forge.spec.javaee.RestFacet;
import org.jboss.forge.spec.javaee.rest.ContentTypeCompleter;
import org.jboss.forge.spec.javaee.rest.RestWebXmlFacetImpl;
import org.jboss.seam.render.TemplateCompiler;
import org.jboss.seam.render.template.CompiledTemplateResource;

@Alias(value="rest")
@RequiresFacet(value={RestFacet.class})
@RequiresProject
public class RestPlugin
implements Plugin {
    @Inject
    private Project project;
    @Inject
    private Event<InstallFacets> request;
    @Inject
    @Current
    private Resource<?> currentResource;
    @Inject
    private TemplateCompiler compiler;
    @Inject
    private ShellPrompt prompt;
    @Inject
    @ProjectScoped
    Configuration configuration;

    @SetupCommand
    public void setup(@Option(name="activatorType") RestActivatorType activatorType, PipeOut out) {
        if (!this.project.hasFacet(RestFacet.class)) {
            this.request.fire((Object)new InstallFacets(RestFacet.class));
        }
        String rootpath = this.prompt.prompt("What root path do you want to use for your resources?", "/rest");
        this.configuration.addProperty("rootpath", (Object)rootpath);
        if (activatorType == null || activatorType == RestActivatorType.WEB_XML && !this.project.hasFacet(RestWebXmlFacetImpl.class)) {
            this.request.fire((Object)new InstallFacets(RestWebXmlFacetImpl.class));
        } else if (activatorType == RestActivatorType.APP_CLASS && !this.project.hasFacet(RestApplicationFacet.class)) {
            String pkg = this.prompt.promptCommon("In what package do you want to store the Application class?", PromptType.JAVA_PACKAGE);
            String restApplication = this.prompt.prompt("How do you want to name the Application class?", "RestApplication");
            this.configuration.addProperty("rest.applicationclass.package", (Object)pkg);
            this.configuration.addProperty("rest.applicationclass.name", (Object)restApplication);
            this.request.fire((Object)new InstallFacets(RestApplicationFacet.class));
        }
        if (this.project.hasFacet(RestFacet.class)) {
            ShellMessages.success((ShellPrintWriter)out, (String)"Rest Web Services (JAX-RS) is installed.");
        }
    }

    @Command(value="endpoint-from-entity", help="Creates a REST endpoint from an existing domain @Entity object")
    public void endpointFromEntity(PipeOut out, @Option(name="contentType", defaultValue="application/xml", completer=ContentTypeCompleter.class) String contentType, @Option(required=false) JavaResource[] targets) throws FileNotFoundException {
        List<JavaResource> javaTargets;
        if (!this.project.hasAllFacets(Arrays.asList(EJBFacet.class, PersistenceFacet.class))) {
            this.request.fire((Object)new InstallFacets(true, new Class[]{JTAFacet.class, EJBFacet.class, PersistenceFacet.class}));
        }
        if ((targets == null || targets.length < 1) && this.currentResource instanceof JavaResource) {
            targets = new JavaResource[]{(JavaResource)this.currentResource};
        }
        if ((javaTargets = this.selectTargets(out, (Resource<?>[])targets)).isEmpty()) {
            ShellMessages.error((ShellPrintWriter)out, (String)"Must specify a domain @Entity on which to operate.");
            return;
        }
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        for (JavaResource jr : javaTargets) {
            String idType;
            JavaClass entity = (JavaClass)jr.getJavaSource();
            if (!entity.hasAnnotation(XmlRootElement.class)) {
                entity.addAnnotation(XmlRootElement.class);
            }
            if (!Types.isBasicType((String)(idType = this.resolveIdType(entity)))) {
                ShellMessages.error((ShellPrintWriter)out, (String)("Skipped class [" + entity.getQualifiedName() + "] because @Id type [" + idType + "] is not supported by endpoint generation."));
                continue;
            }
            String idSetterName = this.resolveIdSetterName(entity);
            CompiledTemplateResource template = this.compiler.compileResource(this.getClass().getResourceAsStream("/org/jboss/forge/rest/Endpoint.jv"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entity", entity);
            map.put("idType", idType);
            map.put("setIdStatement", idSetterName);
            map.put("contentType", contentType);
            map.put("entityTable", this.getEntityTable(entity));
            JavaClass endpoint = (JavaClass)JavaParser.parse(JavaClass.class, (String)template.render(map));
            endpoint.addImport(entity.getQualifiedName());
            endpoint.setPackage(java.getBasePackage() + ".rest");
            endpoint.getAnnotation(Path.class).setStringValue("/" + this.getEntityTable(entity).toLowerCase());
            java.saveJavaSource((JavaSource)entity);
            if (!java.getJavaResource((JavaSource)endpoint).exists() || this.prompt.promptBoolean("Endpoint [" + endpoint.getQualifiedName() + "] already, exists. Overwrite?")) {
                java.saveJavaSource((JavaSource)endpoint);
                ShellMessages.success((ShellPrintWriter)out, (String)("Generated REST endpoint for [" + entity.getQualifiedName() + "]"));
                continue;
            }
            ShellMessages.info((ShellPrintWriter)out, (String)("Aborted endpoint generation for [" + entity.getQualifiedName() + "]"));
        }
    }

    private String resolveIdType(JavaClass entity) {
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            if (member instanceof Method) {
                return ((Method)member).getReturnType();
            }
            if (!(member instanceof Field)) continue;
            return ((Field)member).getType();
        }
        return "Object";
    }

    private String resolveIdSetterName(JavaClass entity) {
        String result = null;
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            String name = member.getName();
            String type = null;
            if (member instanceof Method) {
                type = ((Method)member).getReturnType();
                if (name.startsWith("get")) {
                    name = name.substring(2);
                }
            } else if (member instanceof Field) {
                type = ((Field)member).getType();
            }
            if (type != null) {
                for (Method method : entity.getMethods()) {
                    Parameter param;
                    if (method.getParameters().size() != 1 || method.getReturnType() != null || !type.equals((param = (Parameter)method.getParameters().get(0)).getType()) || !method.getName().toLowerCase().contains(name.toLowerCase())) continue;
                    result = method.getName() + "(id)";
                    break;
                }
            }
            if (result != null) break;
            if (type == null || result != null || !member.isPublic()) continue;
            String memberName = member.getName();
            if (member instanceof Method && memberName.startsWith("get")) {
                memberName = memberName.substring(3);
                memberName = Strings.uncapitalize((String)memberName);
            }
            result = memberName + " = id";
        }
        if (result == null) {
            throw new RuntimeException("Could not determine @Id field and setter method for @Entity [" + entity.getQualifiedName() + "]. Aborting.");
        }
        return result;
    }

    private String getEntityTable(JavaClass entity) {
        String table = entity.getName();
        if (entity.hasAnnotation(Entity.class)) {
            Annotation a = entity.getAnnotation(Entity.class);
            if (!Strings.isNullOrEmpty((String)a.getStringValue("name"))) {
                table = a.getStringValue("name");
            } else if (!Strings.isNullOrEmpty((String)a.getStringValue())) {
                table = a.getStringValue();
            }
        }
        return table;
    }

    private List<JavaResource> selectTargets(PipeOut out, Resource<?>[] targets) throws FileNotFoundException {
        ArrayList<JavaResource> results = new ArrayList<JavaResource>();
        if (targets == null) {
            targets = new Resource[]{};
        }
        for (Resource<?> r : targets) {
            if (!(r instanceof JavaResource)) continue;
            JavaSource entity = ((JavaResource)r).getJavaSource();
            if (entity instanceof JavaClass) {
                if (entity.hasAnnotation(Entity.class)) {
                    results.add((JavaResource)r);
                    continue;
                }
                this.displaySkippingResourceMsg(out, entity);
                continue;
            }
            this.displaySkippingResourceMsg(out, entity);
        }
        return results;
    }

    private void displaySkippingResourceMsg(PipeOut out, JavaSource<?> entity) {
        if (!out.isPiped()) {
            ShellMessages.info((ShellPrintWriter)out, (String)("Skipped non-@Entity Java resource [" + entity.getQualifiedName() + "]"));
        }
    }
}

