/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.SecurityRole;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.AuthMethodType;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.CookieConfigDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ErrorPage;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FacesProjectStage;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FacesStateSavingMethod;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FilterDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FilterMappingDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.LoginConfig;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.SecurityConstraintDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ServletDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ServletMappingDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.TrackingModeType;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.CookieConfigDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.FilterDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.FilterMappingDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.SecurityConstraintDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.ServletDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.ServletMappingDefImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppDescriptorImpl
extends NodeDescriptorImplBase
implements WebAppDescriptor {
    private static final String SCHEMA_LOCATION = "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_%s.xsd";
    private static final String NODE_NAME_FILTER = "filter";
    private static final String NODE_NAME_FILTER_MAPPINGS = "filter-mapping";
    private static final String NODE_NAME_FILTER_NAME = "filter-name";
    private static final String NODE_NAME_SERVLET = "servlet";
    private static final String NODE_NAME_SERVLET_MAPPINGS = "servlet-mapping";
    private static final String NODE_NAME_SERVLET_NAME = "servlet-name";
    private final Node model;

    public WebAppDescriptorImpl(String descriptorName) {
        this(descriptorName, new Node("web-app").attribute("xmlns", "http://java.sun.com/xml/ns/javaee").attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        this.version("3.0");
    }

    public WebAppDescriptorImpl(String descriptorName, Node model) {
        super(descriptorName);
        this.model = model;
    }

    @Override
    public WebAppDescriptor version(String version) {
        if (version == null || version.length() == 0) {
            throw new IllegalArgumentException("Version must be specified");
        }
        this.model.attribute("xsi:schemaLocation", String.format(SCHEMA_LOCATION, version.replace(".", "_")));
        this.model.attribute("version", version);
        return this;
    }

    @Override
    public WebAppDescriptor metadataComplete(boolean value) {
        this.model.attribute("metadata-complete", (Object)value);
        return this;
    }

    @Override
    public WebAppDescriptor moduleName(String name) {
        this.model.getOrCreate("module-name").text(name);
        return this;
    }

    @Override
    public WebAppDescriptor description(String description) {
        this.model.createChild("description").text(description);
        return this;
    }

    @Override
    public WebAppDescriptor displayName(String displayName) {
        this.model.getOrCreate("display-name").text(displayName);
        return this;
    }

    @Override
    public WebAppDescriptor distributable() {
        this.model.getOrCreate("distributable");
        return this;
    }

    @Override
    public WebAppDescriptor contextParam(String name, Object value) {
        List params = this.model.get("context-param");
        Node param = null;
        for (Node node : params) {
            param = node.getSingle("param-name=" + name);
            if (param == null) continue;
            param.getParent().getOrCreate("param-value").text(value);
            break;
        }
        if (param == null) {
            param = this.model.createChild("context-param");
            param.createChild("param-name").text(name);
            param.createChild("param-value").text(value);
        }
        return this;
    }

    @Override
    public WebAppDescriptor facesProjectStage(FacesProjectStage stage) {
        return this.contextParam("javax.faces.PROJECT_STAGE", stage.getStage());
    }

    @Override
    public WebAppDescriptor facesStateSavingMethod(FacesStateSavingMethod method) {
        return this.contextParam("javax.faces.STATE_SAVING_METHOD", method.name());
    }

    @Override
    public WebAppDescriptor facesConfigFiles(String ... paths) {
        if (paths == null || paths.length == 0) {
            return this;
        }
        return this.contextParam("javax.faces.CONFIG_FILES", Strings.join(Arrays.asList(paths), ","));
    }

    @Override
    public WebAppDescriptor listener(Class<? extends EventListener> clazz) {
        return this.listener(clazz.getName());
    }

    @Override
    public WebAppDescriptor listener(String clazz) {
        this.model.createChild("listener").createChild("listener-class").text(clazz);
        return this;
    }

    @Override
    public List<FilterDef> getFilters() {
        ArrayList<FilterDef> filters = new ArrayList<FilterDef>();
        for (Node filterNode : this.model.get(NODE_NAME_FILTER)) {
            FilterDefImpl filter = new FilterDefImpl(this.getDescriptorName(), this.model, filterNode);
            filters.add(filter);
        }
        return filters;
    }

    @Override
    public List<FilterMappingDef> getFilterMappings() {
        ArrayList<FilterMappingDef> mappings = new ArrayList<FilterMappingDef>();
        for (Node mappingNode : this.model.get(NODE_NAME_FILTER_MAPPINGS)) {
            String filterName = mappingNode.getSingle(NODE_NAME_FILTER_NAME).getText();
            FilterDef filterDef = null;
            List<FilterDef> filters = this.getFilters();
            for (FilterDef filter : filters) {
                if (!Strings.areEqualTrimmed(filter.getName(), filterName)) continue;
                filterDef = filter;
            }
            FilterMappingDefImpl filterMapping = new FilterMappingDefImpl(this.getDescriptorName(), this.getRootNode(), ((FilterDefImpl)filterDef).getNode(), mappingNode);
            mappings.add(filterMapping);
        }
        return mappings;
    }

    @Override
    public FilterDef filter(Class<? extends Filter> clazz, String ... urlPatterns) {
        return this.filter(clazz.getSimpleName(), clazz.getName(), urlPatterns);
    }

    @Override
    public FilterDef filter(String clazz, String ... urlPatterns) {
        return this.filter(this.getSimpleName(clazz), clazz, urlPatterns);
    }

    @Override
    public FilterDef filter(String name, Class<? extends Filter> clazz, String[] urlPatterns) {
        return this.filter(name, clazz.getName(), urlPatterns);
    }

    @Override
    public FilterDef filter(String name, String clazz, String[] urlPatterns) {
        Node filter = this.model.createChild(NODE_NAME_FILTER);
        filter.createChild(NODE_NAME_FILTER_NAME).text(name);
        filter.createChild("filter-class").text(clazz);
        FilterMappingDef f = new FilterDefImpl(this.getDescriptorName(), this.model, filter).mapping().urlPatterns(urlPatterns);
        return f;
    }

    @Override
    public ServletDef servlet(Class<? extends Servlet> clazz, String ... urlPatterns) {
        return this.servlet(clazz.getSimpleName(), clazz.getName(), urlPatterns);
    }

    @Override
    public ServletDef servlet(String clazz, String ... urlPatterns) {
        return this.servlet(this.getSimpleName(clazz), clazz, urlPatterns);
    }

    @Override
    public ServletDef servlet(String name, Class<? extends Servlet> clazz, String[] urlPatterns) {
        return this.servlet(name, clazz.getName(), urlPatterns);
    }

    @Override
    public ServletDef servlet(String name, String clazz, String[] urlPatterns) {
        Node servletNode = this.model.createChild(NODE_NAME_SERVLET);
        servletNode.createChild(NODE_NAME_SERVLET_NAME).text(name);
        servletNode.createChild("servlet-class").text(clazz);
        ServletDefImpl servlet = new ServletDefImpl(this.getDescriptorName(), this.model, servletNode);
        servlet.mapping().urlPatterns(urlPatterns);
        return servlet;
    }

    @Override
    public WebAppDescriptor facesServlet() {
        return this.servlet(FacesServlet.class, "*.jsf");
    }

    @Override
    public WebAppDescriptor welcomeFiles(String ... servletPaths) {
        for (String p : servletPaths) {
            this.model.getOrCreate("welcome-file-list").createChild("welcome-file").text(p);
        }
        return this;
    }

    @Override
    public WebAppDescriptor welcomeFile(String servletPath) {
        return this.welcomeFiles(servletPath);
    }

    @Override
    public WebAppDescriptor sessionTimeout(int timeout) {
        this.model.getOrCreate("session-config").getOrCreate("session-timeout").text((Object)timeout);
        return this;
    }

    @Override
    public WebAppDescriptor sessionTrackingModes(TrackingModeType ... sessionTrackingModes) {
        for (TrackingModeType m : sessionTrackingModes) {
            this.model.getOrCreate("session-config").createChild("tracking-mode").text(m.name());
        }
        return this;
    }

    @Override
    public CookieConfigDef sessionCookieConfig() {
        return new CookieConfigDefImpl(this.getDescriptorName(), this.model);
    }

    @Override
    public WebAppDescriptor errorPage(int errorCode, String location) {
        Node error = this.model.createChild("error-page");
        error.createChild("error-code").text((Object)errorCode);
        error.createChild("location").text(location);
        return this;
    }

    @Override
    public WebAppDescriptor errorPage(String exceptionClass, String location) {
        Node error = this.model.createChild("error-page");
        error.createChild("exception-type").text(exceptionClass);
        error.createChild("location").text(location);
        return this;
    }

    @Override
    public WebAppDescriptor errorPage(Class<? extends Throwable> exceptionClass, String location) {
        return this.errorPage(exceptionClass.getName(), location);
    }

    @Override
    public WebAppDescriptor loginConfig(AuthMethodType authMethod, String realmName) {
        return this.loginConfig(authMethod.toString(), realmName);
    }

    @Override
    public WebAppDescriptor loginConfig(String authMethod, String realmName) {
        Node login = this.model.createChild("login-config");
        login.createChild("auth-method").text(authMethod);
        login.createChild("realm-name").text(realmName);
        return this;
    }

    @Override
    public WebAppDescriptor formLoginConfig(String loginPage, String errorPage) {
        Node login = this.model.createChild("login-config");
        login.createChild("auth-method").text((Object)AuthMethodType.FORM);
        Node form = this.model.createChild("form-login-config");
        form.createChild("form-login-page").text(loginPage);
        form.createChild("form-error-page").text(errorPage);
        return this;
    }

    @Override
    public SecurityConstraintDef securityConstraint() {
        return this.securityConstraint(null);
    }

    @Override
    public SecurityConstraintDef securityConstraint(String displayName) {
        Node security = this.model.createChild("security-constraint");
        if (displayName != null) {
            security.createChild("display-name").text(displayName);
        }
        return new SecurityConstraintDefImpl(this.getDescriptorName(), this.model, security);
    }

    @Override
    public WebAppDescriptor securityRole(String roleName) {
        return this.securityRole(roleName, null);
    }

    @Override
    public WebAppDescriptor securityRole(String roleName, String description) {
        Node security = this.model.createChild("security-role");
        if (roleName != null) {
            security.createChild("role-name").text(roleName);
        }
        if (description != null) {
            security.createChild("description").text(description);
        }
        return this;
    }

    @Override
    public WebAppDescriptor absoluteOrdering(String ... names) {
        return this.absoluteOrdering(false, names);
    }

    @Override
    public WebAppDescriptor absoluteOrdering(boolean others, String ... names) {
        Node ordering = this.model.getOrCreate("absolute-ordering");
        if (names != null) {
            for (String name : names) {
                ordering.createChild("name").text(name);
            }
        }
        if (others) {
            ordering.getOrCreate("others");
        }
        return this;
    }

    public Node getRootNode() {
        return this.model;
    }

    private String getSimpleName(String fqcn) {
        if (fqcn.indexOf(46) >= 0) {
            return fqcn.substring(fqcn.lastIndexOf(46) + 1);
        }
        return fqcn;
    }

    @Override
    public String getVersion() {
        return this.model.getAttribute("version");
    }

    @Override
    public String getModuleName() {
        return this.model.getAttribute("module-name");
    }

    @Override
    public String getDescription() {
        return this.model.getAttribute("description");
    }

    @Override
    public String getDisplayName() {
        return this.model.getAttribute("display-name");
    }

    @Override
    public boolean isDistributable() {
        return this.model.getAttribute("distributable") != null;
    }

    @Override
    public boolean isMetadataComplete() {
        String complete = this.model.getAttribute("metadata-complete");
        if (complete == null) {
            complete = "";
        }
        return "true".equalsIgnoreCase(complete);
    }

    @Override
    public String getContextParam(String name) {
        Map<String, String> params = this.getContextParams();
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (e.getKey() == null || !e.getKey().equals(name)) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public Map<String, String> getContextParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        List params = this.model.get("context-param");
        for (Node p : params) {
            String name = p.getTextValueForPatternName("param-name");
            String value = p.getTextValueForPatternName("param-value");
            result.put(name, value);
        }
        return result;
    }

    @Override
    public List<String> getFaceletsDefaultSuffixes() {
        List<Object> suffixes = new ArrayList();
        String value = this.getContextParam("javax.faces.FACELETS_SUFFIX");
        suffixes = value != null ? Arrays.asList(value.split("\\s+")) : Arrays.asList(".xhtml".split("\\s+"));
        return suffixes;
    }

    @Override
    public WebAppDescriptor faceletsDefaultSuffixes(String ... suffixes) {
        this.contextParam("javax.faces.FACELETS_SUFFIX", Strings.join(Arrays.asList(suffixes), " "));
        return this;
    }

    @Override
    public List<String> getFacesDefaultSuffixes() {
        ArrayList<String> suffixes = new ArrayList<String>();
        String value = this.getContextParam("javax.faces.DEFAULT_SUFFIX");
        if (value != null) {
            suffixes.addAll(Arrays.asList(value.split("\\s+")));
        } else {
            suffixes.addAll(Arrays.asList(".xhtml .jsp".split("\\s+")));
        }
        return suffixes;
    }

    @Override
    public WebAppDescriptor facesDefaultSuffixes(String ... suffixes) {
        this.contextParam("javax.faces.DEFAULT_SUFFIX", Strings.join(Arrays.asList(suffixes), " "));
        return this;
    }

    @Override
    public List<String> getFaceletsViewMappings() {
        ArrayList<String> mappings = new ArrayList<String>();
        String value = this.getContextParam("javax.faces.FACELETS_VIEW_MAPPINGS");
        if (value != null) {
            mappings.addAll(Arrays.asList(value.split("\\s*;\\s*")));
        }
        return mappings;
    }

    @Override
    public WebAppDescriptor faceletsViewMappings(String ... mappings) {
        this.contextParam("javax.faces.FACELETS_VIEW_MAPPINGS", Strings.join(Arrays.asList(mappings), ";"));
        return null;
    }

    @Override
    public FacesProjectStage getFacesProjectStage() {
        String value = this.getContextParam("javax.faces.PROJECT_STAGE");
        for (FacesProjectStage stage : FacesProjectStage.values()) {
            if (!stage.getStage().equals(value)) continue;
            return stage;
        }
        return FacesProjectStage.PRODUCTION;
    }

    @Override
    public FacesStateSavingMethod getFacesStateSavingMethod() {
        return FacesStateSavingMethod.valueOf(this.getContextParam("javax.faces.STATE_SAVING_METHOD"));
    }

    @Override
    public List<String> getFacesConfigFiles() {
        String value = this.getContextParam("javax.faces.CONFIG_FILES");
        return value == null ? new ArrayList() : Arrays.asList(value.split(","));
    }

    @Override
    public List<String> getListeners() {
        return this.model.getTextValuesForPatternName("listener/listener-class");
    }

    @Override
    public List<ServletDef> getServlets() {
        ArrayList<ServletDef> servlets = new ArrayList<ServletDef>();
        for (Node servlet : this.model.get(NODE_NAME_SERVLET)) {
            ServletDefImpl filter = new ServletDefImpl(this.getDescriptorName(), this.model, servlet);
            servlets.add(filter);
        }
        return servlets;
    }

    @Override
    public List<ServletMappingDef> getServletMappings() {
        ArrayList<ServletMappingDef> mappings = new ArrayList<ServletMappingDef>();
        for (Node mappingNode : this.model.get(NODE_NAME_SERVLET_MAPPINGS)) {
            String servletName = mappingNode.getSingle(NODE_NAME_SERVLET_NAME).getText();
            ServletDef servletDef = null;
            List<ServletDef> servlets = this.getServlets();
            for (ServletDef servlet : servlets) {
                if (!Strings.areEqualTrimmed(servlet.getName(), servletName)) continue;
                servletDef = servlet;
            }
            ServletMappingDefImpl servletMapping = new ServletMappingDefImpl(this.getDescriptorName(), this.getRootNode(), ((ServletDefImpl)servletDef).getNode(), mappingNode);
            mappings.add(servletMapping);
        }
        return mappings;
    }

    @Override
    public boolean hasFacesServlet() {
        List list = this.model.get("servlet/servlet-class=javax.faces.webapp.FacesServlet");
        return !list.isEmpty();
    }

    @Override
    public List<String> getWelcomeFiles() {
        ArrayList<String> results = new ArrayList<String>();
        List list = this.model.get("welcome-file-list/welcome-file");
        for (Node file : list) {
            results.add(file.getText());
        }
        return results;
    }

    @Override
    public int getSessionTimeout() {
        Node single = this.model.getSingle("session-config/session-timeout");
        if (single != null) {
            try {
                return Integer.parseInt(single.getText().trim());
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unable to parse session-timeout from value [" + single.getText().trim() + "]");
            }
        }
        return 0;
    }

    @Override
    public List<TrackingModeType> getSessionTrackingModes() {
        return null;
    }

    @Override
    public List<ErrorPage> getErrorPages() {
        return null;
    }

    @Override
    public List<LoginConfig> getLoginConfigs() {
        return null;
    }

    @Override
    public List<SecurityConstraintDef> getSecurityConstraints() {
        return null;
    }

    @Override
    public List<SecurityRole> getSecurityRoles() {
        return null;
    }
}

