/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetbuilder;

import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.JTextComponent;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.SwingValuePropertyProvider;
import org.metawidget.swing.widgetbuilder.SwingWidgetBuilderUtils;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingWidgetBuilder
implements WidgetBuilder<JComponent, SwingMetawidget>,
SwingValuePropertyProvider {
    @Override
    public String getValueProperty(Component component) {
        if (component instanceof JComboBox) {
            return "selectedItem";
        }
        if (component instanceof JTextComponent) {
            return "text";
        }
        if (component instanceof JSpinner) {
            return "value";
        }
        if (component instanceof JSlider) {
            return "value";
        }
        if (component instanceof JCheckBox) {
            return "selected";
        }
        return null;
    }

    @Override
    public JComponent buildWidget(String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        Class<?> clazz;
        if ("true".equals(attributes.get("hidden"))) {
            return new Stub();
        }
        if ("action".equals(elementName)) {
            return new JButton(metawidget.getLabelString(attributes));
        }
        String type = WidgetBuilderUtils.getActualClassOrType(attributes);
        if (type == null) {
            type = String.class.getName();
        }
        if (Boolean.class.equals(clazz = ClassUtils.niceForName(type)) && "true".equals(attributes.get("required"))) {
            return new JCheckBox();
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            JComboBox<Object> comboBox = new JComboBox<Object>();
            if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
                comboBox.addItem(null);
            }
            List<String> values = CollectionUtils.fromString(lookup);
            BindingConverter converter = metawidget.getWidgetProcessor(BindingConverter.class);
            for (String value : values) {
                Object convertedValue = converter == null ? value : converter.convertFromString(value, clazz);
                comboBox.addItem(convertedValue);
            }
            String lookupLabels = attributes.get("lookup-labels");
            if (lookupLabels != null && !"".equals(lookupLabels)) {
                Map<String, String> labelsMap = SwingWidgetBuilderUtils.getLabelsMap(values, CollectionUtils.fromString(attributes.get("lookup-labels")));
                comboBox.setEditor(new LookupComboBoxEditor(labelsMap));
                comboBox.setRenderer(new LookupComboBoxRenderer(labelsMap));
            }
            return comboBox;
        }
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return new JCheckBox();
                }
                if (Character.TYPE.equals(clazz)) {
                    return new JTextField();
                }
                String minimumValue = attributes.get("minimum-value");
                String maximumValue = attributes.get("maximum-value");
                if (minimumValue != null && !"".equals(minimumValue) && maximumValue != null && !"".equals(maximumValue)) {
                    JSlider slider = new JSlider();
                    slider.setMinimum(Integer.parseInt(minimumValue));
                    slider.setValue(slider.getMinimum());
                    slider.setMaximum(Integer.parseInt(maximumValue));
                    return slider;
                }
                JSpinner spinner = new JSpinner();
                if (Byte.TYPE.equals(clazz)) {
                    byte value = 0;
                    byte minimum = -128;
                    byte maximum = 127;
                    if (minimumValue != null && !"".equals(minimumValue)) {
                        minimum = Byte.parseByte(minimumValue);
                        value = (byte)Math.max(value, minimum);
                    }
                    if (maximumValue != null && !"".equals(maximumValue)) {
                        maximum = Byte.parseByte(maximumValue);
                        value = (byte)Math.min(value, maximum);
                    }
                    this.setSpinnerModel(spinner, value, (Comparable<? extends Number>)minimum, (Comparable<? extends Number>)maximum, (byte)1);
                } else if (Short.TYPE.equals(clazz)) {
                    short value = 0;
                    short minimum = Short.MIN_VALUE;
                    short maximum = Short.MAX_VALUE;
                    if (minimumValue != null && !"".equals(minimumValue)) {
                        minimum = Short.parseShort(minimumValue);
                        value = (short)Math.max(value, minimum);
                    }
                    if (maximumValue != null && !"".equals(maximumValue)) {
                        maximum = Short.parseShort(maximumValue);
                        value = (short)Math.min(value, maximum);
                    }
                    this.setSpinnerModel(spinner, value, (Comparable<? extends Number>)minimum, (Comparable<? extends Number>)maximum, (short)1);
                } else if (Integer.TYPE.equals(clazz)) {
                    int value = 0;
                    int minimum = Integer.MIN_VALUE;
                    int maximum = Integer.MAX_VALUE;
                    if (minimumValue != null && !"".equals(minimumValue)) {
                        minimum = Integer.parseInt(minimumValue);
                        value = Math.max(value, minimum);
                    }
                    if (maximumValue != null && !"".equals(maximumValue)) {
                        maximum = Integer.parseInt(maximumValue);
                        value = Math.min(value, maximum);
                    }
                    this.setSpinnerModel(spinner, value, (Comparable<? extends Number>)minimum, (Comparable<? extends Number>)maximum, 1);
                } else if (Long.TYPE.equals(clazz)) {
                    long value = 0L;
                    long minimum = Long.MIN_VALUE;
                    long maximum = Long.MAX_VALUE;
                    if (minimumValue != null && !"".equals(minimumValue)) {
                        minimum = Long.parseLong(minimumValue);
                        value = Math.max(value, minimum);
                    }
                    if (maximumValue != null && !"".equals(maximumValue)) {
                        maximum = Long.parseLong(maximumValue);
                        value = Math.min(value, maximum);
                    }
                    this.setSpinnerModel(spinner, value, (Comparable<? extends Number>)minimum, (Comparable<? extends Number>)maximum, 1L);
                } else if (Float.TYPE.equals(clazz)) {
                    float value = 0.0f;
                    float minimum = -3.4028235E38f;
                    float maximum = Float.MAX_VALUE;
                    if (minimumValue != null && !"".equals(minimumValue)) {
                        minimum = Float.parseFloat(minimumValue);
                        value = Math.max(value, minimum);
                    }
                    if (maximumValue != null && !"".equals(maximumValue)) {
                        maximum = Float.parseFloat(maximumValue);
                        value = Math.min(value, maximum);
                    }
                    float stepSize = attributes.containsKey("maximum-fractional-digits") ? (float)Math.pow(10.0, -Integer.parseInt(attributes.get("maximum-fractional-digits"))) : 0.1f;
                    this.setSpinnerModel(spinner, Float.valueOf(value), Float.valueOf(minimum), Float.valueOf(maximum), Float.valueOf(stepSize));
                } else if (Double.TYPE.equals(clazz)) {
                    double value = 0.0;
                    double minimum = -1.7976931348623157E308;
                    double maximum = Double.MAX_VALUE;
                    if (minimumValue != null && !"".equals(minimumValue)) {
                        minimum = Double.parseDouble(minimumValue);
                        value = Math.max(value, minimum);
                    }
                    if (maximumValue != null && !"".equals(maximumValue)) {
                        maximum = Double.parseDouble(maximumValue);
                        value = Math.min(value, maximum);
                    }
                    double stepSize = attributes.containsKey("maximum-fractional-digits") ? (double)((float)Math.pow(10.0, -Integer.parseInt(attributes.get("maximum-fractional-digits")))) : 0.1;
                    this.setSpinnerModel(spinner, value, (Comparable<? extends Number>)minimum, (Comparable<? extends Number>)maximum, stepSize);
                }
                return spinner;
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("masked"))) {
                    return new JPasswordField();
                }
                if ("true".equals(attributes.get("large"))) {
                    JTextArea textarea = new JTextArea();
                    textarea.setLineWrap(true);
                    textarea.setWrapStyleWord(true);
                    textarea.setRows(2);
                    return new JScrollPane(textarea);
                }
                return new JTextField();
            }
            if (Character.class.isAssignableFrom(clazz)) {
                return new JTextField();
            }
            if (Date.class.equals(clazz)) {
                return new JTextField();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return new JTextField();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new Stub();
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return new JTextField();
        }
        return null;
    }

    private void setSpinnerModel(JSpinner spinner, Number value, Comparable<? extends Number> minimum, Comparable<? extends Number> maximum, Number stepSize) {
        spinner.setModel(new SpinnerNumberModel(value, minimum, maximum, stepSize));
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;
        private Map<String, String> mLookups;

        public LookupComboBoxRenderer(Map<String, String> lookups) {
            if (lookups == null) {
                throw new NullPointerException("lookups");
            }
            this.mLookups = lookups;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
            String lookup = this.mLookups.get(value);
            if (lookup != null) {
                ((JLabel)component).setText(lookup);
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupComboBoxEditor
    extends BasicComboBoxEditor {
        private Map<String, String> mLookups;

        public LookupComboBoxEditor(Map<String, String> lookups) {
            if (lookups == null) {
                throw new NullPointerException("lookups");
            }
            this.mLookups = lookups;
        }

        @Override
        public void setItem(Object item) {
            super.setItem(this.mLookups.get(item));
        }
    }
}

