/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.faces.component.html.layout;

import java.util.Map;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.statically.StaticWidget;
import org.metawidget.statically.StaticXmlMetawidget;
import org.metawidget.statically.StaticXmlStub;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.faces.component.EditableValueHolder;
import org.metawidget.statically.faces.component.html.HtmlWidget;
import org.metawidget.statically.faces.component.html.layout.HtmlMessage;
import org.metawidget.statically.faces.component.html.layout.HtmlOutputLabel;
import org.metawidget.statically.faces.component.html.layout.HtmlPanelGrid;
import org.metawidget.statically.faces.component.html.layout.HtmlPanelGridLayoutConfig;
import org.metawidget.statically.faces.component.html.layout.HtmlPanelGroup;
import org.metawidget.statically.faces.component.html.layout.HtmlSectionOutputText;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlOutputText;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.WidgetBuilderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPanelGridLayout
implements AdvancedLayout<StaticXmlWidget, StaticXmlWidget, StaticXmlMetawidget> {
    private final String mColumnStyleClasses;
    private final String mMessageStyleClass;

    public HtmlPanelGridLayout() {
        this(new HtmlPanelGridLayoutConfig());
    }

    public HtmlPanelGridLayout(HtmlPanelGridLayoutConfig config) {
        this.mColumnStyleClasses = ArrayUtils.toString(config.getColumnStyleClasses());
        this.mMessageStyleClass = config.getMessageStyleClass();
    }

    @Override
    public void onStartBuild(StaticXmlMetawidget metawidget) {
    }

    @Override
    public void startContainerLayout(StaticXmlWidget container, StaticXmlMetawidget metawidget) {
        try {
            HtmlPanelGrid panelGrid = new HtmlPanelGrid();
            panelGrid.putAttribute("columns", "3");
            panelGrid.putAttribute("id", metawidget.getAttribute("id"));
            panelGrid.putAttribute("columnClasses", this.mColumnStyleClasses);
            if (container instanceof StaticXmlMetawidget) {
                panelGrid.putAttribute("rendered", metawidget.getAttribute("rendered"));
            }
            container.getChildren().add(panelGrid);
        }
        catch (Exception e) {
            throw LayoutException.newException(e);
        }
    }

    @Override
    public void layoutWidget(StaticXmlWidget widget, String elementName, Map<String, String> attributes, StaticXmlWidget container, StaticXmlMetawidget metawidget) {
        try {
            if (widget instanceof StaticXmlStub) {
                return;
            }
            HtmlWidget panelGrid = (HtmlWidget)container.getChildren().get(0);
            if (widget instanceof HtmlSectionOutputText) {
                panelGrid.getChildren().add(widget);
                panelGrid.getChildren().add(new HtmlOutputText());
                panelGrid.getChildren().add(new HtmlOutputText());
                return;
            }
            HtmlOutputLabel label = new HtmlOutputLabel();
            String id = this.getWidgetId(widget);
            if (id != null) {
                label.putAttribute("for", id);
            }
            String labelText = metawidget.getLabelString(attributes);
            label.putAttribute("value", labelText + ":");
            panelGrid.getChildren().add(label);
            if (!(widget instanceof EditableValueHolder) || metawidget.isReadOnly() || WidgetBuilderUtils.isReadOnly(attributes)) {
                panelGrid.getChildren().add(widget);
            } else {
                HtmlPanelGroup panelGroup = new HtmlPanelGroup();
                panelGrid.getChildren().add(panelGroup);
                panelGroup.getChildren().add(widget);
                HtmlMessage message = new HtmlMessage();
                message.putAttribute("for", id);
                message.putAttribute("styleClass", this.mMessageStyleClass);
                panelGroup.getChildren().add(message);
            }
            HtmlOutputText required = new HtmlOutputText();
            if ("true".equals(widget.getAttribute("required"))) {
                required.putAttribute("value", "*");
            }
            panelGrid.getChildren().add(required);
        }
        catch (Exception e) {
            throw LayoutException.newException(e);
        }
    }

    @Override
    public void endContainerLayout(StaticXmlWidget container, StaticXmlMetawidget metawidget) {
    }

    @Override
    public void onEndBuild(StaticXmlMetawidget metawidget) {
    }

    private String getWidgetId(StaticXmlWidget widget) {
        String id = widget.getAttribute("id");
        if (id != null) {
            return id;
        }
        for (StaticWidget child : widget.getChildren()) {
            id = this.getWidgetId((StaticXmlWidget)child);
            if (id == null) continue;
            return id;
        }
        return null;
    }
}

