/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.widgetprocessor;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.convert.NumberConverter;
import javax.faces.el.ValueBinding;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.faces.component.widgetprocessor.ConverterProcessor;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardConverterProcessor
implements WidgetProcessor<UIComponent, UIMetawidget>,
ConverterProcessor {
    @Override
    public UIComponent processWidget(UIComponent component, String elementName, Map<String, String> attributes, UIMetawidget metawidget) {
        if ("action".equals(elementName)) {
            return component;
        }
        if (component instanceof UIStub) {
            ValueBinding valueBinding = component.getValueBinding("value");
            if (valueBinding != null) {
                String expressionString = valueBinding.getExpressionString();
                List children = component.getChildren();
                for (UIComponent componentChild : children) {
                    ValueBinding childValueBinding = componentChild.getValueBinding("value");
                    if (childValueBinding == null || !expressionString.equals(childValueBinding.getExpressionString())) continue;
                    this.processWidget(componentChild, elementName, attributes, metawidget);
                }
            }
            return component;
        }
        if (!(component instanceof ValueHolder)) {
            return component;
        }
        ValueHolder valueHolder = (ValueHolder)component;
        valueHolder.setConverter(this.getConverter(valueHolder, attributes));
        return component;
    }

    @Override
    public Converter getConverter(ValueHolder valueHolder, Map<String, String> attributes) {
        Converter converter = valueHolder.getConverter();
        if (converter != null) {
            return converter;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String converterId = attributes.get("faces-converter-id");
        if (converterId != null) {
            converter = context.getApplication().createConverter(converterId);
        } else if (valueHolder instanceof UISelectOne || valueHolder instanceof UISelectMany) {
            Class<?> parameterizedClass;
            String parameterizedType = WidgetBuilderUtils.getComponentType(attributes);
            if (parameterizedType != null && (parameterizedClass = ClassUtils.niceForName(parameterizedType)) != null) {
                converter = context.getApplication().createConverter(parameterizedClass);
            }
        } else {
            Class<Date> clazz;
            String type = attributes.get("type");
            if (type != null && (clazz = ClassUtils.niceForName(type)) != null && clazz.isAssignableFrom(Date.class)) {
                converter = this.getDateTimeConverter(converter);
            }
        }
        if (attributes.containsKey("date-style")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setDateStyle(attributes.get("date-style"));
        }
        if (attributes.containsKey("datetime-pattern")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setPattern(attributes.get("datetime-pattern"));
        }
        if (attributes.containsKey("time-style")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setTimeStyle(attributes.get("time-style"));
        }
        if (attributes.containsKey("time-zone")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setTimeZone(TimeZone.getTimeZone(attributes.get("time-zone")));
        }
        if (attributes.containsKey("datetime-type")) {
            converter = this.getDateTimeConverter(converter);
            ((DateTimeConverter)converter).setType(attributes.get("datetime-type"));
        }
        if (attributes.containsKey("currency-code")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setCurrencyCode(attributes.get("currency-code"));
        }
        if (attributes.containsKey("currency-symbol")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setCurrencySymbol(attributes.get("currency-symbol"));
        }
        if (attributes.containsKey("number-uses-grouping-separators")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setGroupingUsed(Boolean.parseBoolean(attributes.get("number-uses-grouping-separators")));
        }
        if (attributes.containsKey("minimum-integer-digits")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setMinIntegerDigits(Integer.parseInt(attributes.get("minimum-integer-digits")));
        }
        if (attributes.containsKey("maximum-integer-digits")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setMaxIntegerDigits(Integer.parseInt(attributes.get("maximum-integer-digits")));
        }
        if (attributes.containsKey("minimum-fractional-digits")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setMinFractionDigits(Integer.parseInt(attributes.get("minimum-fractional-digits")));
        }
        if (attributes.containsKey("maximum-fractional-digits")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setMaxFractionDigits(Integer.parseInt(attributes.get("maximum-fractional-digits")));
        }
        if (attributes.containsKey("number-pattern")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setPattern(attributes.get("number-pattern"));
        }
        if (attributes.containsKey("number-type")) {
            converter = this.getNumberConverter(converter);
            ((NumberConverter)converter).setType(attributes.get("number-type"));
        }
        if (attributes.containsKey("locale")) {
            if (converter instanceof NumberConverter) {
                ((NumberConverter)converter).setLocale(new Locale(attributes.get("locale")));
            } else {
                converter = this.getDateTimeConverter(converter);
                ((DateTimeConverter)converter).setLocale(new Locale(attributes.get("locale")));
            }
        }
        return converter;
    }

    private DateTimeConverter getDateTimeConverter(Converter existingConverter) {
        if (existingConverter != null) {
            if (!(existingConverter instanceof DateTimeConverter)) {
                throw WidgetProcessorException.newException("Unable to set date/time attributes on a " + existingConverter.getClass());
            }
            return (DateTimeConverter)existingConverter;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        DateTimeConverter dateTimeConverter = (DateTimeConverter)context.getApplication().createConverter(Date.class);
        if (dateTimeConverter != null) {
            return dateTimeConverter;
        }
        return new DateTimeConverter();
    }

    private NumberConverter getNumberConverter(Converter existingConverter) {
        if (existingConverter != null) {
            if (!(existingConverter instanceof NumberConverter)) {
                throw WidgetProcessorException.newException("Unable to set number attributes on a " + existingConverter.getClass());
            }
            return (NumberConverter)existingConverter;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        NumberConverter numberConverter = (NumberConverter)context.getApplication().createConverter(Number.class);
        if (numberConverter != null) {
            return numberConverter;
        }
        return new NumberConverter();
    }
}

