/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.wizards;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class VpeImportExportWizardsUtils {
    public static void updateTagsTable(Table tagsTable, List<VpeAnyData> tagsList, boolean clearTagsTable) {
        if (tagsTable == null || tagsTable.isDisposed() || tagsList == null) {
            return;
        }
        int selectionIndex = tagsTable.getSelectionIndex();
        if (clearTagsTable) {
            tagsTable.clearAll();
            tagsTable.update();
        }
        TableItem tableItem = null;
        Collections.sort(tagsList, new Comparator<VpeAnyData>(){

            @Override
            public int compare(VpeAnyData o1, VpeAnyData o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        int i = 0;
        while (i < tagsList.size()) {
            tableItem = tagsTable.getItemCount() > i ? tagsTable.getItem(i) : new TableItem(tagsTable, 2048, i);
            String[] itemColumnsData = new String[tagsTable.getColumnCount()];
            int j = 0;
            while (j < itemColumnsData.length) {
                itemColumnsData[j] = VpeImportExportWizardsUtils.toVisualValue(VpeImportExportWizardsUtils.getValueAt(tagsList, i, j));
                ++j;
            }
            tableItem.setText(itemColumnsData);
            ++i;
        }
        if (selectionIndex > 0) {
            try {
                tagsTable.setSelection(selectionIndex);
            }
            catch (SWTException e) {
                VpePlugin.getDefault().logError(VpeUIMessages.COULD_NOT_SET_TABLE_SELECTION, e);
            }
        }
    }

    private static String getValueAt(List<VpeAnyData> tagsList, int row, int column) {
        String result = VpeUIMessages.LIST_IS_EMPTY;
        if (tagsList != null && row >= 0 && tagsList.size() > 0 && row < tagsList.size()) {
            VpeAnyData tagItem = tagsList.get(row);
            switch (column) {
                case 0: {
                    result = tagItem.getName();
                    break;
                }
                case 1: {
                    result = tagItem.getTagForDisplay();
                    break;
                }
                case 2: {
                    result = tagItem.getUri();
                    break;
                }
                case 3: {
                    result = tagItem.isChildren() ? VpeUIMessages.TemplatesTableProvider_Yes : VpeUIMessages.TemplatesTableProvider_No;
                }
            }
        }
        return result;
    }

    private static String toVisualValue(String v) {
        if (v == null) {
            return "";
        }
        if (v.indexOf(10) >= 0) {
            v = v.replace('\n', ' ');
        }
        if (v.indexOf(9) >= 0) {
            v = v.replace('\t', ' ');
        }
        if (v.indexOf(13) >= 0) {
            v = v.replace('\r', ' ');
        }
        return v;
    }
}

