/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.jst.jsp.bundle.BundleMap;
import org.jboss.tools.jst.jsp.bundle.BundleMapUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.ElServiceUtil;
import org.jboss.tools.vpe.editor.util.Jsf2ResourceUtil;
import org.jboss.tools.vpe.editor.util.ResourceUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ELResolver {
    protected VpePageContext pageContext;

    public ELResolver(VpePageContext pageContext) {
        this.pageContext = pageContext;
    }

    public String replaceEl(String resourceString) {
        if (resourceString == null) {
            return "";
        }
        String rst = resourceString;
        ResourceReference[] references = this.getResourceReferences();
        if (references == null || references.length == 0) {
            return rst;
        }
        rst = ElServiceUtil.replace(resourceString, references);
        return rst;
    }

    protected String replaceCustomAttributes(String value) {
        String result = value;
        int nPrefLen = ElServiceUtil.getPrefLen();
        for (String el : this.pageContext.getKeysCustomElementsAttributes()) {
            if (el.length() + nPrefLen > result.length()) continue;
            String dollarEl = ElServiceUtil.envelopeInDollarEl(el);
            String sharpEl = ElServiceUtil.envelopeInSharpEl(el);
            if (result.contains(dollarEl)) {
                result = result.replace(dollarEl, this.pageContext.getAttributefromCustomElementsMapValue(el));
            }
            if (!result.contains(sharpEl)) continue;
            result = result.replace(sharpEl, this.pageContext.getAttributefromCustomElementsMapValue(el));
        }
        return result;
    }

    public boolean isELNode(Node sourceNode) {
        boolean rst = false;
        if (this.isInCustomElementsAttributes(sourceNode)) {
            rst = true;
        } else if (this.isAvailableForNode(sourceNode) || BundleMapUtil.isInResourcesBundle((BundleMap)this.pageContext.getBundle(), (Node)sourceNode)) {
            rst = true;
        } else if (Jsf2ResourceUtil.isContainJSFContextPath(sourceNode)) {
            rst = true;
        } else if (Jsf2ResourceUtil.isContainJSF2ResourceAttributes(sourceNode)) {
            rst = true;
        }
        return rst;
    }

    protected boolean isInCustomElementsAttributes(Node sourceNode) {
        boolean res = false;
        String textValue = null;
        if (sourceNode.getNodeType() == 3) {
            textValue = sourceNode.getNodeValue();
            res = this.isInCustomElementsAttributes(textValue);
        } else if (sourceNode.getNodeType() == 1) {
            NamedNodeMap attributesMap = sourceNode.getAttributes();
            int i = 0;
            while (!res && i < attributesMap.getLength()) {
                Attr attr = (Attr)attributesMap.item(i);
                textValue = attr.getValue();
                res = this.isInCustomElementsAttributes(textValue);
                ++i;
            }
        }
        return res;
    }

    protected boolean isInCustomElementsAttributes(String textValue) {
        boolean res = false;
        if (textValue != null) {
            for (String key : this.pageContext.getKeysCustomElementsAttributes()) {
                if (!ElServiceUtil.equalsExppression(textValue, key)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    protected boolean isAvailableForNode(Node sourceNode) {
        boolean rst = this.findForNode(sourceNode);
        return rst;
    }

    protected boolean findForNode(Node sourceNode) {
        ResourceReference[] references = this.getResourceReferences();
        if (references == null || references.length == 0) {
            return false;
        }
        String textValue = null;
        if (sourceNode.getNodeType() == 3 && (textValue = sourceNode.getNodeValue()) != null && ElServiceUtil.isInReferenceResourcesList(references, textValue)) {
            return true;
        }
        NamedNodeMap nodeMap = sourceNode.getAttributes();
        if (nodeMap != null) {
            int i = 0;
            while (i < nodeMap.getLength()) {
                if (ElServiceUtil.isInReferenceResourcesList(references, ((Attr)nodeMap.item(i)).getValue())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public ResourceReference[] getResourceReferences() {
        ResourceReference[] res = (ResourceReference[])this.pageContext.getValue("resourceReferences");
        return res;
    }

    public String replaceElAndResources(String value) {
        String rst = value;
        rst = ResourceUtil.getBundleValue(this.pageContext, rst);
        rst = this.replaceEl(rst);
        if (Jsf2ResourceUtil.isExternalContextPathString(rst = this.replaceCustomAttributes(rst))) {
            rst = Jsf2ResourceUtil.processExternalContextPath(rst);
        }
        if (Jsf2ResourceUtil.isRequestContextPathString(rst)) {
            rst = Jsf2ResourceUtil.processRequestContextPath(rst);
        }
        if (Jsf2ResourceUtil.isJSF2ResourceString(rst)) {
            rst = Jsf2ResourceUtil.processCustomJSFAttributes(this.pageContext, rst);
        }
        return rst;
    }

    public void createScope() {
    }

    public void resolveScope() {
    }
}

