/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.preferences;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.resref.core.VpeResourcesDialog;

public class VpeResourcesDialogFactory {
    public static void openVpeResourcesDialog(IEditorInput input) {
        ILocationProvider provider;
        IPath path;
        IPath absoluteDefaultPath = null;
        IFile fileLocation = null;
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            IFolder absoluteDefaultFolder = FileUtil.getDefaultWebRootFolder(file);
            if (absoluteDefaultFolder != null) {
                absoluteDefaultPath = absoluteDefaultFolder.getLocation();
            }
            fileLocation = file;
        } else if (input instanceof ILocationProvider && (path = (provider = (ILocationProvider)input).getPath((Object)input)) != null) {
            fileLocation = path;
        }
        IPath relativeDafaultPath = VpeStyleUtil.getInputParentPath(input);
        if (fileLocation != null) {
            VpeResourcesDialog dialogNew = new VpeResourcesDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (Object)fileLocation, new ResourceReference(absoluteDefaultPath != null ? absoluteDefaultPath.toOSString() : "", 2), new ResourceReference(relativeDafaultPath != null ? relativeDafaultPath.toOSString() : "", 1));
            dialogNew.open();
        } else {
            VpePlugin.getDefault().logError(VpeUIMessages.COULD_NOT_OPEN_VPE_RESOURCES_DIALOG);
        }
    }
}

