/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.jboss.tools.jst.jsp.editor.ITextFormatter;
import org.jboss.tools.jst.jsp.selection.SelectedNodeInfo;
import org.jboss.tools.jst.jsp.selection.SourceSelection;
import org.jboss.tools.jst.jsp.selection.SourceSelectionBuilder;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.util.FlatIterator;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.jboss.tools.vpe.xulrunner.util.XulRunnerVpeUtils;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class VpeVisualKeyHandler {
    public static final int VK_ENTER = 13;
    public static final int VK_LEFT = 37;
    public static final int VK_UP = 38;
    public static final int VK_RIGHT = 39;
    public static final int VK_DOWN = 40;
    public static final int VK_BACK_SPACE = 8;
    public static final int VK_DELETE = 46;
    public static final int VK_INSERT = 45;
    public static final int VK_F4 = 115;
    public static final int VK_PAGE_UP = 33;
    public static final int VK_HOME = 36;
    public static final int VK_END = 35;
    StructuredTextEditor sourceEditor;
    VpeDomMapping domMapping;
    VpePageContext pageContext;

    VpeVisualKeyHandler(StructuredTextEditor sourceEditor, VpeDomMapping domMapping, VpePageContext pageContext) {
        this.sourceEditor = sourceEditor;
        this.domMapping = domMapping;
        this.pageContext = pageContext;
    }

    boolean keyPressHandler(nsIDOMKeyEvent keyEvent) {
        boolean handled = false;
        handled = keyEvent.getCtrlKey() || keyEvent.getMetaKey() ? this.ctrlKeyPressHandler(keyEvent) : this.nonctrlKeyPressHandler(keyEvent);
        if (VpeDebug.PRINT_VISUAL_KEY_EVENT) {
            System.out.println("    handled: " + handled);
        }
        if (handled) {
            keyEvent.stopPropagation();
            keyEvent.preventDefault();
        }
        return handled;
    }

    private boolean ctrlKeyPressHandler(nsIDOMKeyEvent keyEvent) {
        block0 : switch ((int)keyEvent.getCharCode()) {
            case 0: {
                switch ((int)keyEvent.getKeyCode()) {
                    case 115: {
                        IWorkbenchPage workbenchPage = VpePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        if (keyEvent.getShiftKey()) {
                            workbenchPage.closeAllEditors(true);
                            break block0;
                        }
                        workbenchPage.closeEditor((IEditorPart)this.pageContext.getEditPart().getParentEditor(), true);
                        break block0;
                    }
                    case 36: {
                        if (!keyEvent.getShiftKey()) break block0;
                        return this.selectToBegin();
                    }
                    case 35: {
                        if (!keyEvent.getShiftKey()) break block0;
                        return this.selectToEnd();
                    }
                }
                break;
            }
            case 90: 
            case 122: {
                this.sourceEditor.getAction(ActionFactory.UNDO.getId()).run();
                return true;
            }
            case 89: 
            case 121: {
                this.sourceEditor.getAction(ActionFactory.REDO.getId()).run();
                return true;
            }
            case 83: 
            case 115: {
                this.doSave((IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            case 88: 
            case 120: {
                this.sourceEditor.getAction(ActionFactory.CUT.getId()).run();
                return true;
            }
            case 67: 
            case 99: {
                this.sourceEditor.getAction(ActionFactory.COPY.getId()).run();
                return true;
            }
            case 86: 
            case 118: {
                this.sourceEditor.getAction(ActionFactory.PASTE.getId()).run();
                return true;
            }
        }
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        this.sourceEditor.doSave(monitor);
    }

    private boolean nonctrlKeyPressHandler(nsIDOMKeyEvent keyEvent) {
        long keyCode = keyEvent.getKeyCode();
        boolean shiftKey = keyEvent.getShiftKey();
        if (keyCode == 13L) {
            return this.split();
        }
        if (keyCode == 37L && !shiftKey) {
            return this.moveLeft();
        }
        if (keyCode == 38L && !shiftKey) {
            return this.moveUp();
        }
        if (keyCode == 39L && !shiftKey) {
            return this.moveRight();
        }
        if (keyCode == 40L && !shiftKey) {
            return this.moveDown();
        }
        if (keyCode == 36L && !shiftKey) {
            return this.moveHome(false);
        }
        if (keyCode == 35L && !shiftKey) {
            return this.moveEnd(false);
        }
        if (keyCode == 8L && !shiftKey) {
            return this.deleteLeft();
        }
        if (keyCode == 46L && !shiftKey) {
            return this.deleteRight();
        }
        if (keyCode == 33L && shiftKey) {
            return false;
        }
        if (keyEvent.getCharCode() != 0L) {
            return this.handleKey(keyEvent);
        }
        if (shiftKey && keyEvent.getKeyCode() == 45L) {
            return this.paste();
        }
        return false;
    }

    private boolean selectToBegin() {
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.sourceEditor);
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null) {
            Node focusNode = selection.getFocusNode();
            int focusOffset = selection.getFocusOffset();
            if (focusNode != null) {
                int so = ((IndexedRegion)focusNode).getStartOffset() + focusOffset;
                this.setSelectionRange(so, 0);
                return true;
            }
        }
        return false;
    }

    private boolean selectToEnd() {
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.sourceEditor);
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null) {
            Node focusNode = selection.getFocusNode();
            int focusOffset = selection.getFocusOffset();
            if (focusNode != null) {
                int so = ((IndexedRegion)focusNode).getStartOffset() + focusOffset;
                int eo = ((IndexedRegion)focusNode.getOwnerDocument()).getEndOffset();
                this.setSelectionRange(so, eo);
                return true;
            }
        }
        return false;
    }

    private boolean paste() {
        this.sourceEditor.getAction(ActionFactory.PASTE.getId()).run();
        return true;
    }

    private boolean deleteRight() {
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.sourceEditor);
        if (this.processNonCollapsedSelection(sourceSelectionBuilder, 46L)) {
            return true;
        }
        if (this.processAttributeSelection(sourceSelectionBuilder, 46L)) {
            return true;
        }
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null) {
            if (!selection.isCollapsed()) {
                return false;
            }
            Node focusNode = selection.getFocusNode();
            if (VpeDebug.PRINT_VISUAL_KEY_EVENT) {
                System.out.println(">>>   1. VpeVisualKeyHandler.deleteRight(): focusNode = " + focusNode + "   |   focusOffset = " + selection.getFocusOffset());
            }
            if (focusNode != null) {
                if (focusNode.getNodeType() == 3 && selection.getFocusOffset() < ((TextImpl)selection.getFocusNode()).getValueSource().length()) {
                    this.deleteRightChar(sourceSelectionBuilder, selection);
                    return true;
                }
                if (focusNode.getNodeType() == 1 && selection.getFocusOffset() != 2) {
                    return this.deleteRightCharOrElement(sourceSelectionBuilder, selection, focusNode);
                }
                if (focusNode.getNodeType() == 1 && selection.getFocusOffset() == 2) {
                    if (this.isEmptyElement(focusNode)) {
                        return this.deleteRightCharOrElement(sourceSelectionBuilder, selection, focusNode);
                    }
                    Node deepestChild = FlatIterator.findDeepestLastChild(focusNode);
                    Node next = this.getNextFlatNode(deepestChild == null ? focusNode : deepestChild);
                    if (next != null) {
                        focusNode = next;
                        return this.deleteRightCharOrElement(sourceSelectionBuilder, selection, focusNode);
                    }
                }
            }
        }
        return false;
    }

    private boolean deleteRightCharOrElement(SourceSelectionBuilder sourceSelectionBuilder, SourceSelection selection, Node node) {
        if (node.getNodeType() == 1) {
            AttrImpl attr;
            Node atRight;
            if (!this.hasNoEmptyChildren(node)) {
                AttrImpl attr2 = (AttrImpl)this.getVisualNodeSourceAttribute(node);
                if (attr2 == null || !this.isVisualEditableForNode(node)) {
                    if (this.isRemovable(node)) {
                        int offset = ((IndexedRegion)node).getStartOffset();
                        this.removeNode(node);
                        this.setSourceFocus(offset);
                        return true;
                    }
                    return false;
                }
                if (attr2 != null && this.isVisualEditableForNode(node)) {
                    if (this.isWhitespaceNode((Node)attr2)) {
                        if (this.isRemovable(node)) {
                            int offset = ((IndexedRegion)node).getStartOffset();
                            this.removeNode(node);
                            this.setSourceFocus(offset);
                            return true;
                        }
                        return false;
                    }
                    int offset = ((IndexedRegion)node).getStartOffset() + attr2.getValueRegion().getStart() + 1;
                    this.setSourceFocus(offset);
                    return this.deleteRight();
                }
            }
            if ((atRight = this.getNextFlatNode(node)) != null && (attr = (AttrImpl)this.getVisualNodeSourceAttribute(atRight)) != null && this.isVisualEditableForNode(atRight)) {
                int offset = ((IndexedRegion)atRight).getStartOffset() + attr.getValueRegion().getStart() + 1;
                this.setSourceFocus(offset);
                return this.deleteRight();
            }
            if (atRight != null) {
                this.selectNode(atRight, false);
                return this.deleteRightCharOrElement(sourceSelectionBuilder, sourceSelectionBuilder.getSelection(), atRight);
            }
            return false;
        }
        int startOffset = ((IndexedRegion)node).getStartOffset();
        this.setSourceFocus(startOffset);
        this.deleteRightChar(sourceSelectionBuilder, sourceSelectionBuilder.getSelection());
        return true;
    }

    private SourceSelection deleteRightChar(SourceSelectionBuilder sourceSelectionBuilder, SourceSelection selection) {
        boolean atLeastOneCharIsDeleted = false;
        Node focusNode = null;
        while (selection != null && (focusNode = selection.getFocusNode()) != null) {
            int offset;
            if (focusNode == null || focusNode.getNodeType() != 3) break;
            if (this.isWhitespaceNode(focusNode)) {
                offset = ((IndexedRegion)focusNode).getStartOffset();
                Node atRight = this.getNextFlatNode(focusNode);
                if (this.isRemovable(focusNode)) {
                    this.removeNode(focusNode);
                    this.setSourceFocus(offset);
                    if (atRight == null) break;
                    selection = sourceSelectionBuilder.getSelection();
                    continue;
                }
            }
            offset = focusNode == selection.getFocusNode() ? selection.getFocusOffset() : ((TextImpl)focusNode).getValueSource().length();
            int length = ((TextImpl)selection.getFocusNode()).getValueSource().length();
            if (length <= offset) break;
            if (!atLeastOneCharIsDeleted) {
                if (focusNode.getNodeType() == 3) {
                    IndexedRegion region = (IndexedRegion)focusNode;
                    try {
                        String sourceText = this.sourceEditor.getTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset() - region.getStartOffset());
                        String escString = TextUtil.isEcsToRight(sourceText, offset);
                        if (escString != null) {
                            Point range = this.sourceEditor.getTextViewer().getSelectedRange();
                            this.sourceEditor.getTextViewer().getTextWidget().replaceTextRange(range.x, escString.length(), "");
                            atLeastOneCharIsDeleted = true;
                            continue;
                        }
                    }
                    catch (BadLocationException e) {
                        VpePlugin.getPluginLog().logError((Throwable)e);
                    }
                }
                if (!TextUtil.isWhitespace(((TextImpl)focusNode).getValueSource().toCharArray()[offset])) {
                    this.sourceEditor.getAction("org.eclipse.ui.edit.text.deleteNext").run();
                    selection = sourceSelectionBuilder.getSelection();
                    atLeastOneCharIsDeleted = true;
                    continue;
                }
            }
            if (!TextUtil.isWhitespace(((TextImpl)focusNode).getValueSource().toCharArray()[offset]) || atLeastOneCharIsDeleted) break;
            int endPos = 0;
            char[] chars = ((TextImpl)focusNode).getValueSource().toCharArray();
            while (chars.length > offset + endPos && TextUtil.isWhitespace(chars[offset + endPos])) {
                ++endPos;
            }
            Point range = this.sourceEditor.getTextViewer().getSelectedRange();
            this.sourceEditor.getTextViewer().getTextWidget().replaceTextRange(range.x, endPos, "");
            selection = sourceSelectionBuilder.getSelection();
            atLeastOneCharIsDeleted = true;
            break;
        }
        return selection;
    }

    private boolean processNonCollapsedSelection(SourceSelectionBuilder sourceSelectionBuilder, long keyCode) {
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null) {
            List selectedNodes = selection.getSelectedNodes();
            int focusOffset = -1;
            if (!selection.isCollapsed()) {
                int i = 0;
                while (i < selectedNodes.size()) {
                    SelectedNodeInfo nodeInfo = (SelectedNodeInfo)selectedNodes.get(i);
                    focusOffset = this.processNode(nodeInfo, keyCode, selection);
                    ++i;
                }
                Node commonAncestor = selection.getCommonAncestor();
                if (commonAncestor != null) {
                    selection.getCommonAncestor().normalize();
                }
                if (focusOffset > 0) {
                    this.setSourceFocus(focusOffset);
                }
                return true;
            }
        }
        return false;
    }

    private boolean processAttributeSelection(SourceSelectionBuilder sourceSelectionBuilder, long keyCode) {
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null && selection.getFocusAttribute() != null) {
            AttrImpl attr = (AttrImpl)selection.getFocusAttribute();
            Point range = selection.getFocusAttributeRange();
            if (range == null) {
                return false;
            }
            if (range.y > 0) {
                String value = attr.getValue();
                int attrSelStart = ((ElementImpl)attr.getOwnerElement()).getStartOffset() + attr.getValueRegion().getStart() + 1 + range.x;
                int so = range.x;
                int eo = range.x + range.y;
                value = String.valueOf(value.substring(0, so)) + value.substring(eo);
                attr.setNodeValue(value);
                this.setSourceFocus(attrSelStart);
                return true;
            }
            int attrSelStart = ((ElementImpl)attr.getOwnerElement()).getStartOffset() + attr.getValueRegion().getStart() + 1 + range.x;
            switch ((int)keyCode) {
                case 46: {
                    String value = attr.getValue();
                    int so = range.x;
                    int eo = range.x + 1;
                    if (!this.isVisualEditableForNode(attr.getOwnerElement()) || so < 0) {
                        int offset = ((IndexedRegion)attr.getOwnerElement()).getStartOffset();
                        this.setSourceFocus(offset);
                        return false;
                    }
                    if (eo > value.length()) {
                        int offset = ((IndexedRegion)attr.getOwnerElement()).getEndOffset();
                        this.setSourceFocus(offset);
                        return false;
                    }
                    value = String.valueOf(value.substring(0, so)) + value.substring(eo);
                    attr.setNodeValue(value);
                    this.setSourceFocus(attrSelStart);
                    return true;
                }
                case 8: {
                    String value = attr.getValue();
                    int so = range.x - 1;
                    int eo = range.x;
                    if (!this.isVisualEditableForNode(attr.getOwnerElement()) || so < 0 || eo > value.length()) {
                        int offset = ((IndexedRegion)attr.getOwnerElement()).getStartOffset();
                        this.setSourceFocus(offset);
                        return false;
                    }
                    value = String.valueOf(value.substring(0, so)) + value.substring(eo);
                    attr.setNodeValue(value);
                    this.setSourceFocus(attrSelStart - 1);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean deleteLeft() {
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.sourceEditor);
        if (this.processNonCollapsedSelection(sourceSelectionBuilder, 8L)) {
            return true;
        }
        if (this.processAttributeSelection(sourceSelectionBuilder, 8L)) {
            return true;
        }
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null) {
            if (!selection.isCollapsed()) {
                return false;
            }
            Node focusNode = selection.getFocusNode();
            if (VpeDebug.PRINT_VISUAL_KEY_EVENT) {
                System.out.println(">>>   1. VpeVisualKeyHandler.deleteLeft(): focusNode = " + focusNode + "   |   focusOffset = " + selection.getFocusOffset());
            }
            if (focusNode != null) {
                if (focusNode.getNodeType() == 3 && selection.getFocusOffset() >= 0) {
                    this.deleteLeftChar(sourceSelectionBuilder, selection);
                    return true;
                }
                if (focusNode.getNodeType() == 3 && selection.getFocusOffset() == 0) {
                    if ((focusNode = this.getPreviousFlatNode(focusNode)) == null) {
                        return false;
                    }
                    return this.deleteLeftCharOrElement(sourceSelectionBuilder, selection, focusNode);
                }
                if (focusNode.getNodeType() == 1 && selection.getFocusOffset() == 0) {
                    Node prev = this.getPreviousFlatNode(focusNode);
                    if (prev != null) {
                        return this.deleteLeftCharOrElement(sourceSelectionBuilder, selection, prev);
                    }
                    return true;
                }
                if (focusNode.getNodeType() == 1 && selection.getFocusOffset() == 2) {
                    Node deepestChild = FlatIterator.findDeepestLastChild(focusNode);
                    if (deepestChild != null) {
                        focusNode = deepestChild;
                    }
                    return this.deleteLeftCharOrElement(sourceSelectionBuilder, selection, focusNode);
                }
                if (focusNode.getNodeType() == 1 && selection.getFocusOffset() == 1) {
                    Node deepestChild = FlatIterator.findDeepestLastChild(focusNode);
                    if (deepestChild != null) {
                        focusNode = deepestChild;
                    }
                    return this.deleteLeftCharOrElement(sourceSelectionBuilder, selection, focusNode);
                }
            }
        }
        return false;
    }

    private boolean deleteLeftCharOrElement(SourceSelectionBuilder sourceSelectionBuilder, SourceSelection selection, Node node) {
        if (node.getNodeType() == 1) {
            if (!this.hasNoEmptyChildren(node)) {
                AttrImpl attr = (AttrImpl)this.getVisualNodeSourceAttribute(node);
                if (attr == null || !this.isVisualEditableForNode(node)) {
                    Node atLeft = this.getPreviousFlatNode(node);
                    if (this.isRemovable(node)) {
                        boolean isParent = atLeft == node.getParentNode();
                        Node prev = node.getPreviousSibling();
                        Node next = node.getNextSibling();
                        this.removeNode(node);
                        if (prev != null && next != null && prev.getNodeType() == 3 && next.getNodeType() == 3) {
                            int len = ((Text)prev).getData().length();
                            ((Text)prev).appendData(((Text)next).getData());
                            next.getParentNode().removeChild(next);
                            this.setSourceFocus(((IndexedRegion)prev).getStartOffset() + len);
                        } else {
                            this.selectNode(atLeft, !isParent);
                        }
                        return true;
                    }
                    return false;
                }
                if (attr != null && this.isVisualEditableForNode(node)) {
                    if (this.isWhitespaceNode((Node)attr)) {
                        Node atLeft = this.getPreviousFlatNode(node);
                        if (this.isRemovable(node)) {
                            boolean isParent = atLeft == node.getParentNode();
                            this.removeNode(node);
                            this.selectNode(atLeft, !isParent);
                            return true;
                        }
                        return false;
                    }
                    int offset = ((IndexedRegion)node).getStartOffset() + attr.getValueRegion().getStart() + attr.getValue().length() + 1;
                    this.setSourceFocus(offset);
                    return this.deleteLeft();
                }
            }
            Node atLeft = this.getPreviousFlatNode(node);
            while (atLeft != null) {
                AttrImpl attr = (AttrImpl)this.getVisualNodeSourceAttribute(atLeft);
                if (attr == null) break;
                if (this.isVisualEditableForNode(atLeft)) {
                    int offset = ((IndexedRegion)atLeft).getStartOffset() + attr.getValueRegion().getStart() + attr.getValue().length() + 1;
                    this.setSourceFocus(offset);
                    return this.deleteLeft();
                }
                atLeft = this.getPreviousFlatNode(atLeft);
            }
            if (atLeft != null) {
                this.selectNode(atLeft, true);
                return this.deleteLeftCharOrElement(sourceSelectionBuilder, sourceSelectionBuilder.getSelection(), atLeft);
            }
            return false;
        }
        int endOffset = ((IndexedRegion)node).getEndOffset();
        this.setSourceFocus(endOffset);
        this.deleteLeftChar(sourceSelectionBuilder, sourceSelectionBuilder.getSelection());
        return true;
    }

    private void selectNode(Node node, boolean atEnd) {
        if (node != null) {
            int offset = ((IndexedRegion)node).getStartOffset();
            if (atEnd) {
                if (node.getNodeType() == 3) {
                    offset = ((IndexedRegion)node).getEndOffset();
                } else if (node.getNodeType() == 1) {
                    offset = ((ElementImpl)node).getEndStartOffset();
                }
            }
            this.setSourceFocus(offset);
        }
    }

    private boolean isRemovable(Node node) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node getNodeAtLeft(Node focusNode, int offset) {
        if (focusNode == null) return null;
        int focusNodeOffset = -1;
        if (focusNode.getNodeType() == 3) {
            if (!this.isWhitespaceNode(focusNode, offset)) return focusNode;
            focusNodeOffset = ((IndexedRegion)focusNode).getStartOffset();
        } else if (focusNode.getNodeType() == 1 && offset == 1) {
            focusNodeOffset = ((IndexedRegion)focusNode).getStartOffset();
        } else if (focusNode.getNodeType() == 1 && offset == 2) {
            focusNodeOffset = ((ElementImpl)focusNode).getEndStartOffset();
        }
        if (focusNodeOffset <= 0) return null;
        return SourceSelectionBuilder.getSourceNodeAt((StructuredTextEditor)this.sourceEditor, (int)(--focusNodeOffset));
    }

    private SourceSelection deleteLeftChar(SourceSelectionBuilder sourceSelectionBuilder, SourceSelection selection) {
        boolean atLeastOneCharIsDeleted = false;
        Node focusNode = null;
        while (selection != null && (focusNode = selection.getFocusNode()) != null) {
            char[] charArray;
            String valueSource;
            int offset;
            if (focusNode.getNodeType() == 1 && selection.getFocusOffset() == 2) {
                focusNode = FlatIterator.findDeepestLastChild(focusNode);
            }
            if (focusNode != null && focusNode.getNodeType() == 1 && selection.getFocusOffset() != 2) {
                focusNode = this.getPreviousFlatNode(focusNode);
            }
            if (focusNode == null || focusNode.getNodeType() != 3) break;
            if (this.isWhitespaceNode(focusNode)) {
                Node atLeft = this.getPreviousFlatNode(focusNode);
                if (this.isRemovable(focusNode)) {
                    ((IndexedRegion)focusNode).getStartOffset();
                    this.removeNode(focusNode);
                    this.selectNode(atLeft, true);
                    selection = sourceSelectionBuilder.getSelection();
                    continue;
                }
            }
            int n = offset = focusNode == selection.getFocusNode() ? selection.getFocusOffset() : ((TextImpl)focusNode).getValueSource().length();
            if (offset == 0) break;
            if (!atLeastOneCharIsDeleted) {
                if (focusNode.getNodeType() == 3) {
                    IndexedRegion region = (IndexedRegion)focusNode;
                    try {
                        String sourceText = this.sourceEditor.getTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset() - region.getStartOffset());
                        String escString = TextUtil.isEcsToLeft(sourceText, offset);
                        if (escString != null) {
                            Point range = this.sourceEditor.getTextViewer().getSelectedRange();
                            this.sourceEditor.getTextViewer().getTextWidget().replaceTextRange(range.x - escString.length(), escString.length(), "");
                            atLeastOneCharIsDeleted = true;
                            return selection;
                        }
                    }
                    catch (BadLocationException ex) {
                        VpePlugin.getPluginLog().logError((Throwable)ex);
                    }
                }
                if (!atLeastOneCharIsDeleted) {
                    int endPos = 1;
                    while (TextUtil.isWhitespace(((TextImpl)focusNode).getValueSource().toCharArray()[offset - endPos])) {
                        ++endPos;
                    }
                    if (--endPos != 0) {
                        Point range = this.sourceEditor.getTextViewer().getSelectedRange();
                        this.sourceEditor.getTextViewer().getTextWidget().replaceTextRange(range.x - endPos, endPos, "");
                        selection = sourceSelectionBuilder.getSelection();
                        atLeastOneCharIsDeleted = true;
                    }
                }
                if (!atLeastOneCharIsDeleted) {
                    this.sourceEditor.getAction("org.eclipse.ui.edit.text.deletePrevious").run();
                    selection = sourceSelectionBuilder.getSelection();
                    atLeastOneCharIsDeleted = true;
                    continue;
                }
            }
            if ((valueSource = ((TextImpl)focusNode).getValueSource()) == null || offset > (charArray = valueSource.toCharArray()).length || !TextUtil.isWhitespace(valueSource.toCharArray()[offset - 1]) || atLeastOneCharIsDeleted) break;
            this.sourceEditor.getAction("org.eclipse.ui.edit.text.deletePrevious").run();
            selection = sourceSelectionBuilder.getSelection();
        }
        return selection;
    }

    private Node getPreviousFlatNode(Node node) {
        Node prev = FlatIterator.previous(node);
        while (prev != null) {
            if (prev.getNodeType() == 3 || this.getVisualNode(prev) != null) {
                return prev;
            }
            prev = FlatIterator.previous(prev);
        }
        return null;
    }

    private Node getNextFlatNode(Node node) {
        Node next = FlatIterator.next(node);
        while (next != null) {
            if (this.getVisualNode(next) != null || next.getNodeType() == 3) {
                return next;
            }
            next = FlatIterator.next(next);
        }
        return null;
    }

    private void selectPreviousNode(Node focusNode) {
        Node prevNode = this.getPreviousTextNode(focusNode);
        if (prevNode != null) {
            int endOffset = ((IndexedRegion)prevNode).getEndOffset();
            this.setSourceFocus(endOffset);
        }
    }

    private Node getPreviousTextNode(Node focusNode) {
        Node next = this.getPreviousEditableNode(focusNode);
        while (next != null) {
            if (next.getNodeType() == 3 && !this.isWhitespaceNode(next)) {
                return next;
            }
            next = this.getPreviousEditableNode(next);
        }
        return null;
    }

    private Node getPreviousEditableNode(Node currentNode) {
        if (currentNode != null) {
            Node prev = currentNode.getPreviousSibling();
            if (prev != null) {
                return this.getLastSourceChild(prev);
            }
            return currentNode.getParentNode();
        }
        return null;
    }

    private Node getLastSourceChild(Node node) {
        if (node != null) {
            Node lastChild = node.getLastChild();
            if (lastChild == null) {
                return node;
            }
            Node lastChildOld = lastChild;
            while (lastChild != null) {
                if ((lastChild = lastChild.getLastChild()) == null) continue;
                lastChildOld = lastChild;
            }
            return lastChildOld;
        }
        return null;
    }

    private boolean hasNoEmptyChildren(Node node) {
        if (node.getNodeType() == 1) {
            if (node.hasChildNodes()) {
                Node child = node.getFirstChild();
                while (child != null) {
                    if (!this.isEmptyElement(child)) {
                        return true;
                    }
                    child = child.getNextSibling();
                }
            }
            return false;
        }
        return false;
    }

    private boolean isEmptyElement(Node node) {
        if (node.getNodeType() == 3) {
            return this.isWhitespaceNode(node, ((TextImpl)node).getValueSource().length());
        }
        if (node.getNodeType() == 1) {
            if (node.hasChildNodes()) {
                Node child = node.getFirstChild();
                while (child != null) {
                    if (!this.isEmptyElement(child)) {
                        return false;
                    }
                    child = child.getNextSibling();
                }
            }
            return this.getVisualNodeSourceAttribute(node) == null || this.isVisualNodeEmpty(node) || !this.isVisualNodeEmpty(node) && !this.isVisualEditableForNode(node);
        }
        return false;
    }

    private boolean isEmptyVisualElement(Node node) {
        if (node.getNodeType() == 3) {
            return this.isWhitespaceNode(node, ((TextImpl)node).getValueSource().length());
        }
        if (node.getNodeType() == 1) {
            if (node.hasChildNodes()) {
                Node child = node.getFirstChild();
                while (child != null) {
                    if (!this.isEmptyElement(child)) {
                        return false;
                    }
                    child = child.getNextSibling();
                }
            }
            return true;
        }
        return false;
    }

    private boolean isVisualEditableForNode(Node node) {
        String style;
        nsIDOMNode styleAttr;
        nsIDOMNode visualNode = this.domMapping.getVisualNode(node);
        return visualNode.getNodeType() == 1 ? (styleAttr = visualNode.getAttributes().getNamedItem("style")) != null && (style = styleAttr.getNodeValue()) != null && style.indexOf("read-only") < 0 : visualNode.getNodeType() == 3;
    }

    private boolean isVisualNodeSourceAttribute(Node node) {
        nsIDOMNode visualNode = this.domMapping.getVisualNode(node);
        VpeNodeMapping nm = this.domMapping.getNodeMapping(visualNode);
        if (nm instanceof VpeElementMapping) {
            VpeElementMapping em = (VpeElementMapping)nm;
            return em.getTemplate().isOutputAttributes();
        }
        return false;
    }

    private boolean isVisualNodeEmpty(Node node) {
        nsIDOMNode visualNode = this.domMapping.getVisualNode(node);
        return this.pageContext.getVisualBuilder().isEmptyElement(visualNode);
    }

    private Attr getVisualNodeSourceAttribute(Node node) {
        VpeElementMapping mapping;
        String[] names;
        nsIDOMNode visualNode = this.domMapping.getVisualNode(node);
        if (visualNode == null) {
            return null;
        }
        VpeNodeMapping nm = this.domMapping.getNodeMapping(visualNode);
        if (nm instanceof VpeElementMapping && (names = (mapping = (VpeElementMapping)nm).getTemplate().getOutputAttributeNames()).length > 0) {
            String name = names[0];
            return (Attr)node.getAttributes().getNamedItem(name);
        }
        return null;
    }

    private nsIDOMNode getVisualNode(Node node) {
        nsIDOMNode visualNode;
        if (this.domMapping != null && (visualNode = this.domMapping.getVisualNode(node)) != null && (visualNode.getNodeType() == 1 || visualNode.getNodeType() == 3)) {
            return visualNode;
        }
        return null;
    }

    private boolean isWhitespaceNode(Node node) {
        if (node.getNodeType() == 3) {
            return this.isWhitespaceNode(node, ((TextImpl)node).getValueSource().length());
        }
        if (node.getNodeType() == 2) {
            return this.isWhitespaceNode(node, ((AttrImpl)node).getValue().length());
        }
        return false;
    }

    private boolean isWhitespaceNode(Node node, int offset) {
        if (node.getNodeType() == 3 || node.getNodeType() == 2) {
            char[] value = node.getNodeType() == 3 ? ((TextImpl)node).getValueSource().toCharArray() : ((AttrImpl)node).getValue().toCharArray();
            int i = 0;
            while (i < Math.min(value.length, offset)) {
                if (!TextUtil.isWhitespace(value[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void setSourceFocus(int offset) {
        this.pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(offset, 0);
        this.pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(offset, 0);
    }

    private void setSelectionRange(int startOffset, int endOffset) {
        this.pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(endOffset, startOffset - endOffset);
        this.pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(endOffset, startOffset - endOffset);
    }

    private void removeNode(Node focusNode) {
        if (focusNode != null && focusNode.getParentNode() != null) {
            focusNode.getParentNode().removeChild(focusNode);
        }
    }

    private boolean handleKey(nsIDOMKeyEvent keyEvent) {
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.sourceEditor);
        this.processNonCollapsedSelection(sourceSelectionBuilder, keyEvent.getCharCode());
        this.processAttributeSelection(sourceSelectionBuilder, keyEvent.getCharCode());
        boolean isEditable = false;
        int start = 0;
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null) {
            VpeDomMapping mapping;
            Node sourceNode = selection.getFocusNode();
            if (sourceNode != null && (mapping = this.pageContext.getDomMapping()) != null) {
                nsIDOMNode visualNode = mapping.getVisualNode(sourceNode);
                if (visualNode != null) {
                    if (visualNode.getNodeType() == 1) {
                        String style;
                        nsIDOMNode styleAttr = visualNode.getAttributes().getNamedItem("style");
                        if (styleAttr != null && (style = styleAttr.getNodeValue()) != null && style.indexOf("read-only") < 0) {
                            isEditable = true;
                        }
                    } else if (visualNode.getNodeType() == 3) {
                        isEditable = true;
                    }
                } else {
                    isEditable = true;
                }
                if (isEditable) {
                    start = this.sourceEditor.getTextViewer().getSelectedRange().x;
                }
            }
        } else if (this.pageContext.getSourceBuilder().isEmptyDocument()) {
            isEditable = true;
            start = 0;
        }
        if (isEditable) {
            long charCode = keyEvent.getCharCode();
            char[] s = new char[]{(char)charCode};
            String str = new String(s);
            if (TextUtil.containsKey(s[0])) {
                str = TextUtil.getValue(s[0]);
            }
            this.sourceEditor.getTextViewer().getTextWidget().replaceTextRange(start, 0, str);
            this.pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(start + str.length(), 0);
            this.pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(start + str.length(), 0);
            return true;
        }
        return false;
    }

    private boolean _nonctrlKeyPressHandler(nsIDOMKeyEvent keyEvent) {
        ITextFormatter formatter = null;
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.sourceEditor);
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null) {
            long keyCode = keyEvent.getKeyCode();
            List selectedNodes = selection.getSelectedNodes();
            switch ((int)keyCode) {
                case 13: {
                    Node focusNode;
                    VpeNodeMapping parentMapping;
                    if (!selection.isCollapsed()) {
                        int i = 0;
                        while (i < selectedNodes.size()) {
                            SelectedNodeInfo nodeInfo = (SelectedNodeInfo)selectedNodes.get(i);
                            this.processNode(nodeInfo, keyCode, selection);
                            ++i;
                        }
                        Node commonAncestor = selection.getCommonAncestor();
                        if (commonAncestor != null) {
                            selection.getCommonAncestor().normalize();
                        }
                    }
                    if ((parentMapping = this.domMapping.getNearParentMapping(focusNode = selection.getFocusNode())) != null) {
                        boolean handled = false;
                        while (!handled && parentMapping instanceof VpeElementMapping) {
                            VpeTemplate template = ((VpeElementMapping)parentMapping).getTemplate();
                            Node srcNode = parentMapping.getSourceNode();
                            nsIDOMNode visualNode = parentMapping.getVisualNode();
                            handled = template.nonctrlKeyPressHandler(this.pageContext, srcNode.getOwnerDocument(), srcNode, visualNode, null, keyCode, selection, formatter);
                            parentMapping = this.domMapping.getParentMapping(srcNode);
                        }
                        if (!handled && focusNode.getParentNode().getNodeType() == 9 && focusNode.getNodeType() == 3) {
                            Point range = this.sourceEditor.getTextViewer().getSelectedRange();
                            Element p1 = focusNode.getOwnerDocument().createElement("p");
                            Element p2 = focusNode.getOwnerDocument().createElement("p");
                            Text newNode = ((Text)focusNode).splitText(this.getSourceNodeOffset(focusNode, range.x));
                            focusNode.getParentNode().insertBefore(p1, focusNode);
                            focusNode.getParentNode().insertBefore(p2, newNode);
                            focusNode = focusNode.getParentNode().removeChild(focusNode);
                            newNode = (Text)newNode.getParentNode().removeChild(newNode);
                            p1.appendChild(focusNode);
                            p2.appendChild(newNode);
                            this.setCursor(this.pageContext, newNode);
                        }
                    } else if (focusNode instanceof Comment) {
                        String focusText = focusNode.getNodeValue().substring(0, selection.getFocusOffset());
                        String cloneText = focusNode.getNodeValue().substring(selection.getFocusOffset());
                        if (focusText.length() > 0 && cloneText.length() > 0) {
                            Node clone = focusNode.cloneNode(true);
                            clone.setNodeValue(cloneText);
                            clone = focusNode.getParentNode().insertBefore(clone, focusNode.getNextSibling());
                            focusNode.setNodeValue(focusText);
                        }
                    }
                    IAction formatAll = this.sourceEditor.getAction("FormatActiveElements");
                    formatAll.run();
                }
            }
        }
        return false;
    }

    private boolean split() {
        ITextFormatter formatter = null;
        Region region = null;
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.sourceEditor);
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null) {
            Node focusNode;
            VpeNodeMapping parentMapping;
            List selectedNodes = selection.getSelectedNodes();
            if (!selection.isCollapsed()) {
                int i = 0;
                while (i < selectedNodes.size()) {
                    SelectedNodeInfo nodeInfo = (SelectedNodeInfo)selectedNodes.get(i);
                    this.processNode(nodeInfo, 13L, selection);
                    ++i;
                }
                Node commonAncestor = selection.getCommonAncestor();
                if (commonAncestor != null) {
                    selection.getCommonAncestor().normalize();
                }
            }
            if ((parentMapping = this.domMapping.getNearParentMapping(focusNode = selection.getFocusNode())) != null) {
                boolean handled = false;
                while (!handled && parentMapping instanceof VpeElementMapping) {
                    VpeTemplate template = ((VpeElementMapping)parentMapping).getTemplate();
                    Node srcNode = parentMapping.getSourceNode();
                    nsIDOMNode visualNode = parentMapping.getVisualNode();
                    handled = template.nonctrlKeyPressHandler(this.pageContext, srcNode.getOwnerDocument(), srcNode, visualNode, null, 13L, selection, formatter);
                    parentMapping = this.domMapping.getParentMapping(srcNode);
                }
                if (!handled && focusNode.getNodeType() == 3) {
                    if (focusNode.getParentNode().getNodeType() == 9) {
                        Point range = this.sourceEditor.getTextViewer().getSelectedRange();
                        Element p1 = focusNode.getOwnerDocument().createElement("p");
                        Element p2 = focusNode.getOwnerDocument().createElement("p");
                        Text newNode = ((Text)focusNode).splitText(this.getSourceNodeOffset(focusNode, range.x));
                        focusNode.getParentNode().insertBefore(p1, focusNode);
                        focusNode.getParentNode().insertBefore(p2, newNode);
                        focusNode = focusNode.getParentNode().removeChild(focusNode);
                        newNode = (Text)newNode.getParentNode().removeChild(newNode);
                        p1.appendChild(focusNode);
                        p2.appendChild(newNode);
                        this.setCursor(this.pageContext, newNode);
                        int p1Start = ((IndexedRegion)p1).getStartOffset();
                        int p2End = ((IndexedRegion)p2).getEndOffset();
                        region = new Region(p1Start, p2End - p1Start);
                    } else {
                        int n1Start = ((IndexedRegion)focusNode).getStartOffset();
                        int focusOffset = selection.getFocusOffset();
                        if (focusOffset == 0) {
                            String text = ((Text)focusNode).getData();
                            String trimText = text.trim();
                            focusOffset = trimText.length() <= 0 ? text.length() : text.indexOf(text.trim());
                        }
                        Text newNode = ((Text)focusNode).splitText(focusOffset);
                        focusNode.getParentNode().insertBefore(focusNode.getOwnerDocument().createElement("br"), newNode);
                        Text newNode1 = (Text)focusNode.getParentNode().insertBefore(focusNode.getOwnerDocument().createTextNode("\r\n" + this.getLinePrefix(n1Start + focusOffset) + newNode.getData()), newNode);
                        focusNode.getParentNode().removeChild(newNode);
                        newNode = newNode1;
                        this.setCursor(this.pageContext, newNode);
                        int n2End = ((IndexedRegion)newNode).getEndOffset();
                        region = new Region(n1Start, n2End - n1Start);
                    }
                }
            } else if (focusNode instanceof Comment) {
                String focusText = focusNode.getNodeValue().substring(0, selection.getFocusOffset());
                String cloneText = focusNode.getNodeValue().substring(selection.getFocusOffset());
                if (focusText.length() > 0 && cloneText.length() > 0) {
                    Node clone = focusNode.cloneNode(true);
                    clone.setNodeValue(cloneText);
                    clone = focusNode.getParentNode().insertBefore(clone, focusNode.getNextSibling());
                    focusNode.setNodeValue(focusText);
                }
            }
            this.sourceEditor.getTextViewer();
            if (region != null && this.sourceEditor instanceof ITextFormatter) {
                ((ITextFormatter)this.sourceEditor).formatTextRegion(this.sourceEditor.getTextViewer().getDocument(), region);
            }
            return true;
        }
        return false;
    }

    private String getLinePrefix(int offset) {
        try {
            IDocument document = this.sourceEditor.getTextViewer().getDocument();
            int linePrefixBeginning = document.getLineInformationOfOffset(offset).getOffset();
            String linePrefix = document.get(linePrefixBeginning, offset - linePrefixBeginning);
            int linePrefixLength = 0;
            while (linePrefixLength < linePrefix.length()) {
                if (!Character.isWhitespace(linePrefix.charAt(linePrefixLength))) break;
                ++linePrefixLength;
            }
            return linePrefix.substring(0, linePrefixLength);
        }
        catch (BadLocationException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
            return "";
        }
    }

    private int processNode(SelectedNodeInfo nodeInfo, long keyCode, SourceSelection selection) {
        Node node = nodeInfo.getNode();
        if (this.domMapping.getNodeMapping(node) != null) {
            short type = node.getNodeType();
            if (type == 3 || type == 8) {
                int eo;
                int so = nodeInfo.getStartOffset();
                if (so > (eo = nodeInfo.getEndOffset())) {
                    int tmp = so;
                    so = eo;
                    eo = tmp;
                }
                int pos = ((IndexedRegion)node).getStartOffset() + so;
                try {
                    String source = ((TextImpl)node).getSource();
                    ((TextImpl)node).setSource(String.valueOf(source.substring(0, so)) + source.substring(eo));
                }
                catch (InvalidCharacterException e) {
                    VpePlugin.getPluginLog().logError((Throwable)e);
                }
                if (node.getNodeValue().trim().length() == 0) {
                    node.getParentNode().removeChild(node);
                }
                return pos;
            }
            int so = ((IndexedRegion)node).getStartOffset();
            node.getParentNode().removeChild(node);
            return so;
        }
        this.goToParentTemplate(node, selection, keyCode);
        return -1;
    }

    private Node getParent(Node node, String tagName) {
        Node p = node.getParentNode();
        while (p != null) {
            if (p.getNodeName().equalsIgnoreCase(tagName)) {
                return p;
            }
            p = p.getParentNode();
        }
        return null;
    }

    private void goToParentTemplate(Node node, SourceSelection selection, long keyCode) {
        VpeTemplate template;
        ITextFormatter formatter = null;
        VpeNodeMapping nearNodeMapping = this.domMapping.getNearParentMapping(node);
        if (nearNodeMapping instanceof VpeElementMapping && (template = ((VpeElementMapping)nearNodeMapping).getTemplate()) != null) {
            Node sourceNode = nearNodeMapping.getSourceNode();
            nsIDOMNode visualNode = nearNodeMapping.getVisualNode();
            template.nonctrlKeyPressHandler(null, sourceNode.getOwnerDocument(), sourceNode, visualNode, null, keyCode, selection, formatter);
        }
    }

    private int getSourceNodeOffset(Node node, int pos) {
        if (node == null) {
            return 0;
        }
        int start = ((IndexedRegion)node).getStartOffset();
        int end = ((IndexedRegion)node).getEndOffset();
        if (node.getNodeType() == 3) {
            if (pos > end) {
                return end - start;
            }
            return pos - start;
        }
        return 0;
    }

    private void setCursor(VpePageContext pageContext, Node node) {
        int nodeOffset = ((IndexedRegion)node).getStartOffset();
        if (node.getNodeType() == 1) {
            ElementImpl element = (ElementImpl)node;
            nodeOffset = element.getStartEndOffset();
        }
        pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(nodeOffset, 0);
        pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(nodeOffset, 0);
    }

    private boolean moveForward() {
        Node node;
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.sourceEditor);
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null && selection.isCollapsed() && (node = this.getNextNode(selection.getStartNode())) != null) {
            int nodeOffset = ((IndexedRegion)node).getStartOffset();
            this.pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(nodeOffset, 0);
            this.pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(nodeOffset, 0);
            return true;
        }
        return false;
    }

    private boolean moveRight() {
        nsIDOMElement visualELement = this.getNearestNodeinRightDirection(this.getSelectedNode());
        Node sourceNode = this.domMapping.getSourceNode((nsIDOMNode)visualELement);
        if (sourceNode != null) {
            this.setSourceFocus(((IndexedRegion)sourceNode).getStartOffset());
            return true;
        }
        return false;
    }

    private boolean moveLeft() {
        nsIDOMElement visualELement = this.getNearestNodeinLeftDirection(this.getSelectedNode());
        Node sourceNode = this.domMapping.getSourceNode((nsIDOMNode)visualELement);
        if (sourceNode != null) {
            this.setSourceFocus(((IndexedRegion)sourceNode).getStartOffset());
            return true;
        }
        return false;
    }

    private boolean isTextToSkip(char[] chars, int position) {
        if (chars[position] == ' ') {
            return true;
        }
        return TextUtil.isWhitespaceText(new String(chars, 0, position + 1)) || TextUtil.isWhitespaceText(new String(chars, position, chars.length - position));
    }

    boolean moveCursorToNextVisualNode(Node node) {
        Node next = node;
        while (next != null) {
            if ((next = this.getNextFlatNode(next)) == null) {
                this.setSourceFocus(((IndexedRegion)node.getOwnerDocument()).getEndOffset());
                return true;
            }
            if (next.getNodeType() == 3) {
                int so = ((IndexedRegion)next).getStartOffset();
                int shift = 0;
                char[] chars = ((TextImpl)next).getValueSource().toCharArray();
                while (shift < chars.length && this.isTextToSkip(chars, shift)) {
                    ++shift;
                }
                if (shift < chars.length) {
                    so += shift;
                }
                this.setSourceFocus(so);
                return true;
            }
            if (next.getNodeType() != 1) continue;
            Attr attr = this.getVisualNodeSourceAttribute(next);
            if (attr != null) {
                int attrSelStart = ((ElementImpl)attr.getOwnerElement()).getStartOffset() + ((AttrImpl)attr).getValueRegion().getStart() + 1;
                this.setSourceFocus(attrSelStart);
                return true;
            }
            nsIDOMNode visualNode = this.domMapping.getVisualNode(next);
            if (visualNode == null || !"input".equalsIgnoreCase(visualNode.getNodeName())) continue;
            this.setSourceFocus(((IndexedRegion)next).getStartOffset());
            return true;
        }
        return true;
    }

    boolean _moveCursorToPrevVisualNode(Node node) {
        return true;
    }

    private boolean moveBack() {
        Node node;
        SourceSelectionBuilder sourceSelectionBuilder = new SourceSelectionBuilder(this.sourceEditor);
        SourceSelection selection = sourceSelectionBuilder.getSelection();
        if (selection != null && selection.isCollapsed() && (node = this.getPrevNode(selection.getStartNode())) != null) {
            int nodeOffset = ((IndexedRegion)node).getStartOffset();
            this.pageContext.getSourceBuilder().getStructuredTextViewer().setSelectedRange(nodeOffset, 0);
            this.pageContext.getSourceBuilder().getStructuredTextViewer().revealRange(nodeOffset, 0);
            return true;
        }
        return false;
    }

    private Node getNextNode(Node node) {
        Node next = null;
        while (node != null && next == null) {
            next = this.getNextSibling(node);
            node = node.getParentNode();
        }
        while (next != null && next.getNodeType() == 1) {
            Node child = this.getFirstChild(next);
            if (child == null) break;
            next = child;
        }
        return next;
    }

    private Node getNextSibling(Node node) {
        while (node != null) {
            if ((node = node.getNextSibling()) != null && this.domMapping.getVisualNode(node) == null) continue;
            return node;
        }
        return null;
    }

    private Node getFirstChild(Node node) {
        node = node.getFirstChild();
        while (node != null && this.domMapping.getVisualNode(node) == null) {
            node = node.getNextSibling();
        }
        return node;
    }

    private Node getPrevNode(Node node) {
        Node prev = null;
        while (node != null && prev == null) {
            prev = this.getPrevSibling(node);
            node = node.getParentNode();
        }
        while (prev != null && prev.getNodeType() == 1) {
            Node child = this.getLastChild(prev);
            if (child == null) break;
            prev = child;
        }
        return prev;
    }

    private Node getPrevSibling(Node node) {
        while (node != null) {
            if ((node = node.getPreviousSibling()) != null && this.domMapping.getVisualNode(node) == null) continue;
            return node;
        }
        return null;
    }

    private Node getLastChild(Node node) {
        node = node.getLastChild();
        while (node != null && this.domMapping.getVisualNode(node) == null) {
            node = node.getPreviousSibling();
        }
        return node;
    }

    private boolean moveUp() {
        nsIDOMElement visualELement = this.getNearestNodeinUpDirection(this.getSelectedNode());
        Node sourceNode = this.domMapping.getSourceNode((nsIDOMNode)visualELement);
        if (sourceNode != null) {
            this.setSourceFocus(((IndexedRegion)sourceNode).getStartOffset());
            return true;
        }
        return false;
    }

    private boolean moveDown() {
        nsIDOMElement visualELement = this.getNearestNodeinDownDirection(this.getSelectedNode());
        Node sourceNode = this.domMapping.getSourceNode((nsIDOMNode)visualELement);
        if (sourceNode != null) {
            this.setSourceFocus(((IndexedRegion)sourceNode).getStartOffset());
            return true;
        }
        return false;
    }

    private boolean moveHome(boolean extend) {
        return true;
    }

    private boolean moveEnd(boolean extend) {
        VpePlugin.getDefault().logInfo("MoveEnd");
        return true;
    }

    private nsIDOMElement getNearestNodeinUpDirection(nsIDOMElement currentNode) {
        if (currentNode == null) {
            return null;
        }
        Set<nsIDOMNode> elements = this.domMapping.getVisualMap().keySet();
        nsIDOMElement nearestElement = null;
        Rectangle curentElementRect = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)currentNode);
        Rectangle domElementRect = null;
        int minlenght = Integer.MAX_VALUE;
        int currentLenght = 0;
        for (nsIDOMNode nsDOMNode : elements) {
            currentLenght = Integer.MAX_VALUE;
            try {
                nsIDOMElement domElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)nsDOMNode, nsIDOMElement.class);
                if (nearestElement == null) {
                    nearestElement = domElement;
                    continue;
                }
                domElementRect = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)domElement);
                if (domElementRect.y >= curentElementRect.y) continue;
                currentLenght = curentElementRect.y - domElementRect.y;
                if (currentLenght < minlenght) {
                    minlenght = currentLenght;
                    nearestElement = domElement;
                    continue;
                }
                if (currentLenght != minlenght || Math.abs(curentElementRect.x - XulRunnerVpeUtils.getElementBounds((nsIDOMNode)nearestElement).x) <= Math.abs(curentElementRect.x - domElementRect.x)) continue;
                minlenght = currentLenght;
                nearestElement = domElement;
            }
            catch (XPCOMException xPCOMException) {}
        }
        return nearestElement;
    }

    private nsIDOMElement getNearestNodeinDownDirection(nsIDOMElement currentNode) {
        if (currentNode == null) {
            return null;
        }
        Set<nsIDOMNode> elements = this.domMapping.getVisualMap().keySet();
        nsIDOMElement nearestElement = null;
        Rectangle curentElementRect = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)currentNode);
        Rectangle domElementRect = null;
        int minlenght = Integer.MAX_VALUE;
        int currentLenght = 0;
        for (nsIDOMNode nsDOMNode : elements) {
            currentLenght = Integer.MAX_VALUE;
            try {
                nsIDOMElement domElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)nsDOMNode, nsIDOMElement.class);
                if (nearestElement == null) {
                    nearestElement = domElement;
                    continue;
                }
                domElementRect = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)domElement);
                if (domElementRect.y <= curentElementRect.y) continue;
                currentLenght = domElementRect.y - curentElementRect.y;
                if (currentLenght < minlenght) {
                    minlenght = currentLenght;
                    nearestElement = domElement;
                    continue;
                }
                if (currentLenght != minlenght || Math.abs(curentElementRect.x - XulRunnerVpeUtils.getElementBounds((nsIDOMNode)nearestElement).x) <= Math.abs(curentElementRect.x - domElementRect.x)) continue;
                minlenght = currentLenght;
                nearestElement = domElement;
            }
            catch (XPCOMException xPCOMException) {}
        }
        return nearestElement;
    }

    private nsIDOMElement getNearestNodeinRightDirection(nsIDOMElement currentNode) {
        if (currentNode == null) {
            return null;
        }
        Set<nsIDOMNode> elements = this.domMapping.getVisualMap().keySet();
        nsIDOMElement nearestElement = null;
        Rectangle curentElementRect = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)currentNode);
        Rectangle domElementRect = null;
        int minlenght = Integer.MAX_VALUE;
        int currentLenght = 0;
        for (nsIDOMNode nsDOMNode : elements) {
            currentLenght = Integer.MAX_VALUE;
            try {
                nsIDOMElement domElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)nsDOMNode, nsIDOMElement.class);
                if (nearestElement == null) {
                    nearestElement = domElement;
                    continue;
                }
                domElementRect = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)domElement);
                if (domElementRect.x <= curentElementRect.x) continue;
                currentLenght = domElementRect.x - curentElementRect.x;
                if (currentLenght < minlenght) {
                    minlenght = currentLenght;
                    nearestElement = domElement;
                    continue;
                }
                if (currentLenght != minlenght || Math.abs(curentElementRect.y - XulRunnerVpeUtils.getElementBounds((nsIDOMNode)nearestElement).y) <= Math.abs(curentElementRect.y - domElementRect.y)) continue;
                minlenght = currentLenght;
                nearestElement = domElement;
            }
            catch (XPCOMException xPCOMException) {}
        }
        return nearestElement;
    }

    private nsIDOMElement getNearestNodeinLeftDirection(nsIDOMElement currentNode) {
        if (currentNode == null) {
            return null;
        }
        Set<nsIDOMNode> elements = this.domMapping.getVisualMap().keySet();
        nsIDOMElement nearestElement = null;
        Rectangle curentElementRect = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)currentNode);
        Rectangle domElementRect = null;
        int minlenght = Integer.MAX_VALUE;
        int currentLenght = 0;
        for (nsIDOMNode nsDOMNode : elements) {
            currentLenght = Integer.MAX_VALUE;
            try {
                nsIDOMElement domElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)nsDOMNode, nsIDOMElement.class);
                if (nearestElement == null) {
                    nearestElement = domElement;
                    continue;
                }
                domElementRect = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)domElement);
                if (domElementRect.x >= curentElementRect.x) continue;
                currentLenght = curentElementRect.x - domElementRect.x;
                if (currentLenght < minlenght) {
                    minlenght = currentLenght;
                    nearestElement = domElement;
                    continue;
                }
                if (currentLenght != minlenght || Math.abs(curentElementRect.y - XulRunnerVpeUtils.getElementBounds((nsIDOMNode)nearestElement).y) <= Math.abs(curentElementRect.y - domElementRect.y)) continue;
                minlenght = currentLenght;
                nearestElement = domElement;
            }
            catch (XPCOMException xPCOMException) {}
        }
        return nearestElement;
    }

    private nsIDOMElement getSelectedNode() {
        return this.pageContext.getEditPart().getController().getXulRunnerEditor().getSelectedElement();
    }
}

