/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class FileSystemsRenameListener {
    static Contribution contribution;
    XModelObject fileSystems;

    static {
        try {
            if (Platform.getBundle((String)"org.jboss.tools.jst.web") != null) {
                contribution = (Contribution)ModelFeatureFactory.getInstance().createFeatureInstance("org.jboss.tools.jst.web.project.FileSystemsRenameListenerContribution");
            }
        }
        catch (ClassCastException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public FileSystemsRenameListener(XModelObject fileSystems) {
        this.fileSystems = fileSystems;
    }

    public XModelObject getFileSystems() {
        return this.fileSystems;
    }

    public void checkFileSystemRename(IResourceChangeEvent event) {
        String[] r = this.processDelta(event.getDelta());
        if (r.length == 0) {
            return;
        }
        this.pathRenamed(r[0], r[1]);
    }

    private String[] processDelta(IResourceDelta delta) {
        if (delta == null) {
            return new String[0];
        }
        String[] r = this.extractRename(delta);
        if (r != null) {
            return r;
        }
        IResourceDelta[] cs = delta.getAffectedChildren();
        if (delta.getKind() == 4 && cs != null && cs.length > 0) {
            int i = 0;
            while (i < cs.length) {
                r = this.processDelta(cs[i]);
                if (r != null) {
                    return r;
                }
                ++i;
            }
        }
        return new String[0];
    }

    private String[] extractRename(IResourceDelta delta) {
        if (delta.getKind() != 4) {
            return null;
        }
        IResourceDelta[] cs = delta.getAffectedChildren();
        if (cs == null || cs.length != 2) {
            return null;
        }
        String[] r = this.extractRename(cs[0], cs[1]);
        if (r == null) {
            r = this.extractRename(cs[1], cs[0]);
        }
        return r;
    }

    private String[] extractRename(IResourceDelta d1, IResourceDelta d2) {
        if (d1.getKind() != 1 || d2.getKind() != 2) {
            return null;
        }
        IPath from = d1.getMovedFromPath();
        IPath to = d2.getMovedToPath();
        if (from == null || to == null) {
            return null;
        }
        IPath f = this.getLocation(from);
        IPath t = this.getLocation(to);
        if (f != null && t != null) {
            from = f;
            to = t;
        }
        return new String[]{from.toString(), to.toString()};
    }

    private IPath getLocation(IPath path) {
        if (path.segmentCount() > 1) {
            IFolder folder = ModelPlugin.getWorkspace().getRoot().getFolder(path);
            return folder == null ? null : folder.getLocation();
        }
        IProject project = ModelPlugin.getWorkspace().getRoot().getProject(path.segments()[0]);
        return project == null ? null : project.getLocation();
    }

    private void pathRenamed(String oldPath, String newPath) {
        String ws = XModelConstants.getWorkspace(this.fileSystems.getModel());
        if (!(ws = ws.replace('\\', '/')).toLowerCase().startsWith(oldPath.toLowerCase())) {
            return;
        }
        if (contribution != null) {
            contribution.pathRenamed(this, oldPath, newPath);
        }
        ws = String.valueOf(newPath) + ws.substring(oldPath.length());
        this.fileSystems.getModel().getProperties().setProperty(XModelConstants.WORKSPACE, ws);
        XModelObject[] fs = this.fileSystems.getChildren("FileSystemFolder");
        int i = 0;
        while (i < fs.length) {
            String s = XModelObjectUtil.getExpandedValue(fs[i], "location", null);
            s = s.replace('\\', '/');
            XModelObject ns = fs[i].copy(0);
            fs[i].removeFromParent();
            this.fileSystems.addChild(ns);
            ((XModelImpl)this.fileSystems.getModel()).fireStructureChanged(ns);
            ++i;
        }
        this.fileSystems.setModified(true);
        this.fileSystems.getModel().save();
    }

    public static interface Contribution {
        public void pathRenamed(FileSystemsRenameListener var1, String var2, String var3);
    }
}

