/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.files.handlers;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.files.handlers.TargetHolder;
import org.jboss.tools.common.model.filesystems.impl.CreateFileHandler;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.impl.MappedEntityRecognizer;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;

public class CreateFileSupport
extends SpecialWizardSupport {
    public static String INITIAL_FOLDER_PROPERTY = "initialFolder";
    public static String INITIAL_FILE_PROPERTY = "initialFile";
    static final String ATTR_TEMPLATE = "template";
    static final String ATTR_FOLDER = "folder";
    protected TargetHolder targetHolder = new TargetHolder();
    TreeMap<String, String> versionEntities = new TreeMap();
    boolean useVersions = false;
    protected DefaultWizardDataValidator validator = this.createValidator();

    @Override
    public void reset() {
        String initialFile;
        this.targetHolder.setAction(this.action);
        if (this.hasTemplate()) {
            String[] s = this.getPageTemplateList();
            this.setValueList(0, ATTR_TEMPLATE, s);
            if (s.length > 0) {
                String defaultPageTemplate = this.getDefaultPageTemplate();
                if (defaultPageTemplate == null) {
                    defaultPageTemplate = s[0];
                } else {
                    boolean bFound = false;
                    int i = 0;
                    while (i < s.length && !bFound) {
                        if (s[i].equals(defaultPageTemplate)) {
                            bFound = true;
                        }
                        ++i;
                    }
                    if (!bFound) {
                        defaultPageTemplate = s[0];
                    }
                }
                this.setAttributeValue(0, ATTR_TEMPLATE, defaultPageTemplate);
            }
        }
        this.targetHolder.target = this.getTarget();
        IResource r = (IResource)this.getTarget().getAdapter(IResource.class);
        if (r == null) {
            this.setAttributeValue(0, ATTR_FOLDER, "");
            this.targetHolder.revalidate(null);
        } else {
            this.targetHolder.revalidate(r.getFullPath().toString());
            this.setAttributeValue(0, ATTR_FOLDER, this.targetHolder.path);
        }
        String initialFolder = this.p.getProperty(INITIAL_FOLDER_PROPERTY);
        if (initialFolder != null && initialFolder.length() > 0) {
            this.setAttributeValue(0, ATTR_FOLDER, initialFolder);
        }
        if ((initialFile = this.p.getProperty(INITIAL_FILE_PROPERTY)) != null && initialFile.length() > 0) {
            this.setAttributeValue(0, "name", initialFile);
        }
        this.initVersions();
    }

    protected String getDefaultPageTemplate() {
        return null;
    }

    void initVersions() {
        this.useVersions = false;
        this.versionEntities.clear();
        XModelMetaData meta = this.getTarget().getModel().getMetaData();
        XMapping m = meta.getMapping("FileVersions");
        if (m == null) {
            return;
        }
        String entityVersion = this.action.getProperty("entityVersion");
        if (entityVersion == null || entityVersion.length() == 0) {
            return;
        }
        if (this.getAttributeValue(0, "version") == null) {
            return;
        }
        this.useVersions = true;
        String[] keys = m.getKeys();
        int i = 0;
        while (i < keys.length) {
            String entity;
            if (keys[i].startsWith(entityVersion) && meta.getEntity(entity = m.getValue(keys[i])) != null) {
                String version = keys[i].substring(entityVersion.length());
                this.versionEntities.put(version, entity);
            }
            ++i;
        }
        if (this.versionEntities.size() == 0 && this.action.getProperty("entity") != null) {
            this.versionEntities.put("default", this.action.getProperty("entity"));
        }
        String[] versionList = this.versionEntities.keySet().toArray(new String[0]);
        this.setValueList(0, "version", versionList);
        if (versionList.length > 0) {
            String d;
            DefaultVersionResolver resolver;
            String defaultVersion = versionList[versionList.length - 1];
            String defaultVersionResolver = this.action.getProperty("defaultVersionResolver");
            if (defaultVersionResolver != null && (resolver = (DefaultVersionResolver)ModelFeatureFactory.getInstance().createFeatureInstance(defaultVersionResolver)) != null && (d = resolver.resolve(versionList, this.getTarget())) != null) {
                defaultVersion = d;
            }
            this.setAttributeValue(0, "version", defaultVersion);
        }
    }

    private boolean hasTemplate() {
        return this.findAttribute(0, ATTR_TEMPLATE) != null;
    }

    @Override
    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            if (!this.checkResource()) {
                return;
            }
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        } else if (HELP.equals(name)) {
            this.help();
        }
    }

    @Override
    public String[] getActionNames(int stepId) {
        return new String[]{FINISH, CANCEL, HELP};
    }

    protected void execute() throws XModelException {
        Properties p = this.extractStepData(0);
        String path = p.getProperty("name");
        XModelObject f = this.createFile(path = this.revalidatePath(path));
        if (f != null) {
            this.targetHolder.saveLastPath();
        }
        if (f != null) {
            this.open(f);
        }
    }

    protected boolean checkResource() {
        if (this.targetHolder.addPath.length() == 0) {
            return true;
        }
        ServiceDialog d = this.getTarget().getModel().getService();
        String message = MessageFormat.format("Folder {0} does not exist. Do you want to create it?", this.targetHolder.path);
        int q = d.showDialog(ModelMessages.WARNING, message, new String[]{SpecialWizardSupport.OK, SpecialWizardSupport.CANCEL}, null, 0);
        return q == 0;
    }

    @Override
    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        String path = values.getProperty("name");
        boolean c = this.canCreateFile(path);
        if (name.equals(ATTR_TEMPLATE)) {
            return c;
        }
        return true;
    }

    public boolean canCreateFile(String path) {
        if (this.targetHolder.target == null) {
            return false;
        }
        if (path == null || path.length() == 0 || path.indexOf(42) >= 0) {
            return false;
        }
        return this.isCorrectPath(path) && !this.fileExists(path);
    }

    boolean isCorrectPath(String path) {
        return (path = this.revalidatePath(path)) != null && !path.equals("/") && path.indexOf("//") < 0;
    }

    boolean fileExists(String path) {
        if (path == null || this.targetHolder.target == null) {
            return false;
        }
        if ((path = this.revalidatePath(path)).startsWith("/")) {
            path = path.substring(1);
        }
        return this.targetHolder.target.getChildByPath(path) != null;
    }

    protected String revalidatePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String extension = "." + this.action.getProperty("extension");
        if (path.lastIndexOf(46) < 0) {
            path = String.valueOf(path) + extension;
        } else {
            String ext = path.substring(path.lastIndexOf(46));
            if (!ext.equals(extension) && extension.length() > 1) {
                path = String.valueOf(path) + extension;
            }
        }
        if (this.targetHolder.addPath.length() > 0) {
            path = String.valueOf(this.targetHolder.addPath) + path;
        }
        return path;
    }

    protected XModelObject createFile(String path) throws XModelException {
        if (!this.canCreateFile(path)) {
            return null;
        }
        try {
            String body = this.getTemplateBody();
            body = this.modifyBody(body);
            return this.createFile(this.targetHolder.target, path, body, this.extractStepData(0));
        }
        catch (IOException e) {
            throw new XModelException(e);
        }
    }

    protected String getTemplateBody() throws IOException {
        File templateFile = null;
        String template = this.getAttributeValue(0, ATTR_TEMPLATE);
        if (!(template == null || template.trim().length() <= 0 || (templateFile = this.findTemplate(template.trim())) != null && templateFile.isFile())) {
            throw new IOException(MessageFormat.format("Template {0} is not found.", template));
        }
        return templateFile == null ? "" : FileUtil.readFile(templateFile);
    }

    protected String modifyBody(String body) throws IOException {
        return body;
    }

    protected void open(final XModelObject f) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FindObjectHelper.findModelObject(f, FindObjectHelper.EVERY_WHERE);
            }
        });
    }

    XModelObject createFile(XModelObject fs, String path, String body, Properties p) throws XModelException {
        String txt;
        String enc;
        XModelObject fq;
        String s;
        StringTokenizer st = new StringTokenizer(path, "/");
        int c = st.countTokens();
        int i = 0;
        while (i < c - 1) {
            s = st.nextToken();
            XModelObject o = fs.getChildByPath(s);
            if (o == null) {
                o = fs.getModel().createModelObject("FileFolder", null);
                o.setAttributeValue("name", s);
                DefaultCreateHandler.addCreatedObject(fs, o, FindObjectHelper.IN_NAVIGATOR_ONLY);
                ((FolderImpl)o).save();
            }
            fs = o;
            ++i;
        }
        s = st.nextToken();
        int dot = s.lastIndexOf(46);
        String n = s.substring(0, dot);
        String e = s.substring(dot + 1);
        String entity = this.getFileEntity(e);
        XModelObject f = XModelObjectLoaderUtil.createValidObject(fs.getModel(), entity, p);
        f.setAttributeValue("name", n);
        f.setAttributeValue("extension", e);
        if (body != null) {
            f.setAttributeValue("body", body);
        }
        if ((fq = fs.getChildByPath((f = this.modifyCreatedObject(f)).getPathPart())) != null) {
            return fq;
        }
        DefaultCreateHandler.addCreatedObject(fs, f, FindObjectHelper.IN_NAVIGATOR_ONLY);
        if (f instanceof FileAnyImpl && f.getModelEntity().getAttribute("encoding") != null && (enc = XModelObjectLoaderUtil.getEncoding(txt = ((FileAnyImpl)f).getAsText())) != null) {
            f.setAttributeValue("encoding", enc);
        }
        String modelPath = f.getPath();
        ((FolderImpl)fs).saveChild(f);
        fs.getModel().update();
        if (f.getParent() == null) {
            f = f.getModel().getByPath(modelPath);
        }
        if (f != null) {
            this.getProperties().put("created", f);
        }
        return f;
    }

    protected String getFileEntity(String extension) {
        if (this.useVersions) {
            String entity;
            String version = this.getAttributeValue(0, "version");
            String string = entity = version == null ? null : this.versionEntities.get(version);
            if (entity != null) {
                return entity;
            }
        }
        String entity = null;
        if (extension.equals(this.action.getProperty("extension"))) {
            entity = this.action.getProperty("entity");
        }
        if (entity == null) {
            entity = new MappedEntityRecognizer().getEntityName(new EntityRecognizerContext(extension));
        }
        if (entity != null && this.getTarget().getModel().getMetaData().getEntity(entity) != null) {
            return entity;
        }
        return "FileAny";
    }

    protected XModelObject modifyCreatedObject(XModelObject o) {
        return o;
    }

    protected File findTemplate(String name) {
        return null;
    }

    public String[] getPageTemplateList() {
        return new String[0];
    }

    protected final XModelObject getTargetFolder() {
        return this.targetHolder.target;
    }

    @Override
    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport(this, step);
        return this.validator;
    }

    protected DefaultWizardDataValidator createValidator() {
        return new Validator();
    }

    @Override
    public String getFocusAttribute(int stepId) {
        if (stepId == 0) {
            return "name";
        }
        return super.getFocusAttribute(stepId);
    }

    public static interface DefaultVersionResolver {
        public String resolve(String[] var1, XModelObject var2);
    }

    protected class Validator
    extends DefaultWizardDataValidator {
        String FORBIDDEN_INDICES = "\"\n\t*\\/:<>?|";
        String FORBIDDEN_FOLDER_LETTERS = "\"\n\t*:<>?|";

        protected Validator() {
        }

        @Override
        public void validate(Properties data) {
            File templateFile;
            String folder = data.getProperty(CreateFileSupport.ATTR_FOLDER);
            CreateFileSupport.this.targetHolder.revalidate(folder);
            this.message = null;
            this.validateFolderName();
            if (this.message != null) {
                return;
            }
            this.validateFileName(data);
            if (this.message != null) {
                return;
            }
            String template = data.getProperty(CreateFileSupport.ATTR_TEMPLATE);
            if (!(template == null || template.trim().length() <= 0 || (templateFile = CreateFileSupport.this.findTemplate(template.trim())) != null && templateFile.isFile())) {
                this.message = "Template does not exist.";
            }
            if (this.message != null) {
                return;
            }
            super.validate(data);
        }

        protected void validateFileName(Properties data) {
            if (this.message != null) {
                return;
            }
            String fileName = data.getProperty("name");
            if (fileName == null || fileName.length() == 0) {
                return;
            }
            if (fileName.equals(".")) {
                this.message = "Incorrect file name.";
            } else if (fileName.endsWith(".") && fileName.indexOf(46) != fileName.lastIndexOf(46)) {
                this.message = "File name must not end in a period.";
            } else {
                int i = 0;
                while (i < this.FORBIDDEN_INDICES.length()) {
                    if (fileName.indexOf(this.FORBIDDEN_INDICES.charAt(i)) >= 0) {
                        this.message = MessageFormat.format("File name must not contain character {0} .", Character.valueOf(this.FORBIDDEN_INDICES.charAt(i)));
                        return;
                    }
                    ++i;
                }
            }
        }

        private void validateFolderName() {
            if (CreateFileSupport.this.targetHolder.addPath.length() == 0) {
                return;
            }
            int i = 0;
            while (i < this.FORBIDDEN_FOLDER_LETTERS.length()) {
                if (CreateFileSupport.this.targetHolder.addPath.indexOf(this.FORBIDDEN_FOLDER_LETTERS.charAt(i)) >= 0) {
                    this.message = MessageFormat.format("Folder name must not contain character {0} .", Character.valueOf(this.FORBIDDEN_FOLDER_LETTERS.charAt(i)));
                    return;
                }
                ++i;
            }
        }

        @Override
        protected void validateAddFile(XEntityData[] ds, Properties data) {
            CreateFileHandler.validateNameAndExtension(CreateFileSupport.this.action, data, null);
            if (CreateFileSupport.this.targetHolder.target != null) {
                String entity = CreateFileSupport.this.action.getProperty("entity");
                if (entity == null) {
                    entity = CreateFileSupport.this.getEntityData()[this.step].getModelEntity().getName();
                }
                if (!(CreateFileSupport.this.targetHolder.addPath != null && CreateFileSupport.this.targetHolder.addPath.length() != 0 || this.checkChild(CreateFileSupport.this.targetHolder.target, entity, data))) {
                    return;
                }
            } else {
                this.message = "Cannot create file in specified folder.";
            }
        }
    }
}

