/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.hibernate.eclipse.graph.AbstractGraphViewPart;
import org.hibernate.eclipse.graph.EntityGraphView;
import org.hibernate.eclipse.graph.HibernateConfigurationPartFactory;
import org.hibernate.eclipse.graph.RelationalConfigurationEditPartFactory;
import org.hibernate.eclipse.graph.model.ConfigurationViewAdapter;
import org.hibernate.eclipse.graph.model.TableViewAdapter;
import org.hibernate.eclipse.graph.parts.ConfigurationEditPart;
import org.hibernate.eclipse.graph.parts.PersistentClassEditPart;
import org.hibernate.mapping.Table;

public class RelationalGraphView
extends AbstractGraphViewPart {
    @Override
    protected void setupListener() {
        this.getSite().getPage().addSelectionListener(EntityGraphView.ID, this.listener);
    }

    @Override
    protected void disposeListeners() {
        this.getSite().getPage().removeSelectionListener(EntityGraphView.ID, this.listener);
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        Iterator iterator = selection.iterator();
        ArrayList<TableViewAdapter> tables = new ArrayList<TableViewAdapter>();
        ConfigurationViewAdapter cv = null;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof PersistentClassEditPart)) continue;
            PersistentClassEditPart pe = (PersistentClassEditPart)o;
            if (cv == null) {
                cv = new ConfigurationViewAdapter(pe.getPersistentClassViewAdapter().getConfiguration().getConfiguration());
            }
            Table table = pe.getPersistentClassViewAdapter().getPersistentClass().getTable();
            tables.add(new TableViewAdapter(cv, table));
        }
        if (cv != null) {
            cv.setSelectedTables(tables);
            this.viewer.setContents((Object)cv);
            ((ConfigurationEditPart)this.viewer.getContents()).setManualLayoutActive(true);
        }
    }

    @Override
    protected HibernateConfigurationPartFactory createEditPartFactory() {
        return new RelationalConfigurationEditPartFactory();
    }
}

