/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;
import org.hibernate.cfg.reveng.SQLTypeMapping;
import org.hibernate.eclipse.console.model.ITypeMapping;

public final class TypeMappingCellModifier
implements ICellModifier {
    private final TableViewer tv;

    public TypeMappingCellModifier(TableViewer tv) {
        this.tv = tv;
    }

    public void modify(Object element, String property, Object value) {
        Boolean integerToBoolean;
        ITypeMapping tf = (ITypeMapping)((TableItem)element).getData();
        if ("jdbctype".equals(property) && !this.safeEquals(value, tf.getJDBCType())) {
            tf.setJDBCType((String)value);
        }
        if ("hibernatetype".equals(property) && !this.safeEquals(value, tf.getHibernateType())) {
            tf.setHibernateType((String)value);
        }
        if ("length".equals(property) && !this.safeEquals(value, tf.getLength())) {
            tf.setLength((Integer)value);
        }
        if ("precision".equals(property) && !this.safeEquals(value, tf)) {
            tf.setPrecision((Integer)value);
        }
        if ("scale".equals(property) && !this.safeEquals(value, tf.getScale())) {
            tf.setScale((Integer)value);
        }
        if ("not-null".equals(property) && !this.safeEquals(integerToBoolean = this.notnullToNullable((Integer)value), tf.getNullable())) {
            tf.setNullable(integerToBoolean);
        }
        this.tv.update(new Object[]{tf}, new String[]{property});
    }

    private Boolean notnullToNullable(Integer value) {
        if (value == 1) {
            return Boolean.FALSE;
        }
        if (value == 0) {
            return Boolean.TRUE;
        }
        if (value == 2) {
            return SQLTypeMapping.UNKNOWN_NULLABLE;
        }
        return SQLTypeMapping.UNKNOWN_NULLABLE;
    }

    private boolean safeEquals(Object value, Object tf) {
        if (value == tf) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.equals(tf);
    }

    public Object getValue(Object element, String property) {
        ITypeMapping tf = (ITypeMapping)element;
        if ("precision".equals(property)) {
            return tf.getPrecision();
        }
        if ("jdbctype".equals(property)) {
            return tf.getJDBCType();
        }
        if ("hibernatetype".equals(property)) {
            return tf.getHibernateType();
        }
        if ("scale".equals(property)) {
            return tf.getScale();
        }
        if ("length".equals(property)) {
            return tf.getLength();
        }
        if ("not-null".equals(property)) {
            if (tf.getNullable() == null) {
                return 2;
            }
            if (tf.getNullable().booleanValue()) {
                return 0;
            }
            return 1;
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }
}

