/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.Iterator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.ConsoleConfigurationBasedAction;
import org.hibernate.eclipse.console.utils.EclipseImages;

public class ReloadConfigurationAction
extends ConsoleConfigurationBasedAction {
    public static final String RELOADCONFIG_ACTIONID = "actionid.reloadconfig";
    private StructuredViewer viewer;

    protected ReloadConfigurationAction(StructuredViewer sv) {
        super(HibernateConsoleMessages.ReloadConfigurationAction_rebuild_configuration);
        this.setEnabledWhenNoSessionFactory(true);
        this.viewer = sv;
        this.setImageDescriptor(EclipseImages.getImageDescriptor("images/reload.gif"));
        this.setId(RELOADCONFIG_ACTIONID);
    }

    @Override
    protected void doRun() {
        Iterator i = this.getSelectedNonResources().iterator();
        while (i.hasNext()) {
            try {
                Object node = i.next();
                if (!(node instanceof ConsoleConfiguration)) continue;
                ConsoleConfiguration config = (ConsoleConfiguration)node;
                config.reset();
                this.updateState(config);
                this.viewer.refresh(node);
            }
            catch (HibernateConsoleRuntimeException he) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), HibernateConsoleMessages.ReloadConfigurationAction_exception_while_start_hibernate, he);
            }
            catch (UnsupportedClassVersionError ucve) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), HibernateConsoleMessages.ReloadConfigurationAction_starting_hibernate_resulted_exception, ucve);
            }
        }
    }
}

