/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.hibernate.console.ConsoleQueryParameter;
import org.hibernate.console.QueryInputModel;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.QueryEditor;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.views.IQueryParametersPage;
import org.hibernate.eclipse.console.views.StringArrayDialogCellEditor;
import org.hibernate.type.NullableType;
import org.hibernate.type.Type;
import org.hibernate.util.xpl.StringHelper;

public class QueryParametersPage
extends Page
implements IQueryParametersPage {
    private static final String NAME_PROPERTY = "name";
    private static final String TYPE_PROPERTY = "type";
    private static final String VALUE_PROPERTY = "value";
    private static final String NULL_PROPERTY = "null_prop";
    private Composite top = null;
    private Table queryParametersTable = null;
    private TableViewer tableViewer;
    private Label statusLabel;
    final QueryInputModel model;
    private ToggleActive toggleActive;
    private Observer observer = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            if (!QueryParametersPage.this.tableViewer.getTable().isDisposed()) {
                QueryParametersPage.this.tableViewer.refresh();
                QueryParametersPage.this.tableViewer.getTable().setEnabled(!QueryParametersPage.this.model.ignoreParameters());
            }
        }
    };
    private final QueryEditor editor;

    public QueryParametersPage(QueryEditor editor) {
        this.editor = editor;
        this.model = editor.getQueryInputModel();
    }

    public Control getControl() {
        return this.top;
    }

    public void createControl(Composite parent) {
        this.top = new Composite(parent, 0);
        this.top.setLayout((Layout)new GridLayout());
        this.createQueryParametersTable();
        this.createStatusLabel();
        this.model.addObserver(this.observer);
        this.toggleActive.setChecked(this.model.ignoreParameters());
        this.tableViewer.getTable().setEnabled(!this.model.ignoreParameters());
        this.tableViewer.setInput((Object)this.model);
    }

    private void createStatusLabel() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.statusLabel = new Label(this.top, 0);
        this.statusLabel.setLayoutData((Object)gridData);
    }

    public void setFocus() {
        this.queryParametersTable.setFocus();
    }

    private void createQueryParametersTable() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        this.queryParametersTable = new Table(this.top, 65536);
        this.queryParametersTable.setHeaderVisible(true);
        this.queryParametersTable.setLayoutData((Object)gridData);
        this.queryParametersTable.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(this.queryParametersTable, 0);
        nameColumn.setWidth(100);
        nameColumn.setText(HibernateConsoleMessages.QueryParametersPage_name);
        TableColumn typeColumn = new TableColumn(this.queryParametersTable, 0);
        typeColumn.setWidth(75);
        typeColumn.setText(HibernateConsoleMessages.QueryParametersPage_type);
        TableColumn valueColumn = new TableColumn(this.queryParametersTable, 0);
        valueColumn.setWidth(100);
        valueColumn.setText(HibernateConsoleMessages.QueryParametersPage_value);
        TableColumn nullColumn = new TableColumn(this.queryParametersTable, 0);
        nullColumn.setWidth(32);
        nullColumn.setText(HibernateConsoleMessages.QueryParametersPage_null);
        this.tableViewer = new TableViewer(this.queryParametersTable);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (QueryParametersPage.this.statusLabel != null) {
                    Object firstElement = ((IStructuredSelection)QueryParametersPage.this.tableViewer.getSelection()).getFirstElement();
                    if (firstElement instanceof ConsoleQueryParameter) {
                        QueryParametersPage.this.statusLabel.setText(String.valueOf(HibernateConsoleMessages.QueryParametersPage_format) + ((ConsoleQueryParameter)firstElement).getDefaultFormat());
                    } else {
                        QueryParametersPage.this.statusLabel.setText("");
                    }
                }
            }
        });
        final ArrayList possibleTypes = new ArrayList(ConsoleQueryParameter.getPossibleTypes());
        Collections.sort(possibleTypes, new Comparator<Type>(){

            @Override
            public int compare(Type t1, Type t2) {
                return t1.getName().compareTo(t2.getName());
            }
        });
        this.tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                ConsoleQueryParameter cqp = (ConsoleQueryParameter)item.getData();
                if (QueryParametersPage.NAME_PROPERTY.equals(property)) {
                    cqp.setName((String)value);
                }
                if (QueryParametersPage.TYPE_PROPERTY.equals(property)) {
                    Iterator iterator = possibleTypes.iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        NullableType type = (NullableType)iterator.next();
                        if (i == (Integer)value) {
                            if (cqp.getType() == type) break;
                            cqp.setType(type);
                            cqp.setNull();
                            break;
                        }
                        ++i;
                    }
                }
                if (QueryParametersPage.VALUE_PROPERTY.equals(property)) {
                    String[] inputStrings = value instanceof String[] ? (String[])value : new String[]{(String)value};
                    Object[] values = new Object[inputStrings.length];
                    int i = 0;
                    while (i < inputStrings.length) {
                        values[i] = cqp.convertStringToValue(inputStrings[i]);
                        ++i;
                    }
                    if (values.length > 1) {
                        cqp.setValue((Object)values);
                    } else if (values.length == 1) {
                        cqp.setValue(values[0]);
                    } else {
                        cqp.setValue(null);
                    }
                }
                if (QueryParametersPage.NULL_PROPERTY.equals(property)) {
                    if (cqp.isNull()) {
                        cqp.setValue(cqp.convertStringToValue(""));
                    } else {
                        cqp.setNull();
                    }
                }
                QueryParametersPage.this.tableViewer.refresh((Object)cqp);
            }

            public Object getValue(Object element, String property) {
                ConsoleQueryParameter cqp = (ConsoleQueryParameter)element;
                if (QueryParametersPage.NAME_PROPERTY.equals(property)) {
                    return cqp.getName();
                }
                if (QueryParametersPage.TYPE_PROPERTY.equals(property)) {
                    Iterator iterator = possibleTypes.iterator();
                    NullableType type = cqp.getType();
                    int i = 0;
                    while (iterator.hasNext()) {
                        if (type == iterator.next()) {
                            return i;
                        }
                        ++i;
                    }
                }
                if (QueryParametersPage.VALUE_PROPERTY.equals(property)) {
                    return cqp.getStringValues();
                }
                if (QueryParametersPage.NULL_PROPERTY.equals(property)) {
                    return cqp.isNull();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((QueryInputModel)inputElement).getQueryParameters();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        String[] columnProperties = new String[]{NAME_PROPERTY, TYPE_PROPERTY, VALUE_PROPERTY, NULL_PROPERTY};
        this.tableViewer.setColumnProperties(columnProperties);
        String[] valueTypes = new String[possibleTypes.size()];
        Iterator iterator = possibleTypes.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Type element = (Type)iterator.next();
            valueTypes[i++] = element.getName();
        }
        CellEditor[] editors = new CellEditor[columnProperties.length];
        editors[0] = new TextCellEditor((Composite)this.queryParametersTable);
        editors[1] = new ComboBoxCellEditor((Composite)this.queryParametersTable, valueTypes, 8);
        editors[2] = new StringArrayDialogCellEditor((Composite)this.queryParametersTable){
            private Button b;

            public void activate() {
                Object param = ((IStructuredSelection)QueryParametersPage.this.tableViewer.getSelection()).getFirstElement();
                if (param instanceof ConsoleQueryParameter) {
                    try {
                        Integer.parseInt(((ConsoleQueryParameter)param).getName());
                        this.b.setVisible(false);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.b.setVisible(true);
                    }
                }
            }

            @Override
            protected Button createButton(Composite parent) {
                this.b = super.createButton(parent);
                return this.b;
            }
        };
        editors[3] = new CheckboxCellEditor((Composite)this.queryParametersTable);
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                ConsoleQueryParameter cqp = (ConsoleQueryParameter)element;
                switch (columnIndex) {
                    case 0: {
                        return cqp.getName();
                    }
                    case 1: {
                        return cqp.getType().getName();
                    }
                    case 2: {
                        String label = cqp.getStringValues()[0];
                        int j = 1;
                        while (j < cqp.getStringValues().length) {
                            label = String.valueOf(label) + "|" + cqp.getStringValues()[j];
                            ++j;
                        }
                        return label;
                    }
                    case 3: {
                        return null;
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 3) {
                    ConsoleQueryParameter cqp = (ConsoleQueryParameter)element;
                    return cqp.isNull() ? EclipseImages.getImage("images/xpl/complete_tsk.gif") : EclipseImages.getImage("images/xpl/incomplete_tsk.gif");
                }
                return null;
            }
        });
    }

    public void init(IPageSite site) {
        super.init(site);
        NewRowAction newRowAction = new NewRowAction();
        site.getActionBars().getToolBarManager().add((IAction)newRowAction);
        site.getActionBars().getToolBarManager().add((IAction)new RemoveRowAction());
        this.toggleActive = new ToggleActive();
        site.getActionBars().getToolBarManager().add((IAction)this.toggleActive);
    }

    public void dispose() {
        super.dispose();
    }

    private class NewRowAction
    extends Action {
        public NewRowAction() {
            super("");
            this.setToolTipText(HibernateConsoleMessages.QueryParametersPage_add_query_parameter_tooltip);
            this.setImageDescriptor(EclipseImages.getImageDescriptor("NEW_PARAMETER"));
        }

        public void run() {
            ConsoleQueryParameter[] queryParameters = QueryParametersPage.this.model.getQueryParameters();
            HashMap<String, ConsoleQueryParameter> qp = new HashMap<String, ConsoleQueryParameter>();
            int i = 0;
            while (i < queryParameters.length) {
                ConsoleQueryParameter parameter = queryParameters[i];
                qp.put(parameter.getName(), parameter);
                ++i;
            }
            QueryParametersPage.this.model.clear();
            String queryString = QueryParametersPage.this.editor.getQueryString();
            ConsoleQueryParameter cqp = null;
            int[] positions = StringHelper.locateUnquoted((String)queryString, (char)'?');
            int i2 = 0;
            while (i2 < positions.length) {
                cqp = (ConsoleQueryParameter)qp.get("" + i2);
                if (cqp == null) {
                    cqp = QueryParametersPage.this.model.createUniqueParameter("" + i2);
                }
                QueryParametersPage.this.model.addParameter(cqp);
                ++i2;
            }
            StringTokenizer st = new StringTokenizer(queryString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\");
            HashSet<String> result = new HashSet<String>();
            while (st.hasMoreTokens()) {
                String string = st.nextToken();
                if (!string.startsWith(":")) continue;
                result.add(string.substring(1));
            }
            for (String paramName : result) {
                cqp = (ConsoleQueryParameter)qp.get(paramName);
                if (cqp == null) {
                    cqp = QueryParametersPage.this.model.createUniqueParameter(paramName);
                }
                QueryParametersPage.this.model.addParameter(cqp);
            }
        }
    }

    private class RemoveRowAction
    extends Action {
        public RemoveRowAction() {
            super("");
            this.setToolTipText(HibernateConsoleMessages.QueryParametersPage_remove_query_parameter_tooltip);
            this.setImageDescriptor(QueryParametersPage.this.getSite().getWorkbenchWindow().getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        }

        public void run() {
            Object firstElement = ((IStructuredSelection)QueryParametersPage.this.tableViewer.getSelection()).getFirstElement();
            if (firstElement != null) {
                QueryParametersPage.this.tableViewer.cancelEditing();
                QueryParametersPage.this.model.removeParameter((ConsoleQueryParameter)firstElement);
                if (QueryParametersPage.this.model.getParameterCount() > 0) {
                    QueryParametersPage.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)QueryParametersPage.this.model.getQueryParameters()[0]));
                }
            }
        }
    }

    private class ToggleActive
    extends Action {
        public ToggleActive() {
            super("");
            this.setToolTipText(HibernateConsoleMessages.QueryParametersPage_enable_disable_parameters_tooltip);
            this.setChecked(false);
            this.setImageDescriptor(EclipseImages.getImageDescriptor("IGNORE_PARAMETER"));
        }

        public void run() {
            QueryParametersPage.this.model.setIgnoreParameters(this.isChecked());
            this.setChecked(QueryParametersPage.this.model.ignoreParameters());
        }
    }
}

