/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.OpenMappingUtilsEjb3;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.util.XMLHelper;
import org.hibernate.util.xpl.StringHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class OpenMappingUtils {
    public static final String HIBERNATE_TAG_CLASS = "class";
    public static final String HIBERNATE_TAG_TABLE = "table";
    public static final String HIBERNATE_TAG_SUBCLASS = "subclass";
    public static final String HIBERNATE_TAG_JOINED_SUBCLASS = "joined-subclass";
    public static final String HIBERNATE_TAG_UNION_SUBCLASS = "union-subclass";
    public static final String HIBERNATE_TAG_NAME = "name";
    public static final String HIBERNATE_TAG_ENTITY_NAME = "entity-name";
    public static final String HIBERNATE_TAG_SESSION_FACTORY = "session-factory";
    public static final String HIBERNATE_TAG_MAPPING = "mapping";
    public static final String HIBERNATE_TAG_RESOURCE = "resource";
    public static final String HIBERNATE_TAG_CATALOG = "catalog";
    public static final String HIBERNATE_TAG_SCHEMA = "schema";
    public static final String HIBERNATE_TAG_KEY = "key";
    public static final String HIBERNATE_TAG_MANY2ONE = "many-to-one";
    public static final String HIBERNATE_TAG_PROPERTY = "property";
    public static final String EJB_TAG_ENTITY = "entity";
    public static final String EJB_TAG_CLASS = "class";
    public static final String EJB_TAG_MAPPED_SUPERCLASS = "mapped-superclass";
    public static final String EJB_TAG_COLUMN = "column";
    public static final String EJB_TAG_ID = "id";
    public static final String EJB_TAG_BASIC = "basic";
    private static String[][] classPairs = new String[][]{{"class", "name"}, {"class", "entity-name"}, {"entity", "class"}, {"entity", "name"}};
    private static String[][] subClassPairs = new String[][]{{"subclass", "name"}, {"subclass", "entity-name"}, {"joined-subclass", "name"}, {"joined-subclass", "entity-name"}, {"union-subclass", "name"}, {"union-subclass", "entity-name"}, {"entity", "class"}, {"entity", "name"}};
    private static String[][] persistentClassPairs = new String[][]{{"class", "name"}, {"class", "entity-name"}, {"entity", "name"}, {"entity", "class"}, {"mapped-superclass", "name"}, {"mapped-superclass", "class"}};
    private static String[][] tablePairs = new String[][]{{"table", "name"}, {"class", "name"}, {"class", "entity-name"}, {"entity", "name"}, {"entity", "class"}};
    private static String[][] columnPairs = new String[][]{{"column", "name"}, {"id", "column"}, {"many-to-one", "column"}, {"key", "column"}, {"id", "name"}, {"many-to-one", "name"}, {"basic", "name"}, {"property", "name"}};

    private OpenMappingUtils() {
    }

    public static String getPersistentClassName(PersistentClass rootClass) {
        if (rootClass == null) {
            return "";
        }
        return rootClass.getEntityName() != null ? rootClass.getEntityName() : rootClass.getClassName();
    }

    public static String getTableName(String catalog, String schema, String name) {
        return String.valueOf(catalog != null ? String.valueOf(catalog) + '.' : "") + (schema != null ? String.valueOf(schema) + '.' : "") + name;
    }

    public static String getTableName(Table table) {
        return OpenMappingUtils.getTableName(table.getCatalog(), table.getSchema(), table.getName());
    }

    public static boolean hasConfigXMLMappingClassAnnotation(ConsoleConfiguration consoleConfig, PersistentClass rootClass) {
        File configXMLFile = consoleConfig.getPreferences().getConfigXMLFile();
        if (configXMLFile == null) {
            return true;
        }
        EntityResolver entityResolver = consoleConfig.getConfiguration().getEntityResolver();
        Document doc = OpenMappingUtils.getDocument(configXMLFile, entityResolver);
        return OpenMappingUtils.getElements(doc, HIBERNATE_TAG_MAPPING, "class", OpenMappingUtils.getPersistentClassName(rootClass)).hasNext();
    }

    public static boolean elementInFile(ConsoleConfiguration consoleConfig, IFile file, Object element) {
        boolean res = false;
        if (element instanceof RootClass) {
            res = OpenMappingUtils.rootClassInFile(consoleConfig, file, (RootClass)element);
        } else if (element instanceof Subclass) {
            res = OpenMappingUtils.subclassInFile(consoleConfig, file, (Subclass)element);
        } else if (element instanceof Table) {
            res = OpenMappingUtils.tableInFile(consoleConfig, file, (Table)element);
        }
        return res;
    }

    public static boolean rootClassInFile(ConsoleConfiguration consoleConfig, IFile file, RootClass rootClass) {
        EntityResolver entityResolver = consoleConfig.getConfiguration().getEntityResolver();
        Document doc = OpenMappingUtils.getDocument(file.getLocation().toFile(), entityResolver);
        String clName = OpenMappingUtils.getPersistentClassName((PersistentClass)rootClass);
        String clNameUnq = StringHelper.unqualify((String)clName);
        boolean res = false;
        int i = 0;
        while (i < classPairs.length) {
            res = OpenMappingUtils.getElements(doc, classPairs[i][0], classPairs[i][1], clNameUnq).hasNext();
            if (res || (res = OpenMappingUtils.getElements(doc, classPairs[i][0], classPairs[i][1], clName).hasNext())) break;
            ++i;
        }
        return res;
    }

    public static boolean subclassInFile(ConsoleConfiguration consoleConfig, IFile file, Subclass subclass) {
        EntityResolver entityResolver = consoleConfig.getConfiguration().getEntityResolver();
        Document doc = OpenMappingUtils.getDocument(file.getLocation().toFile(), entityResolver);
        String clName = OpenMappingUtils.getPersistentClassName((PersistentClass)subclass);
        String clNameUnq = StringHelper.unqualify((String)clName);
        boolean res = false;
        int i = 0;
        while (i < subClassPairs.length) {
            res = OpenMappingUtils.getElements(doc, subClassPairs[i][0], subClassPairs[i][1], clNameUnq).hasNext();
            if (res || (res = OpenMappingUtils.getElements(doc, subClassPairs[i][0], subClassPairs[i][1], clName).hasNext())) break;
            ++i;
        }
        return res;
    }

    public static boolean tableInFile(ConsoleConfiguration consoleConfig, IFile file, Table table) {
        Element element2;
        EntityResolver entityResolver = consoleConfig.getConfiguration().getEntityResolver();
        Document doc = OpenMappingUtils.getDocument(file.getLocation().toFile(), entityResolver);
        Iterator<Element> classes = OpenMappingUtils.getElements(doc, "class");
        boolean res = false;
        while (classes.hasNext()) {
            Attribute classNameAttr;
            element2 = classes.next();
            Attribute tableAttr = element2.attribute(HIBERNATE_TAG_TABLE);
            if (tableAttr != null) {
                String name;
                String schema;
                String catalog;
                Attribute schemaAttr;
                Attribute catalogAttr = element2.attribute(HIBERNATE_TAG_CATALOG);
                if (catalogAttr == null) {
                    catalogAttr = doc.getRootElement().attribute(HIBERNATE_TAG_CATALOG);
                }
                if ((schemaAttr = element2.attribute(HIBERNATE_TAG_SCHEMA)) == null) {
                    schemaAttr = doc.getRootElement().attribute(HIBERNATE_TAG_SCHEMA);
                }
                if (OpenMappingUtils.getTableName(catalog = catalogAttr != null ? catalogAttr.getValue() : null, schema = schemaAttr != null ? schemaAttr.getValue() : null, name = tableAttr.getValue()).equals(OpenMappingUtils.getTableName(table))) {
                    res = true;
                    break;
                }
            }
            if ((classNameAttr = element2.attribute(HIBERNATE_TAG_NAME)) == null) {
                classNameAttr = element2.attribute(HIBERNATE_TAG_ENTITY_NAME);
            }
            if (classNameAttr == null) continue;
            String physicalTableName = consoleConfig.getConfiguration().getNamingStrategy().classToTableName(classNameAttr.getValue());
            if (!table.getName().equals(physicalTableName)) continue;
            res = true;
            break;
        }
        if (!res && OpenMappingUtils.getElements(doc, HIBERNATE_TAG_TABLE, table.getName()).hasNext()) {
            res = true;
        }
        if (!res) {
            classes = OpenMappingUtils.getElements(doc, EJB_TAG_ENTITY);
            block1: while (classes.hasNext() && !res) {
                element2 = classes.next();
                for (Element element2 : element2.elements(HIBERNATE_TAG_TABLE)) {
                    String name;
                    String schema;
                    String catalog;
                    Attribute schemaAttr;
                    Attribute tableAttr = element2.attribute(HIBERNATE_TAG_NAME);
                    if (tableAttr == null) continue;
                    Attribute catalogAttr = element2.attribute(HIBERNATE_TAG_CATALOG);
                    if (catalogAttr == null) {
                        catalogAttr = doc.getRootElement().attribute(HIBERNATE_TAG_CATALOG);
                    }
                    if ((schemaAttr = element2.attribute(HIBERNATE_TAG_SCHEMA)) == null) {
                        schemaAttr = doc.getRootElement().attribute(HIBERNATE_TAG_SCHEMA);
                    }
                    if (!OpenMappingUtils.getTableName(catalog = catalogAttr != null ? catalogAttr.getValue() : null, schema = schemaAttr != null ? schemaAttr.getValue() : null, name = tableAttr.getValue()).equals(OpenMappingUtils.getTableName(table))) continue;
                    res = true;
                    continue block1;
                }
            }
        }
        return res;
    }

    private static Iterator<Element> getElements(Document doc, String elementName) {
        return OpenMappingUtils.getElements(doc, elementName, null, null);
    }

    private static Iterator<Element> getElements(Document doc, String attrName, String attrValue) {
        return OpenMappingUtils.getElements(doc, null, attrName, attrValue);
    }

    private static Iterator<Element> getElements(Document doc, String elementName, String attrName, String attrValue) {
        LVS visitor = new LVS(elementName, attrName, attrValue);
        doc.accept((Visitor)visitor);
        return visitor.iterator();
    }

    public static Document getDocument(File configXMLFile, EntityResolver entityResolver) {
        Document doc = null;
        if (configXMLFile == null) {
            return doc;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configXMLFile);
        }
        catch (FileNotFoundException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Configuration file not found", e);
        }
        try {
            try {
                ArrayList errors = new ArrayList();
                XMLHelper helper = new XMLHelper();
                SAXReader saxReader = helper.createSAXReader(configXMLFile.getPath(), errors, entityResolver);
                saxReader.setValidation(false);
                doc = saxReader.read(new InputSource(stream));
                if (errors.size() != 0) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("invalid configuration", errors.toArray(new Throwable[0]));
                }
            }
            catch (DocumentException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Could not parse configuration", e);
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException ioe) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("could not close input stream for", ioe);
                }
            }
        }
        finally {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException ioe) {
                HibernateConsolePlugin.getDefault().logErrorMessage("could not close input stream for", ioe);
            }
        }
        return doc;
    }

    public static PackageFragmentRoot[] getCCPackageFragmentRoots(ConsoleConfiguration consoleConfiguration) {
        IJavaProject[] projs = ProjectUtils.findJavaProjects(consoleConfiguration);
        ArrayList<PackageFragmentRoot> res = new ArrayList<PackageFragmentRoot>();
        try {
            int i = 0;
            while (i < projs.length) {
                IPackageFragmentRoot[] pfrs = projs[i].getAllPackageFragmentRoots();
                int j = 0;
                while (j < pfrs.length) {
                    if (pfrs[j].getClass() == PackageFragmentRoot.class) {
                        res.add((PackageFragmentRoot)pfrs[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.OpenFileActionUtils_problems_while_get_project_package_fragment_roots, e);
        }
        return res.toArray(new PackageFragmentRoot[0]);
    }

    public static IFile searchInMappingFiles(ConsoleConfiguration consoleConfig, Object element) {
        EntityResolver entityResolver;
        Document doc;
        IFile file = null;
        if (consoleConfig == null) {
            return file;
        }
        File configXMLFile = consoleConfig.getConfigXMLFile();
        if (!consoleConfig.hasConfiguration()) {
            consoleConfig.build();
            consoleConfig.buildSessionFactory();
        }
        if ((doc = OpenMappingUtils.getDocument(configXMLFile, entityResolver = consoleConfig.getConfiguration().getEntityResolver())) == null) {
            return file;
        }
        PackageFragmentRoot[] packageFragments = OpenMappingUtils.getCCPackageFragmentRoots(consoleConfig);
        ArrayList<IPath> paths = new ArrayList<IPath>();
        int i = 0;
        while (i < packageFragments.length) {
            paths.add(packageFragments[i].getPath());
            ++i;
        }
        paths.add(Path.fromOSString((String)configXMLFile.getParent()));
        i = 0;
        while (i < paths.size() && file == null) {
            Element sfNode = doc.getRootElement().element(HIBERNATE_TAG_SESSION_FACTORY);
            Iterator elements = sfNode.elements(HIBERNATE_TAG_MAPPING).iterator();
            while (elements.hasNext() && file == null) {
                Element subelement = (Element)elements.next();
                Attribute resourceAttr = subelement.attribute(HIBERNATE_TAG_RESOURCE);
                if (resourceAttr == null) continue;
                IPath path = ((IPath)paths.get(i)).append(resourceAttr.getValue().trim());
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (file == null || !file.exists()) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
                }
                if (file != null && file.exists() && OpenMappingUtils.elementInFile(consoleConfig, file, element)) break;
                file = null;
            }
            ++i;
        }
        return file;
    }

    public static IFile searchInAdditionalMappingFiles(ConsoleConfiguration consoleConfig, Object element) {
        IFile file = null;
        if (consoleConfig == null) {
            return file;
        }
        File[] files = consoleConfig.getPreferences().getMappingFiles();
        int i = 0;
        while (i < files.length) {
            File fileTmp = files[i];
            if (fileTmp != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileTmp.getPath()))) != null) {
                if (file.exists() && OpenMappingUtils.elementInFile(consoleConfig, file, element)) break;
                file = null;
            }
            ++i;
        }
        return file;
    }

    public static IFile searchInEjb3MappingFiles(ConsoleConfiguration consoleConfig, Object element) {
        IFile file = null;
        if (consoleConfig == null) {
            return file;
        }
        final ConsoleConfiguration cc2 = consoleConfig;
        List documentPaths = (List)consoleConfig.execute(new ExecutionContext.Command(){

            public Object execute() {
                return OpenMappingUtilsEjb3.enumDocuments(cc2);
            }
        });
        if (documentPaths == null) {
            return file;
        }
        IJavaProject[] projs = ProjectUtils.findJavaProjects(consoleConfig);
        ArrayList<IPath> pathsSrc = new ArrayList<IPath>();
        ArrayList<IPath> pathsOut = new ArrayList<IPath>();
        ArrayList<IPath> pathsFull = new ArrayList<IPath>();
        int i = 0;
        while (i < projs.length) {
            IJavaProject proj = projs[i];
            IPath projPathFull = proj.getResource().getLocation();
            IPath projPath = proj.getPath();
            IPath projPathOut = null;
            try {
                projPathOut = proj.getOutputLocation();
                projPathOut = projPathOut.makeRelativeTo(projPath);
            }
            catch (JavaModelException javaModelException) {}
            IPackageFragmentRoot[] pfrs = new IPackageFragmentRoot[]{};
            try {
                pfrs = proj.getAllPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {}
            int j = 0;
            while (j < pfrs.length) {
                if (pfrs[j].getClass() == PackageFragmentRoot.class) {
                    IPath pathSrc = ((PackageFragmentRoot)pfrs[j]).getPath();
                    IPath pathOut = projPathOut;
                    IPath pathFull = projPathFull;
                    pathsSrc.add(pathSrc);
                    pathsOut.add(pathOut);
                    pathsFull.add(pathFull);
                }
                ++j;
            }
            ++i;
        }
        int scanSize = Math.min(pathsSrc.size(), pathsOut.size());
        scanSize = Math.min(pathsFull.size(), scanSize);
        int i2 = 0;
        while (i2 < scanSize && file == null) {
            IPath pathSrc = (IPath)pathsSrc.get(i2);
            IPath pathOut = (IPath)pathsOut.get(i2);
            IPath pathFull = (IPath)pathsFull.get(i2);
            Iterator it = documentPaths.iterator();
            while (it.hasNext() && file == null) {
                String docPath = (String)it.next();
                IPath path2DocFull = Path.fromOSString((String)docPath);
                IPath resPath = path2DocFull.makeRelativeTo(pathFull);
                if (pathOut != null) {
                    resPath = resPath.makeRelativeTo(pathOut);
                }
                resPath = pathSrc.append(resPath);
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(resPath);
                if (file == null || !file.exists()) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(resPath);
                }
                if (file != null && file.exists() && OpenMappingUtils.elementInFile(consoleConfig, file, element)) break;
                file = null;
            }
            ++i2;
        }
        return file;
    }

    public static IFile searchFileToOpen(ConsoleConfiguration consoleConfig, Object element) {
        IFile file = OpenMappingUtils.searchInMappingFiles(consoleConfig, element);
        if (file == null) {
            file = OpenMappingUtils.searchInAdditionalMappingFiles(consoleConfig, element);
        }
        if (file == null) {
            file = OpenMappingUtils.searchInEjb3MappingFiles(consoleConfig, element);
        }
        return file;
    }

    public static FindReplaceDocumentAdapter createFindDocAdapter(ITextEditor textEditor) {
        IDocument document = null;
        if (textEditor.getDocumentProvider() != null) {
            document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        }
        if (document == null) {
            return null;
        }
        return new FindReplaceDocumentAdapter(document);
    }

    public static IEditorPart openFileInEditor(IFile file) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return IDE.openEditor((IWorkbenchPage)page, (IFile)file);
    }

    public static IRegion findSelectRegion(IJavaProject proj, FindReplaceDocumentAdapter findAdapter, Object selection) {
        IRegion selectRegion = null;
        if (selection instanceof RootClass || selection instanceof Subclass) {
            selectRegion = OpenMappingUtils.findSelectRegion(proj, findAdapter, (PersistentClass)selection);
        } else if (selection instanceof Property) {
            selectRegion = OpenMappingUtils.findSelectRegion(proj, findAdapter, (Property)selection);
        } else if (selection instanceof Table) {
            selectRegion = OpenMappingUtils.findSelectRegion(proj, findAdapter, (Table)selection);
        } else if (selection instanceof Column) {
            selectRegion = OpenMappingUtils.findSelectRegion(proj, findAdapter, (Column)selection);
        }
        return selectRegion;
    }

    public static IRegion findSelectRegion(IJavaProject proj, FindReplaceDocumentAdapter findAdapter, Property property) {
        Assert.isNotNull((Object)property.getPersistentClass());
        IRegion classRegion = OpenMappingUtils.findSelectRegion(proj, findAdapter, property.getPersistentClass());
        IRegion res = null;
        if (classRegion == null) {
            return res;
        }
        res = classRegion;
        Cfg2HbmTool tool = new Cfg2HbmTool();
        PersistentClass persistentClass = property.getPersistentClass();
        String tagName = tool.getTag(persistentClass);
        IRegion finalRegion = null;
        IRegion propRegion = null;
        int startOffset = classRegion.getOffset() + classRegion.getLength();
        try {
            String tagClose = "</" + tagName;
            finalRegion = findAdapter.find(startOffset, tagClose, true, true, false, false);
            if (finalRegion == null) {
                tagClose = "</entity";
                finalRegion = findAdapter.find(startOffset, tagClose, true, true, false, false);
            }
            if ((propRegion = findAdapter.find(startOffset, OpenMappingUtils.generateHbmPropertyPattern(property), true, true, false, true)) == null) {
                propRegion = findAdapter.find(startOffset, OpenMappingUtils.generateEjbPropertyPattern(property), true, true, false, true);
            }
        }
        catch (BadLocationException badLocationException) {}
        String className = persistentClass.getClassName();
        while (propRegion == null) {
            if ((className = ProjectUtils.getParentTypename(proj, className)) == null || (classRegion = OpenMappingUtils.findSelectRegion(proj, findAdapter, className)) == null) break;
            startOffset = classRegion.getOffset() + classRegion.getLength();
            try {
                String tagClose = "</mapped-superclass";
                finalRegion = findAdapter.find(startOffset, tagClose, true, true, false, false);
                propRegion = findAdapter.find(startOffset, OpenMappingUtils.generateEjbPropertyPattern(property), true, true, false, true);
            }
            catch (BadLocationException badLocationException) {}
        }
        if (propRegion != null) {
            int length = property.getName().length();
            int offset = propRegion.getOffset() + propRegion.getLength() - length - 1;
            res = new Region(offset, length);
            if (finalRegion != null && propRegion.getOffset() > finalRegion.getOffset()) {
                res = null;
            }
        }
        return res;
    }

    public static IRegion findSelectRegion(IJavaProject proj, FindReplaceDocumentAdapter findAdapter, PersistentClass persistentClass) {
        Region res = null;
        String[] classPatterns = OpenMappingUtils.generatePersistentClassPatterns(persistentClass);
        IRegion classRegion = null;
        try {
            int i = 0;
            while (classRegion == null && i < classPatterns.length) {
                classRegion = findAdapter.find(0, classPatterns[i], true, true, false, true);
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (classRegion != null) {
            int length = persistentClass.getNodeName().length();
            int offset = classRegion.getOffset() + classRegion.getLength() - length - 1;
            res = new Region(offset, length);
        }
        return res;
    }

    public static IRegion findSelectRegion(IJavaProject proj, FindReplaceDocumentAdapter findAdapter, String className) {
        Region res = null;
        String[] classPatterns = OpenMappingUtils.generatePersistentClassPatterns(className);
        IRegion classRegion = null;
        try {
            int i = 0;
            while (classRegion == null && i < classPatterns.length) {
                classRegion = findAdapter.find(0, classPatterns[i], true, true, false, true);
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (classRegion != null) {
            int length = OpenMappingUtils.getShortClassName(className).length();
            int offset = classRegion.getOffset() + classRegion.getLength() - length - 1;
            res = new Region(offset, length);
        }
        return res;
    }

    public static IRegion findSelectRegion(IJavaProject proj, FindReplaceDocumentAdapter findAdapter, Table table) {
        Region res = null;
        String[] tablePatterns = OpenMappingUtils.generateTablePatterns(table.getName());
        IRegion tableRegion = null;
        try {
            int i = 0;
            while (tableRegion == null && i < tablePatterns.length) {
                tableRegion = findAdapter.find(0, tablePatterns[i], true, true, false, true);
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (tableRegion != null) {
            int length = table.getName().length();
            int offset = tableRegion.getOffset() + tableRegion.getLength() - length - 1;
            res = new Region(offset, length);
        }
        return res;
    }

    public static IRegion findSelectRegion(IJavaProject proj, FindReplaceDocumentAdapter findAdapter, Column column) {
        Region res = null;
        String[] columnPatterns = OpenMappingUtils.generateColumnPatterns(column.getName());
        IRegion columnRegion = null;
        try {
            int i = 0;
            while (columnRegion == null && i < columnPatterns.length) {
                columnRegion = findAdapter.find(0, columnPatterns[i], true, true, false, true);
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (columnRegion != null) {
            int length = column.getName().length();
            int offset = columnRegion.getOffset() + columnRegion.getLength() - length - 1;
            res = new Region(offset, length);
        }
        return res;
    }

    public static String createPattern(String tagName, String name, String value) {
        StringBuffer pattern = new StringBuffer("<");
        pattern.append(tagName);
        pattern.append("[\\s]+[.[^>]]*");
        pattern.append(name);
        pattern.append("[\\s]*=[\\s]*\"");
        pattern.append(value);
        pattern.append('\"');
        return pattern.toString();
    }

    public static String getShortClassName(String fullClassName) {
        return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
    }

    public static String[] generatePersistentClassPatterns(PersistentClass persClass) {
        String tagName;
        String fullClassName = null;
        String shortClassName = null;
        fullClassName = persClass.getEntityName() != null ? persClass.getEntityName() : persClass.getClassName();
        shortClassName = OpenMappingUtils.getShortClassName(fullClassName);
        Cfg2HbmTool tool = new Cfg2HbmTool();
        OpenMappingUtils.persistentClassPairs[0][0] = tagName = tool.getTag(persClass);
        OpenMappingUtils.persistentClassPairs[1][0] = tagName;
        ArrayList<String> patterns = new ArrayList<String>();
        int i = 0;
        while (i < persistentClassPairs.length) {
            patterns.add(OpenMappingUtils.createPattern(persistentClassPairs[i][0], persistentClassPairs[i][1], shortClassName));
            patterns.add(OpenMappingUtils.createPattern(persistentClassPairs[i][0], persistentClassPairs[i][1], fullClassName));
            ++i;
        }
        return patterns.toArray(new String[0]);
    }

    public static String[] generatePersistentClassPatterns(String fullClassName) {
        String shortClassName = OpenMappingUtils.getShortClassName(fullClassName);
        ArrayList<String> patterns = new ArrayList<String>();
        int i = 0;
        while (i < persistentClassPairs.length) {
            patterns.add(OpenMappingUtils.createPattern(persistentClassPairs[i][0], persistentClassPairs[i][1], shortClassName));
            patterns.add(OpenMappingUtils.createPattern(persistentClassPairs[i][0], persistentClassPairs[i][1], fullClassName));
            ++i;
        }
        return patterns.toArray(new String[0]);
    }

    public static String[] generateTablePatterns(String tableName) {
        ArrayList<String> patterns = new ArrayList<String>();
        int i = 0;
        while (i < tablePairs.length) {
            patterns.add(OpenMappingUtils.createPattern(tablePairs[i][0], tablePairs[i][1], tableName));
            ++i;
        }
        return patterns.toArray(new String[0]);
    }

    public static String[] generateColumnPatterns(String columnName) {
        ArrayList<String> patterns = new ArrayList<String>();
        int i = 0;
        while (i < columnPairs.length) {
            patterns.add(OpenMappingUtils.createPattern(columnPairs[i][0], columnPairs[i][1], columnName));
            ++i;
        }
        return patterns.toArray(new String[0]);
    }

    public static String generateHbmPropertyPattern(Property property) {
        Cfg2HbmTool tool = new Cfg2HbmTool();
        String toolTag = "";
        PersistentClass pc = property.getPersistentClass();
        if (pc != null && pc.getIdentifierProperty() == property) {
            toolTag = property.isComposite() ? "composite-id" : EJB_TAG_ID;
        } else {
            toolTag = tool.getTag(property);
            if ("component".equals(toolTag) && "embedded".equals(property.getPropertyAccessorName())) {
                toolTag = "properties";
            }
        }
        return OpenMappingUtils.createPattern(toolTag, HIBERNATE_TAG_NAME, property.getName());
    }

    public static String generateOrmEmbeddablePropertyPattern(Property property) {
        return OpenMappingUtils.createPattern(EJB_TAG_BASIC, HIBERNATE_TAG_NAME, property.getName());
    }

    public static String generateEjbPropertyPattern(Property property) {
        String toolTag = "";
        PersistentClass pc = property.getPersistentClass();
        if (pc != null && pc.getIdentifierProperty() == property) {
            toolTag = property.isComposite() ? "embedded-id" : EJB_TAG_ID;
        } else {
            Value value = property.getValue();
            toolTag = EJB_TAG_BASIC;
            if (!value.isSimpleValue() && value instanceof Collection) {
                value = ((Collection)value).getElement();
            }
            if (value instanceof OneToMany) {
                toolTag = "one-to-many";
            } else if (value instanceof ManyToOne) {
                toolTag = "many-to-((one)|(many))";
            } else if (value instanceof OneToOne) {
                toolTag = "one-to-one";
            } else if (value instanceof Map) {
                toolTag = "many-to-many";
            } else if (value instanceof Component && ((Component)value).isEmbedded()) {
                toolTag = "embedded";
            }
            if (value instanceof ToOne && ((ToOne)value).isEmbedded()) {
                toolTag = "embedded";
            }
        }
        return OpenMappingUtils.createPattern(toolTag, HIBERNATE_TAG_NAME, property.getName());
    }

    public static ITextEditor[] getTextEditors(IEditorPart editorPart) {
        ITextEditor[] res = new ITextEditor[]{};
        if (editorPart instanceof MultiPageEditorPart) {
            ArrayList<ITextEditor> testEditors = new ArrayList<ITextEditor>();
            IEditorPart[] editors = ((MultiPageEditorPart)editorPart).findEditors(editorPart.getEditorInput());
            int i = 0;
            while (i < editors.length) {
                if (editors[i] instanceof ITextEditor) {
                    testEditors.add((ITextEditor)editors[i]);
                }
                ++i;
            }
            res = testEditors.toArray(res);
        } else if (editorPart instanceof ITextEditor) {
            res = new ITextEditor[]{(ITextEditor)editorPart};
        }
        return res;
    }

    private static class LVS
    extends VisitorSupport {
        private String nodeName;
        private String attrName;
        private String attrValue;
        private List<Element> ret = new ArrayList<Element>();

        public LVS(String nodeName, String attrName, String attrValue) {
            this.nodeName = nodeName;
            this.attrName = attrName;
            this.attrValue = attrValue;
        }

        public void visit(Element element) {
            if (this.nodeName == null) {
                if (this.attrName != null && this.attrValue != null && this.inspectAttributeForValue(element, this.attrName, this.attrValue)) {
                    this.ret.add(element);
                }
            } else if (this.nodeName.equals(element.getName())) {
                if (this.attrName != null) {
                    if (this.inspectAttributeForValue(element, this.attrName, this.attrValue)) {
                        this.ret.add(element);
                    }
                } else {
                    this.ret.add(element);
                }
            }
        }

        public Iterator<Element> iterator() {
            return this.ret.iterator();
        }

        protected boolean inspectAttributeForValue(Element element, String attrName, String checkValue) {
            Attribute attr = element.attribute(attrName);
            if (attr != null && checkValue.equals(attr.getValue())) {
                return checkValue.equals(attr.getValue());
            }
            return false;
        }
    }
}

