/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.io.FileNotFoundException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.OpenSourceAction;
import org.hibernate.eclipse.console.utils.OpenMappingUtils;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;

public class OpenMappingAction
extends SelectionListenerAction {
    public static final String OPENMAPPING_ACTIONID = "actionid.openmapping";
    private final String imageFilePath = "icons/images/mapping.gif";

    public OpenMappingAction() {
        super(HibernateConsoleMessages.OpenMappingAction_open_mapping_file);
        this.setToolTipText(HibernateConsoleMessages.OpenMappingAction_open_mapping_file);
        this.setEnabled(true);
        this.setImageDescriptor(HibernateConsolePlugin.getImageDescriptor("icons/images/mapping.gif"));
        this.setId(OPENMAPPING_ACTIONID);
    }

    public void run() {
        IStructuredSelection sel = this.getStructuredSelection();
        if (!(sel instanceof TreeSelection)) {
            return;
        }
        TreePath[] paths = ((TreeSelection)sel).getPaths();
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            ConsoleConfiguration consoleConfig = (ConsoleConfiguration)path.getSegment(0);
            try {
                OpenMappingAction.run(consoleConfig, path);
            }
            catch (JavaModelException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.OpenMappingAction_cannot_find_mapping_file, e);
            }
            catch (PartInitException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.OpenMappingAction_cannot_open_mapping_file, e);
            }
            catch (FileNotFoundException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.OpenMappingAction_cannot_find_mapping_file, e);
            }
            ++i;
        }
    }

    public static IEditorPart run(ConsoleConfiguration consoleConfig, TreePath path) throws PartInitException, JavaModelException, FileNotFoundException {
        Property propertySel;
        PersistentClass persClass;
        boolean isPropertySel;
        boolean bl = isPropertySel = path.getLastSegment().getClass() == Property.class;
        if (isPropertySel && ((persClass = (propertySel = (Property)path.getLastSegment()).getPersistentClass()) == null || RootClass.class.isAssignableFrom(persClass.getClass()) && persClass.getClass() != RootClass.class)) {
            Property parentProp = (Property)path.getParentPath().getLastSegment();
            return OpenMappingAction.run(consoleConfig, propertySel, parentProp);
        }
        return OpenMappingAction.run(consoleConfig, path.getLastSegment(), null);
    }

    public static IEditorPart run(ConsoleConfiguration consoleConfig, Object selection, Object selectionParent) throws PartInitException, JavaModelException, FileNotFoundException {
        boolean updateRes;
        IEditorPart editorPart = null;
        IFile file = null;
        if (selection instanceof Property) {
            Property p = (Property)selection;
            if (p.getPersistentClass() != null) {
                file = OpenMappingUtils.searchFileToOpen(consoleConfig, p.getPersistentClass());
            }
        } else {
            file = selectionParent != null ? OpenMappingUtils.searchFileToOpen(consoleConfig, selectionParent) : OpenMappingUtils.searchFileToOpen(consoleConfig, selection);
        }
        if (file != null && !(updateRes = OpenMappingAction.updateEditorSelection(editorPart = OpenMappingUtils.openFileInEditor(file), selection)) && selectionParent != null) {
            updateRes = OpenMappingAction.updateEditorSelection(editorPart, selectionParent);
        }
        if (editorPart == null) {
            Property p;
            PersistentClass rootClass = null;
            if (selection instanceof PersistentClass) {
                rootClass = (PersistentClass)selection;
            } else if (selection instanceof Property && (p = (Property)selection).getPersistentClass() != null) {
                rootClass = p.getPersistentClass();
            }
            if (rootClass != null && OpenMappingUtils.hasConfigXMLMappingClassAnnotation(consoleConfig, rootClass)) {
                String fullyQualifiedName = rootClass.getClassName();
                editorPart = OpenSourceAction.run(consoleConfig, selection, fullyQualifiedName);
            }
        }
        if (editorPart == null) {
            String title = HibernateConsoleMessages.OpenMappingAction_open_mapping_file;
            String msg = NLS.bind((String)HibernateConsoleMessages.OpenMappingAction_mapping_for_not_found, (Object)selection);
            MessageDialog.openError(null, (String)title, (String)msg);
            throw new FileNotFoundException(msg);
        }
        return editorPart;
    }

    public static IEditorPart run(ConsoleConfiguration consoleConfig, Property compositeProperty, Property parentProperty) throws PartInitException, JavaModelException, FileNotFoundException {
        PersistentClass rootClass = parentProperty.getPersistentClass();
        IFile file = OpenMappingUtils.searchFileToOpen(consoleConfig, rootClass);
        IEditorPart editorPart = null;
        if (file != null) {
            editorPart = OpenMappingUtils.openFileInEditor(file);
            OpenMappingAction.updateEditorSelection(editorPart, compositeProperty, parentProperty);
        }
        if (editorPart == null && parentProperty.isComposite() && OpenMappingUtils.hasConfigXMLMappingClassAnnotation(consoleConfig, rootClass)) {
            String fullyQualifiedName = ((Component)parentProperty.getValue()).getComponentClassName();
            editorPart = OpenSourceAction.run(consoleConfig, compositeProperty, fullyQualifiedName);
        }
        if (editorPart == null) {
            String title = HibernateConsoleMessages.OpenMappingAction_open_mapping_file;
            String msg = NLS.bind((String)HibernateConsoleMessages.OpenMappingAction_mapping_file_for_property_not_found, (Object)compositeProperty.getNodeName());
            MessageDialog.openError(null, (String)title, (String)msg);
            throw new FileNotFoundException(msg);
        }
        return editorPart;
    }

    public static boolean updateEditorSelection(IEditorPart editorPart, Object selection) {
        ITextEditor[] textEditors = OpenMappingUtils.getTextEditors(editorPart);
        if (textEditors.length == 0) {
            return false;
        }
        textEditors[0].selectAndReveal(0, 0);
        FindReplaceDocumentAdapter findAdapter = null;
        ITextEditor textEditor = null;
        int i = 0;
        while (i < textEditors.length && findAdapter == null) {
            textEditor = textEditors[i];
            findAdapter = OpenMappingUtils.createFindDocAdapter(textEditor);
            ++i;
        }
        if (findAdapter == null) {
            return false;
        }
        IJavaProject proj = ProjectUtils.findJavaProject(editorPart);
        IRegion selectRegion = OpenMappingUtils.findSelectRegion(proj, findAdapter, selection);
        if (selectRegion != null) {
            if (editorPart instanceof MultiPageEditorPart) {
                ((MultiPageEditorPart)editorPart).setActiveEditor((IEditorPart)textEditor);
            }
            textEditor.selectAndReveal(selectRegion.getOffset(), selectRegion.getLength());
            return true;
        }
        return false;
    }

    public static boolean updateEditorSelection(IEditorPart editorPart, Property compositeProperty, Property parentProperty) {
        ITextEditor[] textEditors = OpenMappingUtils.getTextEditors(editorPart);
        if (textEditors.length == 0) {
            return false;
        }
        textEditors[0].selectAndReveal(0, 0);
        FindReplaceDocumentAdapter findAdapter = null;
        ITextEditor textEditor = null;
        int i = 0;
        while (i < textEditors.length && findAdapter == null) {
            textEditor = textEditors[i];
            findAdapter = OpenMappingUtils.createFindDocAdapter(textEditor);
            ++i;
        }
        if (findAdapter == null) {
            return false;
        }
        IJavaProject proj = ProjectUtils.findJavaProject(editorPart);
        IRegion parentRegion = OpenMappingUtils.findSelectRegion(proj, findAdapter, parentProperty);
        if (parentRegion == null) {
            return false;
        }
        int startOffset = parentRegion.getOffset() + parentRegion.getLength();
        IRegion propRegion = null;
        try {
            String pattern;
            String hbmPropertyPattern = OpenMappingUtils.generateHbmPropertyPattern(compositeProperty);
            propRegion = findAdapter.find(startOffset, hbmPropertyPattern, true, true, false, true);
            PersistentClass rootClass = parentProperty.getPersistentClass();
            if (propRegion == null && parentProperty.isComposite() && (rootClass.getIdentifierProperty() == parentProperty || !rootClass.hasIdentifierProperty()) && (propRegion = findAdapter.find(startOffset, pattern = hbmPropertyPattern.replaceFirst("<property", "<key-property"), true, true, false, true)) == null) {
                pattern = hbmPropertyPattern.replaceFirst("<many-to-one", "<key-many-to-one");
                propRegion = findAdapter.find(startOffset, pattern, true, true, false, true);
            }
        }
        catch (BadLocationException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.OpenMappingAction_selection_not_found, e);
        }
        if (propRegion == null && parentProperty.isComposite()) {
            String[] componentPatterns = new String[]{OpenMappingUtils.createPattern("embeddable", "class", ((Component)parentProperty.getValue()).getComponentClassName()), OpenMappingUtils.createPattern("embeddable", "class", OpenMappingUtils.getShortClassName(((Component)parentProperty.getValue()).getComponentClassName()))};
            IRegion componentRegion = null;
            int i2 = 0;
            while (i2 < componentPatterns.length && componentRegion == null) {
                try {
                    componentRegion = findAdapter.find(0, componentPatterns[i2], true, true, false, true);
                }
                catch (BadLocationException badLocationException) {}
                ++i2;
            }
            if (componentRegion != null) {
                try {
                    propRegion = findAdapter.find(parentRegion.getOffset() + parentRegion.getLength(), OpenMappingUtils.generateOrmEmbeddablePropertyPattern(compositeProperty), true, true, false, true);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        if (propRegion == null) {
            return false;
        }
        int length = compositeProperty.getNodeName().length();
        int offset = propRegion.getOffset() + propRegion.getLength() - length - 1;
        propRegion = new Region(offset, length);
        if (editorPart instanceof MultiPageEditorPart) {
            ((MultiPageEditorPart)editorPart).setActiveEditor((IEditorPart)textEditor);
        }
        textEditor.selectAndReveal(propRegion.getOffset(), propRegion.getLength());
        return true;
    }
}

