/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.ProjectRecord;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;

public class RootRecord
extends AbstractPMDRecord {
    private final IWorkspaceRoot workspaceRoot;
    private AbstractPMDRecord[] children;

    public RootRecord(IWorkspaceRoot iWorkspaceRoot) {
        if (iWorkspaceRoot == null) {
            throw new IllegalArgumentException("roor cannot be null");
        }
        this.workspaceRoot = iWorkspaceRoot;
        this.children = this.createChildren();
    }

    public AbstractPMDRecord getParent() {
        return this;
    }

    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    public IResource getResource() {
        return this.workspaceRoot;
    }

    protected final AbstractPMDRecord[] createChildren() {
        IProject[] iProjectArray = this.workspaceRoot.getProjects();
        ArrayList<ProjectRecord> arrayList = new ArrayList<ProjectRecord>();
        int n = 0;
        while (n < iProjectArray.length) {
            arrayList.add(new ProjectRecord(iProjectArray[n], this));
            ++n;
        }
        return arrayList.toArray(new AbstractPMDRecord[arrayList.size()]);
    }

    public AbstractPMDRecord addResource(IResource iResource) {
        return iResource instanceof IProject ? this.addProject((IProject)iResource) : null;
    }

    public AbstractPMDRecord removeResource(IResource iResource) {
        return iResource instanceof IProject ? this.removeProject((IProject)iResource) : null;
    }

    public String getName() {
        return this.workspaceRoot.getName();
    }

    public int getResourceType() {
        return 8;
    }

    private ProjectRecord addProject(IProject iProject) {
        ProjectRecord projectRecord = null;
        if (iProject.isOpen()) {
            List list = this.getChildrenAsList();
            ProjectRecord projectRecord2 = new ProjectRecord(iProject, this);
            list.add(projectRecord2);
            this.children = new AbstractPMDRecord[list.size()];
            list.toArray(this.children);
            projectRecord = projectRecord2;
        }
        return projectRecord;
    }

    private ProjectRecord removeProject(IProject iProject) {
        ProjectRecord projectRecord = null;
        List list = this.getChildrenAsList();
        int n = 0;
        while (n < list.size() && projectRecord == null) {
            ProjectRecord projectRecord2 = (ProjectRecord)list.get(n);
            IProject iProject2 = (IProject)projectRecord2.getResource();
            if (iProject2.equals((Object)iProject)) {
                list.remove(projectRecord2);
                this.children = new AbstractPMDRecord[list.size()];
                list.toArray(this.children);
                projectRecord = projectRecord2;
            }
            ++n;
        }
        return projectRecord;
    }

    public int getNumberOfViolationsToPriority(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.children.length) {
            n2 += this.children[n3].getNumberOfViolationsToPriority(n, bl);
            ++n3;
        }
        return n2;
    }

    public int getLOC() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.children.length) {
            n += this.children[n2].getLOC();
            ++n2;
        }
        return n;
    }

    public int getNumberOfMethods() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.children.length) {
            n += this.children[n2].getNumberOfMethods();
            ++n2;
        }
        return n;
    }
}

