/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectRecord
extends AbstractPMDRecord {
    private final IProject project;
    private final RootRecord parent;
    private AbstractPMDRecord[] children;

    public ProjectRecord(IProject iProject, RootRecord rootRecord) {
        if (iProject == null) {
            throw new IllegalArgumentException("project cannot be null");
        }
        if (rootRecord == null) {
            throw new IllegalArgumentException("record cannot be null");
        }
        this.project = iProject;
        this.parent = rootRecord;
        this.children = iProject.isAccessible() ? this.createChildren() : AbstractPMDRecord.EMPTY_RECORDS;
    }

    public AbstractPMDRecord getParent() {
        return this.parent;
    }

    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    public IResource getResource() {
        return this.project;
    }

    protected final AbstractPMDRecord[] createChildren() {
        final HashSet hashSet = new HashSet();
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource iResource) throws CoreException {
                    boolean bl = false;
                    switch (iResource.getType()) {
                        case 2: {
                            IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
                            if (iJavaElement == null) {
                                bl = true;
                                break;
                            }
                            if (iJavaElement instanceof IPackageFragmentRoot) {
                                hashSet.addAll(ProjectRecord.this.createPackagesFromFragmentRoot((IPackageFragmentRoot)iJavaElement));
                            } else if (iJavaElement instanceof IPackageFragment && iJavaElement.getParent() instanceof IPackageFragmentRoot) {
                                IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                                hashSet.addAll(ProjectRecord.this.createPackagesFromFragmentRoot((IPackageFragmentRoot)iPackageFragment.getParent()));
                            }
                            bl = false;
                            break;
                        }
                        case 4: {
                            bl = true;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    return bl;
                }
            });
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.core_exception" + this.toString(), coreException);
        }
        return hashSet.toArray(new AbstractPMDRecord[hashSet.size()]);
    }

    protected final Set createPackagesFromFragmentRoot(IPackageFragmentRoot iPackageFragmentRoot) {
        HashSet<PackageRecord> hashSet = new HashSet<PackageRecord>();
        IJavaElement[] iJavaElementArray = null;
        try {
            iJavaElementArray = iPackageFragmentRoot.getChildren();
            int n = 0;
            while (n < iJavaElementArray.length) {
                if (iJavaElementArray[n] instanceof IPackageFragment) {
                    hashSet.add(new PackageRecord((IPackageFragment)iJavaElementArray[n], this));
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            PMDPlugin.getDefault().logError("message.error.javamodel_exception" + this.toString(), javaModelException);
        }
        return hashSet;
    }

    public String getName() {
        return this.project.getName();
    }

    public boolean isProjectOpen() {
        return this.project.isOpen();
    }

    public int getResourceType() {
        return 4;
    }

    public AbstractPMDRecord addResource(IResource iResource) {
        AbstractPMDRecord abstractPMDRecord = null;
        if (iResource instanceof IFile) {
            Object object;
            IJavaElement iJavaElement = JavaCore.create((IResource)iResource.getParent());
            if (iJavaElement instanceof IPackageFragmentRoot) {
                iJavaElement = ((IPackageFragmentRoot)iJavaElement).getPackageFragment("");
            }
            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
            int n = 0;
            while (n < this.children.length && abstractPMDRecord == null) {
                object = (PackageRecord)this.children[n];
                if (((PackageRecord)object).getFragment().equals(iPackageFragment)) {
                    abstractPMDRecord = ((PackageRecord)object).addResource(iResource);
                }
                ++n;
            }
            if (abstractPMDRecord == null) {
                PackageRecord packageRecord = new PackageRecord(iPackageFragment, this);
                object = this.getChildrenAsList();
                object.add(packageRecord);
                this.children = new AbstractPMDRecord[object.size()];
                object.toArray(this.children);
                abstractPMDRecord = packageRecord.addResource(iResource);
            }
        }
        return abstractPMDRecord;
    }

    public AbstractPMDRecord removeResource(IResource iResource) {
        AbstractPMDRecord abstractPMDRecord = null;
        if (iResource instanceof IFile) {
            IJavaElement iJavaElement = JavaCore.create((IResource)iResource.getParent());
            IPackageFragment iPackageFragment = iJavaElement instanceof IPackageFragment ? (IPackageFragment)iJavaElement : ((IPackageFragmentRoot)iJavaElement).getPackageFragment("");
            int n = 0;
            while (n < this.children.length && abstractPMDRecord == null) {
                PackageRecord packageRecord = (PackageRecord)this.children[n];
                if (packageRecord.getFragment().equals(iPackageFragment)) {
                    AbstractPMDRecord abstractPMDRecord2 = packageRecord.removeResource(iResource);
                    if (packageRecord.getChildren().length == 0) {
                        List list = this.getChildrenAsList();
                        list.remove(packageRecord);
                        this.children = new AbstractPMDRecord[list.size()];
                        list.toArray(this.children);
                    }
                    abstractPMDRecord = abstractPMDRecord2;
                }
                ++n;
            }
        }
        return abstractPMDRecord;
    }

    public int getNumberOfViolationsToPriority(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.children.length) {
            n2 += this.children[n3].getNumberOfViolationsToPriority(n, bl);
            ++n3;
        }
        return n2;
    }

    public int getLOC() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.children.length) {
            n += this.children[n2].getLOC();
            ++n2;
        }
        return n;
    }

    public int getNumberOfMethods() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.children.length) {
            n += this.children[n2].getNumberOfMethods();
            ++n2;
        }
        return n;
    }
}

