/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.plugin;

import java.io.IOException;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.eclipse.core.PluginConstants;
import net.sourceforge.pmd.eclipse.core.ext.RuleSetsExtensionProcessor;
import net.sourceforge.pmd.eclipse.core.impl.RuleSetManagerImpl;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesFactory;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferencesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.IPropertiesFactory;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.PropertiesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.writer.IAstWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.impl.WriterFactoryImpl;
import net.sourceforge.pmd.eclipse.ui.nls.StringTable;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PMDPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "net.sourceforge.pmd.eclipse.plugin";
    private static PMDPlugin plugin;
    private static final Logger log;
    private StringTable stringTable;
    private String[] priorityLabels;
    public static final String ROOT_LOG_ID = "net.sourceforge.pmd";
    private static final String PMD_ECLIPSE_APPENDER_NAME = "PMDEclipseAppender";
    private IPreferencesFactory preferencesFactory = new PreferencesFactoryImpl();
    private IPropertiesFactory propertiesFactory = new PropertiesFactoryImpl();
    private final IRuleSetManager ruleSetManager = new RuleSetManagerImpl();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.plugin.PMDPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.configureLogs(this.loadPreferences());
        this.registerStandardRuleSets();
        this.registerAdditionalRuleSets();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static PMDPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
    }

    public Image getImage(String string, String string2) {
        ImageDescriptor imageDescriptor;
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(string);
        if (image == null && (imageDescriptor = PMDPlugin.getImageDescriptor(string2)) != null) {
            imageRegistry.put(string, imageDescriptor);
            image = imageRegistry.get(string);
        }
        return image;
    }

    public void logError(String string, Throwable throwable) {
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, String.valueOf(string) + throwable.getMessage(), throwable));
        if (log != null) {
            log.error((Object)string, throwable);
        }
    }

    public void logError(IStatus iStatus) {
        this.getLog().log(iStatus);
        if (log != null) {
            log.error((Object)iStatus.getMessage(), iStatus.getException());
        }
    }

    public void showError(final String string, final Throwable throwable) {
        this.logError(string, throwable);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)PMDPlugin.this.getStringTable().getString("message.error.title"), (String)(String.valueOf(string) + String.valueOf(throwable)));
            }
        });
    }

    public StringTable getStringTable() {
        if (this.stringTable == null) {
            this.stringTable = new StringTable();
        }
        return this.stringTable;
    }

    public Integer[] getPriorityValues() {
        return new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5)};
    }

    public String[] getPriorityLabels() {
        if (this.priorityLabels == null) {
            StringTable stringTable = this.getStringTable();
            this.priorityLabels = new String[]{stringTable.getString("priority.error_high"), stringTable.getString("priority.error"), stringTable.getString("priority.warning_high"), stringTable.getString("priority.warning"), stringTable.getString("priority.information")};
        }
        return this.priorityLabels;
    }

    public IPreferences loadPreferences() {
        return this.getPreferencesManager().loadPreferences();
    }

    public IPreferencesManager getPreferencesManager() {
        return this.preferencesFactory.getPreferencesManager();
    }

    public IProjectPropertiesManager getPropertiesManager() {
        return this.propertiesFactory.getProjectPropertiesManager();
    }

    public IProjectProperties loadProjectProperties(IProject iProject) throws PropertiesException {
        return this.getPropertiesManager().loadProjectProperties(iProject);
    }

    public void logInformation(String string) {
        this.getLog().log((IStatus)new Status(1, this.getBundle().getSymbolicName(), 0, string, null));
    }

    public IAstWriter getAstWriter() {
        return new WriterFactoryImpl().getAstWriter();
    }

    public IRuleSetWriter getRuleSetWriter() {
        return new WriterFactoryImpl().getRuleSetWriter();
    }

    public void applyLogPreferences(IPreferences iPreferences) {
        Logger logger = Logger.getLogger((String)ROOT_LOG_ID);
        logger.setLevel(iPreferences.getLogLevel());
        RollingFileAppender rollingFileAppender = (RollingFileAppender)logger.getAppender(PMD_ECLIPSE_APPENDER_NAME);
        if (rollingFileAppender == null) {
            this.configureLogs(iPreferences);
        } else if (!rollingFileAppender.getFile().equals(iPreferences.getLogFileName())) {
            rollingFileAppender.setFile(iPreferences.getLogFileName());
            rollingFileAppender.activateOptions();
        }
    }

    private void configureLogs(IPreferences iPreferences) {
        try {
            PatternLayout patternLayout = new PatternLayout("%d{yyyy/MM/dd HH:mm:ss,SSS} %-5p %-32c{1} %m%n");
            RollingFileAppender rollingFileAppender = new RollingFileAppender((Layout)patternLayout, iPreferences.getLogFileName());
            rollingFileAppender.setName(PMD_ECLIPSE_APPENDER_NAME);
            rollingFileAppender.setMaxBackupIndex(1);
            rollingFileAppender.setMaxFileSize("10MB");
            Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)patternLayout));
            Logger.getRootLogger().setLevel(Level.WARN);
            Logger.getRootLogger().setAdditivity(false);
            Logger.getLogger((String)ROOT_LOG_ID).addAppender((Appender)rollingFileAppender);
            Logger.getLogger((String)ROOT_LOG_ID).setLevel(iPreferences.getLogLevel());
            Logger.getLogger((String)ROOT_LOG_ID).setAdditivity(false);
        }
        catch (IOException iOException) {
            this.logError("IO Exception when configuring logging.", iOException);
        }
    }

    public final IRuleSetManager getRuleSetManager() {
        return this.ruleSetManager;
    }

    public final void log(int n, String string, Throwable throwable) {
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            this.getLog().log((IStatus)new Status(n, bundle.getSymbolicName(), 0, string, throwable));
        }
    }

    private void registerStandardRuleSets() {
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        int n = 0;
        while (n < PluginConstants.PMD_RULESETS.length) {
            try {
                RuleSet ruleSet = ruleSetFactory.createRuleSets(PluginConstants.PMD_RULESETS[n]).getAllRuleSets()[0];
                this.getRuleSetManager().registerRuleSet(ruleSet);
                this.getRuleSetManager().registerDefaultRuleSet(ruleSet);
            }
            catch (RuleSetNotFoundException ruleSetNotFoundException) {
                this.log(2, "The RuleSet \"" + PluginConstants.PMD_RULESETS[n] + "\" cannot be found", ruleSetNotFoundException);
            }
            ++n;
        }
    }

    private void registerAdditionalRuleSets() {
        try {
            RuleSetsExtensionProcessor ruleSetsExtensionProcessor = new RuleSetsExtensionProcessor(this.getRuleSetManager());
            ruleSetsExtensionProcessor.process();
        }
        catch (CoreException coreException) {
            this.log(4, "Error when processing RuleSets extensions", coreException);
        }
    }
}

