/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers;

import java.util.Map;
import java.util.Properties;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.model.ReferenceObjectImpl;
import org.jboss.tools.struts.model.StrutsProcessImpl;
import org.jboss.tools.struts.model.handlers.page.create.CreatePageSupport;

public class StrutsAdoptManager
implements XAdoptManager,
StrutsConstants {
    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (this.isAdoptableJSP(target, object)) {
            this.adoptJSP(target, object, p);
        } else if (this.isAdoptableProcessItem(target, object)) {
            this.adoptProcessItem(target, object, p);
        } else if (this.isAdoptableTile(target, object)) {
            this.adoptTile(target, object, p);
        } else if (this.isAdoptableBundle(object)) {
            this.adoptBundle(target, object, p);
        }
    }

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        if (this.isAdoptableBundle(object)) {
            return true;
        }
        if (this.isAdoptableJSP(target, object)) {
            return true;
        }
        if (this.isAdoptableProcessItem(target, object)) {
            return true;
        }
        return this.isAdoptableTile(target, object);
    }

    private boolean isAdoptableJSP(XModelObject target, XModelObject object) {
        String entity = object.getModelEntity().getName();
        if ("FileJSP".equals(entity) || "FileHTML".equals(entity)) {
            String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
            if (target.getModelEntity().getName().startsWith("StrutsConfig")) {
                target = target.getChildByPath("process");
            }
            return ((StrutsProcessImpl)target).getHelper().getPage(path) == null;
        }
        return false;
    }

    private void adoptJSP(XModelObject target, XModelObject object, Properties p) {
        if (target.getModelEntity().getName().startsWith("StrutsConfig")) {
            target = target.getChildByPath("process");
        }
        Properties runningProperties = new Properties();
        runningProperties.put("preselectedObject", object);
        if (p != null) {
            runningProperties.putAll((Map<?, ?>)p);
        }
        XActionInvoker.invoke((String)"CreateActions.CreatePage", (XModelObject)target, (Properties)runningProperties);
    }

    private boolean isAdoptableProcessItem(XModelObject target, XModelObject object) {
        if (object == null) {
            return false;
        }
        if ("StrutsProcessComment".equals(object.getModelEntity().getName())) {
            return false;
        }
        if (object instanceof ReferenceObjectImpl && ((ReferenceObjectImpl)object).getReference() == null) {
            return false;
        }
        return target != null && object.isActive() && target.getChildByPath(object.getParent().getPathPart()) != null;
    }

    private void adoptProcessItem(XModelObject target, XModelObject object, Properties p) {
        if ((target = target.getChildByPath(object.getParent().getPathPart())) == null) {
            return;
        }
        if ("StrutsProcessComment".equals(object.getModelEntity().getName())) {
            return;
        }
        XAction a = object.getModelEntity().getActionList().getAction("CopyActions.Copy");
        try {
            a.executeHandler(object, p);
        }
        catch (XModelException e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
        a = target.getModelEntity().getActionList().getAction("CopyActions.Paste");
        try {
            a.executeHandler(target, p);
        }
        catch (XModelException e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private boolean isAdoptableTile(XModelObject target, XModelObject object) {
        String entity = object.getModelEntity().getName();
        if ("TilesDefinition".equals(entity)) {
            String path = object.getAttributeValue("name");
            if (target.getModelEntity().getName().startsWith("StrutsConfig")) {
                target = target.getChildByPath("process");
            }
            return ((StrutsProcessImpl)target).getHelper().getPage(path) == null;
        }
        return false;
    }

    private void adoptTile(XModelObject target, XModelObject object, Properties p) {
        if (target.getModelEntity().getName().startsWith("StrutsConfig")) {
            target = target.getChildByPath("process");
        }
        String path = object.getAttributeValue("name");
        try {
            ((StrutsProcessImpl)target).getHelper().updateTiles();
            CreatePageSupport.createPage(target, path, p);
        }
        catch (Exception e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected boolean isAdoptableBundle(XModelObject object) {
        return "FilePROPERTIES".equals(object.getModelEntity().getName());
    }

    public void adoptBundle(XModelObject target, XModelObject object, Properties p) {
        if (p == null) {
            return;
        }
        String res = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        if (res == null) {
            return;
        }
        if (res != null && res.endsWith(".properties")) {
            res = res.substring(1, res.length() - 11).replace('/', '.');
        }
        p.setProperty("start text", res);
        p.setProperty("end text", "");
    }
}

