/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers;

import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.action.impl.handlers.HUtil;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMessageResourcesHandler
extends AbstractHandler {
    public boolean isEnabled(XModelObject object) {
        return object != null;
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        String parameter = object.getAttributeValue("parameter");
        if (parameter == null || parameter.length() == 0) {
            return;
        }
        String path = "/" + parameter.replace('.', '/') + ".properties";
        XModelObject[] os = OpenMessageResourcesHandler.getResourceObject(object);
        if (os == null || os.length == 0) {
            ServiceDialog d = object.getModel().getService();
            d.showDialog("Warning", "Resource " + path + " is not found.", new String[]{"Ok"}, null, 2);
        } else {
            XModelObject selected;
            XModelObject xModelObject = selected = os.length == 1 ? os[0] : this.select(os);
            if (selected != null) {
                XActionInvoker.invoke((String)"Open", (XModelObject)selected, null);
            }
        }
    }

    private XModelObject select(XModelObject[] os) {
        TreeMap<String, XModelObject> map = new TreeMap<String, XModelObject>();
        int i = 0;
        while (i < os.length) {
            String n = FileAnyImpl.toFileName((XProperty)((FileAnyImpl)os[i]));
            map.put(n, os[i]);
            ++i;
        }
        String[] ns = map.keySet().toArray(new String[0]);
        XEntityDataImpl data = XEntityDataImpl.create((String[][])new String[][]{{"StrutsSelectResourceWizard"}, {"resource", "yes"}});
        data.setValue("resource", ns[0]);
        HUtil.hackAttributeConstraintList((XEntityData[])new XEntityData[]{data}, (int)0, (String)"resource", (String[])ns);
        ServiceDialog d = os[0].getModel().getService();
        int q = d.showDialog("Open Resource", "Please select resource.", new String[]{"OK", "Cancel"}, (XEntityData)data, 0);
        return q != 0 ? null : (XModelObject)map.get(data.getValue("resource"));
    }

    public static boolean isReferencingResourceObject(XModelObject strutsResource) {
        String parameter = strutsResource.getAttributeValue("parameter");
        return parameter != null && parameter.length() > 0;
    }

    public static XModelObject[] getResourceObject(XModelObject strutsResource) {
        if (!OpenMessageResourcesHandler.isReferencingResourceObject(strutsResource)) {
            return null;
        }
        String parameter = strutsResource.getAttributeValue("parameter");
        String path = "/" + parameter.replace('.', '/') + ".properties";
        XModelObject[] os = OpenMessageResourcesHandler.getResourceObjectFromModel(strutsResource.getModel(), path);
        if (os != null) {
            return os;
        }
        return OpenMessageResourcesHandler.getResourceObjectFromClasspath(strutsResource, path);
    }

    static XModelObject[] getResourceObjectFromClasspath(XModelObject strutsResource, String path) {
        IResource[] ps = EclipseResourceUtil.getClasspathResources((IProject)EclipseResourceUtil.getProject((XModelObject)strutsResource));
        int i = 0;
        while (i < ps.length) {
            XModelObject[] os = OpenMessageResourcesHandler.getResourceObjectFromClasspathResource(ps[i], path);
            if (os != null && os.length != 0) {
                return os;
            }
            ++i;
        }
        return null;
    }

    static XModelObject[] getResourceObjectFromClasspathResource(IResource resource, String path) {
        XModelObject[] xModelObjectArray;
        if (resource instanceof IProject) {
            XModelObject o;
            XModel model;
            IProject p = (IProject)resource;
            IModelNature n = EclipseResourceUtil.getModelNature((IProject)p);
            XModel xModel = model = n != null ? n.getModel() : null;
            if (model == null && (o = EclipseResourceUtil.createObjectForResource((IResource)p)) != null) {
                model = o.getModel();
            }
            return model == null ? null : OpenMessageResourcesHandler.getResourceObjectFromModel(model, path);
        }
        XModelObject o = null;
        XModelObject ro = EclipseResourceUtil.getObjectByResource((IResource)resource);
        if (ro == null && resource instanceof IContainer) {
            ro = EclipseResourceUtil.createObjectForResource((IResource)resource);
        } else if (ro == null && resource instanceof IFile && resource.getName().endsWith(".jar")) {
            ro = EclipseResourceUtil.createObjectForResource((IResource)resource);
            if (ro == null) {
                EclipseResourceUtil.createObjectForResource((IResource)resource.getProject());
            }
            if (ro != null) {
                return OpenMessageResourcesHandler.getResourceObjectFromModel(ro.getModel(), path);
            }
        }
        if (ro == null) {
            return null;
        }
        o = ro.getChildByPath(path.substring(1));
        if (o == null && ro.getFileType() == 1) {
            o = ro.getModel().getByPath(path);
        }
        if (o == null) {
            xModelObjectArray = null;
        } else {
            XModelObject[] xModelObjectArray2 = new XModelObject[1];
            xModelObjectArray = xModelObjectArray2;
            xModelObjectArray2[0] = o;
        }
        return xModelObjectArray;
    }

    static XModelObject[] getResourceObjectFromModel(XModel model, String path) {
        XModelObject o = model.getByPath(path);
        ArrayList<XModelObject> l = new ArrayList<XModelObject>();
        if (o != null) {
            String n = o.getAttributeValue("name");
            int s = n.indexOf("_");
            if (s >= 0) {
                n = n.substring(0, s);
            }
            OpenMessageResourcesHandler.findInFolder(o.getParent(), n, l);
        } else {
            int s = path.lastIndexOf("/");
            String fileName = path.substring(s + 1);
            String n = fileName.substring(0, fileName.length() - ".properties".length());
            int s_ = n.indexOf("_");
            if (s_ >= 0) {
                n = n.substring(0, s_);
            }
            if (s > 0) {
                XModelObject p = model.getByPath(path.substring(0, s));
                OpenMessageResourcesHandler.findInFolder(p, n, l);
            } else {
                XModelObject fs = model.getByPath("FileSystems");
                if (fs == null) {
                    return null;
                }
                XModelObject[] os = fs.getChildren("FileSystemFolder");
                int i = 0;
                while (i < os.length) {
                    OpenMessageResourcesHandler.findInFolder(os[i], n, l);
                    ++i;
                }
            }
        }
        return l.size() == 0 ? null : l.toArray(new XModelObject[l.size()]);
    }

    static void findInFolder(XModelObject parent, String n, ArrayList<XModelObject> list) {
        if (parent == null) {
            return;
        }
        XModelObject[] cs = parent.getChildren("FilePROPERTIES");
        int i = 0;
        while (i < cs.length) {
            String in = cs[i].getAttributeValue("name");
            if (in.equals(n) || in.startsWith(String.valueOf(n) + "_")) {
                list.add(cs[i]);
            }
            ++i;
        }
    }
}

