/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.editors.DiagramViewer;
import org.jboss.tools.hibernate.ui.diagram.editors.command.ToggleShapeVisibleStateCommand;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmEditPart;

public class ShapeHideAction
extends SelectionAction {
    public static final String ACTION_ID = "shapeHideId";
    public static final ImageDescriptor img = ImageDescriptor.createFromFile(DiagramViewer.class, (String)"icons/shapehide.png");

    public ShapeHideAction(IWorkbenchPart editor) {
        super(editor);
        this.setId(ACTION_ID);
        this.setText(DiagramViewerMessages.ShapeHideAction_shape_hide);
        this.setToolTipText(DiagramViewerMessages.ShapeHideAction_shape_hide_tooltip);
        this.setImageDescriptor(img);
    }

    protected DiagramViewer getDiagramViewer() {
        return (DiagramViewer)this.getWorkbenchPart();
    }

    public void run() {
        this.execute(this.getCommand());
        if (this.getDiagramViewer() != null) {
            this.getDiagramViewer().updateSelectionActions();
        }
    }

    public Command getCommand() {
        CompoundCommand cc = new CompoundCommand();
        if (this.getSelectedObjects().isEmpty()) {
            return cc;
        }
        ArrayList<OrmShape> selectedShape = new ArrayList<OrmShape>();
        for (Object firstElement : this.getSelectedObjects()) {
            OrmShape ormShape;
            Object obj = null;
            if (firstElement instanceof OrmEditPart) {
                obj = ((OrmEditPart)firstElement).getModel();
            } else if (firstElement instanceof AbstractTreeEditPart) {
                obj = ((AbstractTreeEditPart)firstElement).getModel();
            }
            if (obj == null || !(obj instanceof OrmShape) || !(ormShape = (OrmShape)obj).isVisible()) continue;
            selectedShape.add(ormShape);
        }
        if (selectedShape.size() > 0) {
            cc.add((Command)new ToggleShapeVisibleStateCommand(selectedShape, null));
        }
        return cc;
    }

    protected boolean calculateEnabled() {
        return this.canPerformAction();
    }

    private boolean canPerformAction() {
        boolean res = false;
        if (this.getSelectedObjects().isEmpty()) {
            return res;
        }
        Iterator it = this.getSelectedObjects().iterator();
        while (it.hasNext() && !res) {
            OrmShape ormShape;
            Object ormElement;
            Object firstElement = it.next();
            Object obj = null;
            if (firstElement instanceof OrmEditPart) {
                obj = ((OrmEditPart)firstElement).getModel();
            } else if (firstElement instanceof AbstractTreeEditPart) {
                obj = ((AbstractTreeEditPart)firstElement).getModel();
            }
            if (obj == null || !(obj instanceof OrmShape) || !((ormElement = (ormShape = (OrmShape)obj).getOrmElement()) instanceof PersistentClass) && !(ormElement instanceof Table) || !ormShape.isVisible()) continue;
            res = true;
        }
        return res;
    }
}

