/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.util.xpl.StringHelper;

public class ConfigurationXMLFactory {
    protected ConsoleConfigurationPreferences prefs;
    protected Properties additional;
    protected IPath pathPlace2Generate = null;
    protected IPath pathWorkspacePath = null;

    public ConfigurationXMLFactory(ConsoleConfigurationPreferences prefs, Properties additional) {
        this.prefs = prefs;
        this.additional = additional;
    }

    public Document createXML() {
        Document res = DocumentFactory.getInstance().createDocument();
        Element root = this.createRoot();
        res.setRootElement(root);
        return res;
    }

    public Element createRoot() {
        if (this.prefs == null) {
            return null;
        }
        this.prefs.getProperties();
        String rootName = "undef";
        Boolean jdbcConfig = Boolean.valueOf(this.additional.getProperty("isRevEng", "false"));
        if (jdbcConfig.booleanValue()) {
            rootName = "jdbcconfiguration";
        } else if (this.prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS)) {
            rootName = "annotationconfiguration";
        } else if (this.prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA)) {
            rootName = "jpaconfiguration";
        } else if (this.prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.CORE)) {
            rootName = "configuration";
        }
        Element root = DocumentFactory.getInstance().createElement(rootName);
        ConsoleConfiguration cc2ExtractConfigXMLFile = new ConsoleConfiguration(this.prefs);
        File configXMLFile = cc2ExtractConfigXMLFile.getConfigXMLFile();
        String tmp = ConfigurationXMLFactory.file2Str(configXMLFile);
        tmp = ConfigurationXMLFactory.makePathRelative(tmp, this.pathPlace2Generate, this.pathWorkspacePath);
        ConfigurationXMLFactory.updateAttr(root, tmp, "configurationFile");
        tmp = ConfigurationXMLFactory.file2Str(this.prefs.getPropertyFile());
        tmp = ConfigurationXMLFactory.makePathRelative(tmp, this.pathPlace2Generate, this.pathWorkspacePath);
        ConfigurationXMLFactory.updateAttr(root, tmp, "propertyFile");
        ConfigurationXMLFactory.updateAttr(root, this.prefs.getEntityResolverName(), "entityResolver");
        ConfigurationXMLFactory.updateAttr(root, this.prefs.getNamingStrategy(), "namingStrategy");
        ConfigurationXMLFactory.updateAttr(root, this.prefs.getPersistenceUnitName(), "persistenceUnit");
        ConfigurationXMLFactory.updateAttr(root, this.additional, "detectManyToMany");
        ConfigurationXMLFactory.updateAttr(root, this.additional, "detectOneToOne");
        ConfigurationXMLFactory.updateAttr(root, this.additional, "detectOptimisticLock");
        ConfigurationXMLFactory.updateAttr(root, this.additional, "packageName");
        ConfigurationXMLFactory.updateAttr(root, this.additional, "revEngFile");
        ConfigurationXMLFactory.updateAttr(root, this.additional, "reverseStrategy");
        File[] mappingFiles = this.prefs.getMappingFiles();
        if (mappingFiles.length > 0) {
            Element fileset = root.addElement("fileset");
            fileset.addAttribute("dir", ".");
            fileset.addAttribute("id", "id");
            int i = 0;
            while (i < mappingFiles.length) {
                Element include = fileset.addElement("include");
                tmp = mappingFiles[i].getAbsolutePath();
                tmp = new Path(tmp).toString();
                tmp = ConfigurationXMLFactory.makePathRelative(tmp, this.pathPlace2Generate, this.pathWorkspacePath);
                include.addAttribute("name", tmp);
                ++i;
            }
        }
        return root;
    }

    public static String file2Str(File file) {
        String res;
        String string = res = file == null ? null : file.getPath();
        if (res != null) {
            res = new Path(res).toString();
        }
        return res;
    }

    public static void updateAttr(Element el, String val, String prName) {
        if (!StringHelper.isEmpty(val)) {
            el.addAttribute(prName, val);
        }
    }

    public static void updateAttr(Element el, Properties prs, String prName) {
        String val = prs.getProperty(prName, "");
        if (!StringHelper.isEmpty(val)) {
            el.addAttribute(prName, val);
        }
    }

    public String createConfigurationXML() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element element = this.createRoot();
        ConfigurationXMLFactory.dump(baos, element);
        return baos.toString();
    }

    public static void dump(OutputStream os, Element element) {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        try {
            XMLWriter writer = new XMLWriter(os, outformat);
            writer.write(element);
            writer.flush();
        }
        catch (IOException iOException) {
            try {
                os.write(element.asXML().getBytes());
            }
            catch (IOException iOException2) {}
        }
    }

    public static String makePathRelative(String strPathItem, IPath pathPlace2Generate, IPath pathWorkspacePath) {
        Path tmpPath;
        if (strPathItem != null && pathPlace2Generate != null && pathWorkspacePath != null && pathWorkspacePath.isPrefixOf((IPath)(tmpPath = new Path(strPathItem)))) {
            tmpPath = tmpPath.makeRelativeTo(pathPlace2Generate);
            strPathItem = pathPlace2Generate.toString();
            String tmp = tmpPath.toString();
            if (tmp.length() > 0) {
                strPathItem = String.valueOf(strPathItem) + '/' + tmp;
            }
        }
        return strPathItem;
    }

    public void setPlace2Generate(IPath pathPlace2Generate) {
        this.pathPlace2Generate = pathPlace2Generate;
    }

    public IPath getPlace2Generate() {
        return this.pathPlace2Generate;
    }

    public void setWorkspacePath(IPath pathWorkspacePath) {
        this.pathWorkspacePath = pathWorkspacePath;
    }

    public IPath getWorkspacePath() {
        return this.pathWorkspacePath;
    }
}

