/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.query;

import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.meta.help.HelpUtil;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.ui.ModelUIMessages;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarListener;

public abstract class AbstractQueryWizardView
implements CommandBarListener {
    public static String CANCEL = ModelUIMessages.AbstractQueryWizardView_Cancel;
    public static String CLOSE = ModelUIMessages.AbstractQueryWizardView_Close;
    public static String OK = ModelUIMessages.AbstractQueryWizardView_OK;
    public static String HELP = ModelUIMessages.AbstractQueryWizardView_Help;
    private String helpkey = null;
    private Dialog dialog;
    private TitleAreaDialog titleDialog = null;
    private int code = 1;
    protected CommandBar commandBar = new CommandBar();
    protected XModel model;
    protected String windowTitle;
    private String title = "";
    private String message;
    private String errorMessage;
    private Image titleImage;

    public void setModel(XModel model) {
        this.model = model;
    }

    public CommandBar getCommandBar() {
        return this.commandBar;
    }

    public String[] getCommands() {
        return new String[]{OK, CANCEL};
    }

    public String getDefaultCommand() {
        return OK;
    }

    public abstract Control createControl(Composite var1);

    public void setObject(Object object) {
        Properties p = this.findProperties(object);
        if (p != null) {
            String key = p.getProperty("help");
            this.setHelpKey(key);
            this.windowTitle = WizardKeys.getHeader((String)key);
            this.title = WizardKeys.getTitle((String)key);
            if (this.title == null) {
                this.title = p.getProperty("title", "");
            }
        }
    }

    protected Properties findProperties(Object o) {
        if (o instanceof Properties) {
            return (Properties)o;
        }
        if (!(o instanceof Object[])) {
            return null;
        }
        Object[] os = (Object[])o;
        int i = 0;
        while (i < os.length) {
            if (os[i] instanceof Properties) {
                return (Properties)os[i];
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        if (this.titleDialog != null) {
            this.titleDialog.close();
        }
        this.titleDialog = null;
        if (this.dialog != null) {
            this.dialog.close();
        }
        this.dialog = null;
        if (this.commandBar != null) {
            this.commandBar.dispose();
        }
        this.commandBar = null;
    }

    public void stopEditing() {
    }

    public void action(String command) {
        this.stopEditing();
        if (CANCEL.equals(command)) {
            this.code = 1;
            this.dispose();
        } else if (OK.equalsIgnoreCase(command)) {
            this.code = 0;
            this.dispose();
        } else if (HELP.equals(command)) {
            HelpUtil.helpEclipse((XModel)this.model, (String)this.helpkey);
        }
    }

    public int code() {
        return this.code;
    }

    public void exception(Exception e) {
        ModelUIPlugin.getPluginLog().logError((Throwable)e);
    }

    public void setHelpKey(String key) {
        this.helpkey = key;
    }

    public String getHelpKey() {
        return this.helpkey;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
        if (this.titleDialog != null) {
            this.titleDialog.setErrorMessage(this.errorMessage);
        }
    }

    public void setMessage(String string) {
        this.message = string;
        if (this.titleDialog != null) {
            this.titleDialog.setMessage(this.message);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.title != null && this.titleDialog != null) {
            this.titleDialog.setTitle(this.title);
        }
    }

    public void setWindowTitle(String string) {
        this.windowTitle = string;
        if (this.windowTitle != null && this.dialog != null) {
            this.dialog.getShell().setText(this.windowTitle);
        }
    }

    public void setTitleImage(Image image) {
        this.titleImage = image;
        if (this.titleImage != null && this.titleDialog != null) {
            this.titleDialog.setTitleImage(this.titleImage);
        } else {
            this.titleDialog.setTitleImage(ModelUIImages.getImage(ModelUIImages.WIZARD_DEFAULT));
        }
    }

    public void setDialog(Dialog d) {
        this.dialog = d;
        this.titleDialog = this.dialog instanceof TitleAreaDialog ? (TitleAreaDialog)this.dialog : null;
        this.code = 1;
        if (this.windowTitle != null) {
            this.dialog.getShell().setText(this.windowTitle);
        }
        if (this.titleDialog != null) {
            if (this.title != null) {
                this.titleDialog.setTitle(this.title);
            }
            if (this.message != null) {
                this.titleDialog.setMessage(this.message);
            }
            if (this.errorMessage != null) {
                this.titleDialog.setErrorMessage(this.errorMessage);
            }
            if (this.titleImage != null) {
                this.titleDialog.setTitleImage(this.titleImage);
            }
        }
    }

    public Point getPreferredSize() {
        return null;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void updateBar() {
    }
}

